/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.SystemIndexAccess;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.actions.ResolvedIndicesMatcher;
import com.floragunn.searchsupport.meta.Meta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class ResolvedIndicesTest {
    static final Meta META = Meta.Mock.indices((String[])new String[]{"index_a11", "index_a12", "index_a21", "index_a22", "index_b1", "index_b2"}).dataStream("ds_d11").of(new String[]{".ds-ds_d11-2024.03.22-000001", ".ds-ds_d11-2024.03.22-000002"}).dataStream("ds_d12").of(new String[]{".ds-ds_d12-2024.03.22-000001", ".ds-ds_d12-2024.03.22-000002"}).alias("alias_a").of(new String[]{"index_a11", "index_a12", "index_a21", "index_a22"}).alias("alias_a1").of(new String[]{"index_a11", "index_a12"}).alias("alias_a2").of(new String[]{"index_a21", "index_a22"}).alias("alias_b").of(new String[]{"index_b1", "index_b2"});
    static final String NAME_SYSTEM_INDEX_1 = "system_index_1";
    static final String NAME_SYSTEM_INDEX_2 = "system_index_2";
    static final String NAME_SYSTEM_INDEX_3 = "system_index_3";
    static final String NAME_REGULAR_INDEX_1 = "regular_index_1";
    static final String NAME_REGULAR_INDEX_2 = "regular_index_2";
    @Mock
    SystemIndexAccess systemIndexAccess;

    @Test
    public void negationAcrossObjectTypes() {
        ResolvedIndices subject = ResolvedIndicesTest.get(IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, "ds_d1*", "-.ds-ds_d11*");
        MatcherAssert.assertThat((Object)subject, (Matcher)ResolvedIndicesMatcher.hasNoIndices().hasNoAliases().hasDataStreams("ds_d12"));
    }

    @Test
    public void negationAcrossObjectTypes2() {
        ResolvedIndices subject = ResolvedIndicesTest.get(IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, "ds_d1*", "-.ds-ds_d11-2024.03.22-000001");
        MatcherAssert.assertThat((Object)subject, (Matcher)ResolvedIndicesMatcher.hasIndices(".ds-ds_d11-2024.03.22-000002").hasNoAliases().hasDataStreams("ds_d12"));
    }

    @Test
    public void shouldExcludeSystemIndicesDuringResolveAll() {
        IndexMetadata systemIndex = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_1, true);
        IndexMetadata regularIndex = ResolvedIndicesTest.createIndexMetadata(NAME_REGULAR_INDEX_1, false);
        Meta meta = ResolvedIndicesTest.metaForIndexMetadata(systemIndex, regularIndex);
        ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo = new ActionRequestIntrospector.IndicesRequestInfo((List)ImmutableList.of((Object)"*"), IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, SystemIndexAccess.DISALLOWED, meta);
        ResolvedIndices.Local local = ResolvedIndicesTest.getLocalResolver(indicesRequestInfo);
        ResolvedIndicesTest.assertLocalIndices(local, (Matcher<Iterable<? extends String>>)Matchers.contains((Object[])new String[]{NAME_REGULAR_INDEX_1}));
    }

    @Test
    public void shouldIncludeSystemIndicesDuringResolveAll() {
        IndexMetadata systemIndex = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_1, true);
        IndexMetadata regularIndex = ResolvedIndicesTest.createIndexMetadata(NAME_REGULAR_INDEX_1, false);
        Meta meta = ResolvedIndicesTest.metaForIndexMetadata(systemIndex, regularIndex);
        Mockito.when((Object)this.systemIndexAccess.isAllowed((Meta.IndexLikeObject)Mockito.any())).thenReturn((Object)true);
        ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo = new ActionRequestIntrospector.IndicesRequestInfo((List)ImmutableList.of((Object)"*"), IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, this.systemIndexAccess, meta);
        ResolvedIndices.Local local = ResolvedIndicesTest.getLocalResolver(indicesRequestInfo);
        ResolvedIndicesTest.assertLocalIndices(local, (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])new String[]{NAME_REGULAR_INDEX_1, NAME_SYSTEM_INDEX_1}));
    }

    @Test
    public void shouldExcludeAllSystemIndicesDuringResolveLocal() {
        IndexMetadata systemIndex1 = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_1, true);
        IndexMetadata systemIndex2 = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_2, true);
        IndexMetadata systemIndex3 = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_3, true);
        Meta meta = ResolvedIndicesTest.metaForIndexMetadata(systemIndex1, systemIndex2, systemIndex3);
        ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo = new ActionRequestIntrospector.IndicesRequestInfo((List)ImmutableList.of((Object)"*"), IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, SystemIndexAccess.DISALLOWED, meta);
        ResolvedIndices.Local local = ResolvedIndicesTest.getLocalResolver(indicesRequestInfo);
        ResolvedIndicesTest.assertLocalIndices(local, (Matcher<Iterable<? extends String>>)Matchers.emptyIterable());
    }

    @Test
    public void shouldFilterOutSystemIndicesDuringResolveLocal() {
        IndexMetadata regularIndex1 = ResolvedIndicesTest.createIndexMetadata(NAME_REGULAR_INDEX_1, false);
        IndexMetadata regularIndex2 = ResolvedIndicesTest.createIndexMetadata(NAME_REGULAR_INDEX_2, false);
        IndexMetadata systemIndex1 = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_1, true);
        IndexMetadata systemIndex2 = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_2, true);
        IndexMetadata systemIndex3 = ResolvedIndicesTest.createIndexMetadata(NAME_SYSTEM_INDEX_3, true);
        Meta meta = ResolvedIndicesTest.metaForIndexMetadata(regularIndex1, systemIndex1, systemIndex2, regularIndex2, systemIndex3);
        ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo = new ActionRequestIntrospector.IndicesRequestInfo((List)ImmutableList.of((Object)"*"), IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, SystemIndexAccess.DISALLOWED, meta);
        ResolvedIndices.Local local = ResolvedIndicesTest.getLocalResolver(indicesRequestInfo);
        ResolvedIndicesTest.assertLocalIndices(local, (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])new String[]{NAME_REGULAR_INDEX_1, NAME_REGULAR_INDEX_2}));
    }

    @Test
    public void shouldIncludeNonSystemIndicesDuringResolveLocal() {
        IndexMetadata regularIndex1 = ResolvedIndicesTest.createIndexMetadata(NAME_REGULAR_INDEX_1, false);
        IndexMetadata regularIndex2 = ResolvedIndicesTest.createIndexMetadata(NAME_REGULAR_INDEX_2, false);
        Meta meta = ResolvedIndicesTest.metaForIndexMetadata(regularIndex1, regularIndex2);
        ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo = new ActionRequestIntrospector.IndicesRequestInfo((List)ImmutableList.of((Object)"*"), IndicesOptions.LENIENT_EXPAND_OPEN, ActionRequestIntrospector.IndicesRequestInfo.Scope.ANY, SystemIndexAccess.DISALLOWED, meta);
        ResolvedIndices.Local local = ResolvedIndicesTest.getLocalResolver(indicesRequestInfo);
        ResolvedIndicesTest.assertLocalIndices(local, (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])new String[]{NAME_REGULAR_INDEX_1, NAME_REGULAR_INDEX_2}));
    }

    private static void assertLocalIndices(ResolvedIndices.Local local, Matcher<Iterable<? extends String>> expectedLocalIndexNames) {
        List indexNames = local.getPureIndices().stream().map(Meta.IndexLikeObject::name).collect(Collectors.toList());
        MatcherAssert.assertThat(indexNames, expectedLocalIndexNames);
    }

    private static ResolvedIndices.Local getLocalResolver(ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo) {
        ResolvedIndices resolvedIndices = new ResolvedIndices(true, ResolvedIndices.Local.EMPTY, ImmutableSet.empty(), ImmutableSet.of((Object)indicesRequestInfo));
        ResolvedIndices.Local local = resolvedIndices.getLocal();
        return local;
    }

    private static Meta metaForIndexMetadata(IndexMetadata ... indexMetadata) {
        Metadata esMetadata = (Metadata)Mockito.mock(Metadata.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ImmutableOpenMap<String, IndexMetadata> indicesMetadataMap = ResolvedIndicesTest.createIndexMetaMap(indexMetadata);
        ProjectMetadata project = esMetadata.getProject();
        Mockito.when((Object)project.indices()).thenReturn(indicesMetadataMap);
        Mockito.when((Object)project.indices()).thenReturn(indicesMetadataMap);
        return Meta.from((Metadata)esMetadata);
    }

    private static ImmutableOpenMap<String, IndexMetadata> createIndexMetaMap(IndexMetadata ... indexMetadata) {
        ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder();
        Arrays.stream(indexMetadata).forEach(index -> builder.put((Object)index.getIndex().getName(), index));
        return builder.build();
    }

    private static IndexMetadata createIndexMetadata(String indexName, boolean system) {
        IndexMetadata systemIndex = IndexMetadata.builder((String)indexName).settings(Settings.builder().put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), (VersionId)Version.V_7_17_1).build()).numberOfReplicas(0).numberOfShards(1).system(system).build();
        return systemIndex;
    }

    private static ResolvedIndices get(IndicesOptions indicesOptions, ActionRequestIntrospector.IndicesRequestInfo.Scope scope, String ... indices) {
        ActionRequestIntrospector.IndicesRequestInfo indicesRequestInfo = new ActionRequestIntrospector.IndicesRequestInfo((List)ImmutableList.ofArray((Object[])indices), indicesOptions, scope, SystemIndexAccess.DISALLOWED, META);
        return indicesRequestInfo.resolveIndices();
    }
}

