/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.int_tests;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class DataStreamDownsampleIntTest {
    private static final String DATA_STREAM_NAME = "tsds-iot";
    static TestSgConfig.User USER_WITH_ACCESS_TO_DATA_STREAM_AND_TARGET_INDEX = new TestSgConfig.User("ds_target_access").description("access to ds and downsample target index").roles(new TestSgConfig.Role("r1").dataStreamPermissions("indices:admin/data_stream/get", "indices:admin/rollover", "indices:monitor/stats", "indices:admin/block/add", "indices:admin/xpack/downsample").on("tsds-iot").indexPermissions("indices:admin/create").on("downsample_target*"));
    static TestSgConfig.User USER_WITH_ACCESS_ONLY_TO_DATA_STREAM = new TestSgConfig.User("only_ds_access").description("access only to ds").roles(new TestSgConfig.Role("r1").dataStreamPermissions("indices:admin/data_stream/get", "indices:admin/rollover", "indices:monitor/stats", "indices:admin/block/add", "indices:admin/xpack/downsample").on("tsds-iot"));
    static TestSgConfig.User USER_ASYNC_1 = new TestSgConfig.User("async_one").description("async one").roles(new TestSgConfig.Role("async_one").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").dataStreamPermissions("SGS_READ").on("tsds-iot"));
    static TestSgConfig.User USER_ASYNC_2 = new TestSgConfig.User("async_two").description("async two").roles(new TestSgConfig.Role("async_two").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").dataStreamPermissions("SGS_READ").on("tsds-iot"));
    static TestSgConfig.User USER_ASYNC_BYPASS_OWNER_CHECK = new TestSgConfig.User("async_bypass_owner_check").description("async two").roles(new TestSgConfig.Role("async_bypass_owner_check").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO", "indices:searchguard:async_search/_all_owners").dataStreamPermissions("SGS_READ").on("tsds-iot"));
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().authzDebug(true).users(USER_WITH_ACCESS_TO_DATA_STREAM_AND_TARGET_INDEX, USER_WITH_ACCESS_ONLY_TO_DATA_STREAM, USER_ASYNC_1, USER_ASYNC_2, USER_ASYNC_BYPASS_OWNER_CHECK).enterpriseModulesEnabled().dlsFls(new TestSgConfig.DlsFls()).useExternalProcessCluster().build();

    @BeforeClass
    public static void beforeClass() throws Exception {
        try (GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminCertClient.putJson("_index_template/tsds-iot-template", (Document<?>)DocNode.of((String)"index_patterns", Collections.singletonList("tsds-iot*"), (String)"data_stream", (Object)DocNode.EMPTY, (String)"template", (Object)DocNode.of((String)"settings.index.mode", (Object)"time_series", (String)"settings.index.routing_path", (Object)"device_id", (String)"mappings.properties.device_id.type", (Object)"keyword", (String)"mappings.properties.device_id.time_series_dimension", (Object)true, (String)"mappings.properties.temperature.type", (Object)"half_float", (Object[])new Object[]{"mappings.properties.temperature.time_series_metric", "gauge", "mappings.properties.@timestamp.type", "date"})));
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = adminCertClient.postJson("tsds-iot/_bulk?refresh=true", String.format("{\"create\": {}}\n{ \"@timestamp\": \"%s\", \"device_id\": \"1\", \"temperature\": 30.5 }\n{\"create\": {}}\n{ \"@timestamp\": \"%s\", \"device_id\": \"2\", \"temperature\": 14 }\n{\"create\": {}}\n{ \"@timestamp\": \"%s\", \"device_id\": \"1\", \"temperature\": 18 }\n{\"create\": {}}\n{ \"@timestamp\": \"%s\", \"device_id\": \"2\", \"temperature\": 10.5 }\n", Instant.now().minus(10L, ChronoUnit.MINUTES).toString(), Instant.now().minus(15L, ChronoUnit.MINUTES).toString(), Instant.now().minus(7L, ChronoUnit.MINUTES).toString(), Instant.now().plus(3L, ChronoUnit.MINUTES)), new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("errors", Matchers.equalTo((Object)false))}));
            MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.items[*].create.result", Matchers.hasSize((int)4))}));
            MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("$.items[*].create.result", Matchers.everyItem((Matcher)Matchers.equalTo((Object)"created")))}));
        }
    }

    @Test
    public void testDownsampleTimeSeriesDataStreamIndex() throws Exception {
        String dataStreamBackingIndex;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient(USER_WITH_ACCESS_TO_DATA_STREAM_AND_TARGET_INDEX, new Header[0]);){
            response = client.get("/_data_stream/tsds-iot", new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            dataStreamBackingIndex = (String)response.getBodyAsDocNode().findSingleValueByJsonPath("$.data_streams[0].indices[0].index_name", String.class);
            response = client.post("tsds-iot/_rollover");
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client.put(dataStreamBackingIndex + "/_block/write");
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client.postJson(dataStreamBackingIndex + "/_downsample/downsample_target_1", (Map<String, Object>)DocNode.of((String)"fixed_interval", (Object)"1h"), new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
        }
        client = cluster.getRestClient(USER_WITH_ACCESS_ONLY_TO_DATA_STREAM, new Header[0]);
        try {
            response = client.get("/_data_stream/tsds-iot", new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            dataStreamBackingIndex = (String)response.getBodyAsDocNode().findSingleValueByJsonPath("$.data_streams[0].indices[0].index_name", String.class);
            response = client.post("tsds-iot/_rollover");
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client.put(dataStreamBackingIndex + "/_block/write");
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client.postJson(dataStreamBackingIndex + "/_downsample/downsample_target_2", (Map<String, Object>)DocNode.of((String)"fixed_interval", (Object)"1h"), new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void testAsyncSearch() throws Exception {
        try (GenericRestClient client1 = cluster.getRestClient(USER_ASYNC_1, new Header[0]);
             GenericRestClient client2 = cluster.getRestClient(USER_ASYNC_2, new Header[0]);
             GenericRestClient clientBypassOwnerCheck = cluster.getRestClient(USER_ASYNC_BYPASS_OWNER_CHECK, new Header[0]);){
            GenericRestClient.HttpResponse response = client1.postJson("/tsds-iot/_async_search?&wait_for_completion_timeout=1ms", (Map<String, Object>)DocNode.EMPTY, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            String asyncSearchId = response.getBodyAsDocNode().getAsString("id");
            MatcherAssert.assertThat((Object)asyncSearchId, (Matcher)Matchers.notNullValue());
            response = client1.get("/_async_search/status/" + asyncSearchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            response = client2.get("/_async_search/status/" + asyncSearchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
            Matcher reasonMatcher = Matchers.containsString((String)("is not owned by user " + USER_ASYNC_2.getName()));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.valueSatisfiesMatcher((String)"$.error.reason", String.class, (Matcher)reasonMatcher));
            response = clientBypassOwnerCheck.get("/_async_search/status/" + asyncSearchId, new Header[0]);
            MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
        }
    }
}

