/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.int_tests;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.AsyncAssert;
import java.time.Duration;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.hamcrest.BaseMatcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={StandardConfig.class, SpecialConfig.class})
public class FoundationalTests {
    static TestSgConfig.User ALL_ACCESS_USER = new TestSgConfig.User("all_access").roles("SGS_ALL_ACCESS");

    public static class SpecialConfig {
        @Test
        public void testHTTPSCompressionEnabled() throws Exception {
            try (LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/internal_users_db"))).users(ALL_ACCESS_USER).nodeSettings("http.compression", true).start();
                 GenericRestClient restClient = cluster.getRestClient(ALL_ACCESS_USER, new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.get("_searchguard/sslinfo", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.nodeAt("ssl_protocol", Matchers.is((Object)"TLSv1.2"))}));
                response = restClient.get("_nodes", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.json(new BaseMatcher[]{RestMatchers.singleNodeAt("nodes[*].settings.http.compression", Matchers.is((Object)"true"))}));
            }
        }

        @Test
        public void testDefaultConfig() throws Exception {
            try (LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().doNotInitializeSgConfig().nodeSettings("searchguard.allow_default_init_sgindex", true).start();
                 GenericRestClient restClient = cluster.getRestClient("admin", "admin", new Header[0]);){
                AsyncAssert.awaitAssert((String)"Index was initialized", () -> restClient.get("", new Header[0]).getStatusCode() == 200, (Duration)Duration.ofSeconds(60L));
            }
        }

        @Test
        public void testDisabled() throws Exception {
            try (LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().doNotInitializeSgConfig().nodeSettings("searchguard.disabled", true).start();
                 GenericRestClient restClient = cluster.getRestClientWithoutTls(new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.get("_search", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
            }
        }
    }

    public static class StandardConfig {
        @ClassRule
        public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/internal_users_db"))).users(ALL_ACCESS_USER).build();

        @Test
        public void testXOpaqueIdHeader() throws Exception {
            try (GenericRestClient restClient = cluster.getRestClient(ALL_ACCESS_USER, new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.get("_tasks?group_by=parents&pretty", new Header[]{new BasicHeader("X-Opaque-Id", "myOpaqueId12")});
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                Assert.assertTrue((response.getBody().split("X-Opaque-Id").length > 2 ? 1 : 0) != 0);
            }
        }

        @Test
        public void testXOpaqueIdHeaderLowerCase() throws Exception {
            try (GenericRestClient restClient = cluster.getRestClient(ALL_ACCESS_USER, new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.get("_tasks?group_by=parents&pretty", new Header[]{new BasicHeader("X-Opaque-Id".toLowerCase(), "myOpaqueId12")});
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                Assert.assertTrue((response.getBody().split("X-Opaque-Id").length > 2 ? 1 : 0) != 0);
            }
        }

        @Test
        public void testHealth() throws Exception {
            try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.get("_searchguard/health?pretty&mode=lenient", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isOk());
                Assert.assertTrue((boolean)response.getBody().contains("UP"));
                Assert.assertFalse((boolean)response.getBody().contains("DOWN"));
            }
        }

        @Test
        public void testSgIndexSecurity() throws Exception {
            try (GenericRestClient restClient = cluster.getRestClient(ALL_ACCESS_USER, new Header[0]);){
                GenericRestClient.HttpResponse response = restClient.putJson(".searchguard/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
                response = restClient.putJson("*earc*gua*/_mapping?expand_wildcards=all", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
                response = restClient.post(".searchguard/_close");
                MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
                response = restClient.delete(".searchguard", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
                response = restClient.putJson(".searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, RestMatchers.isForbidden());
            }
        }
    }
}

