/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public class AdminDNs {
    protected final Logger log = LogManager.getLogger(AdminDNs.class);
    private final Set<LdapName> adminDn = new HashSet<LdapName>();
    private final ListMultimap<String, String> allowedRestImpersonations = ArrayListMultimap.create();

    public AdminDNs(Settings settings) {
        List adminDnsA = settings.getAsList("searchguard.authcz.admin_dn", Collections.emptyList());
        for (String dn : adminDnsA) {
            try {
                this.log.debug("{} is registered as an admin dn", (Object)dn);
                this.adminDn.add(new LdapName(dn));
            }
            catch (InvalidNameException e) {
                this.log.error("Unable to parse admin dn {}", (Object)dn, (Object)e);
            }
        }
        this.log.debug("Loaded {} admin DN's {}", (Object)this.adminDn.size(), this.adminDn);
        Settings impersonationUsersRest = settings.getByPrefix("searchguard.authcz.rest_impersonation_user.");
        for (String user : impersonationUsersRest.keySet()) {
            this.allowedRestImpersonations.putAll((Object)user, (Iterable)settings.getAsList("searchguard.authcz.rest_impersonation_user." + user));
        }
        this.log.debug("Loaded {} impersonation users for REST {}", (Object)this.allowedRestImpersonations.size(), this.allowedRestImpersonations);
    }

    public boolean isAdmin(User user) {
        return this.isAdminDN(user.getName());
    }

    public boolean isAdminDN(String dn) {
        if (dn == null) {
            return false;
        }
        try {
            return this.isAdminDN(new LdapName(dn));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    private boolean isAdminDN(LdapName dn) {
        if (dn == null) {
            return false;
        }
        boolean isAdmin = this.adminDn.contains(dn);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Is principal {} an admin cert? {}", (Object)dn.toString(), (Object)isAdmin);
        }
        return isAdmin;
    }

    public boolean isRestImpersonationAllowed(String originalUser, String impersonated) {
        if (originalUser == null) {
            return false;
        }
        return WildcardMatcher.matchAny((Collection<String>)this.allowedRestImpersonations.get((Object)originalUser), impersonated);
    }
}

