/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.internal_users_db;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.internal_users_db.InternalUser;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;

public class InternalUsersDatabase
implements ComponentStateProvider {
    private final ComponentState componentState = new ComponentState(100, null, "internal_users_database");
    private volatile ImmutableMap<String, InternalUser> userMap;

    public InternalUsersDatabase(ConfigurationRepository configurationRepository) {
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<InternalUser> config = configMap.get(CType.INTERNALUSERS);
                if (config != null) {
                    InternalUsersDatabase.this.userMap = ImmutableMap.of(config.getCEntries());
                    InternalUsersDatabase.this.componentState.setState(ComponentState.State.INITIALIZED);
                    InternalUsersDatabase.this.componentState.setConfigVersion(config.getDocVersion());
                    InternalUsersDatabase.this.componentState.setMessage(InternalUsersDatabase.this.userMap.size() + " users");
                } else {
                    InternalUsersDatabase.this.componentState.setState(ComponentState.State.SUSPENDED, "no_configuration");
                }
            }
        });
    }

    public InternalUser get(String userName) throws AuthenticatorUnavailableException {
        if (this.userMap == null) {
            throw new AuthenticatorUnavailableException("Internal Users Database unavailable", "Internal Users Database is not yet initialized");
        }
        return (InternalUser)this.userMap.get((Object)userName);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

