/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.authc.session.TestApiAuthenticationFrontend;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.BearerAuthorization;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class SessionIntegrationTest {
    static TestSgConfig.User BASIC_USER = new TestSgConfig.User("basic_user").roles("sg_all_access");
    static TestSgConfig.User NO_ROLES_USER = new TestSgConfig.User("no_roles_user");
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain("basic/internal_users_db").skipOriginatingIps("127.0.0.22")).trustedProxies("127.0.0.42");
    static TestSgConfig TEST_SG_CONFIG = new TestSgConfig().resources("session").authc(AUTHC).frontendAuthc("default", new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("basic").label("Basic Login"))).frontendAuthc("test_fe", new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain(TestApiAuthenticationFrontend.class.getName()).label("Test Login"))).user(NO_ROLES_USER).user(BASIC_USER);
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().nodeSettings("searchguard.restapi.roles_enabled.0", "sg_admin").resources("session").sgConfig(TEST_SG_CONFIG).sslEnabled().embedded().build();

    @Test
    public void startSession_basic() throws Exception {
        String token;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            token = response.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((String)response.getBody(), (Object)token);
        }
        restClient = cluster.getRestClient(new Header[]{new BearerAuthorization(token)});
        try {
            response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)BASIC_USER.getName(), (Object)response.getBodyAsDocNode().getAsString("user_name"));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void startSession_header() throws Exception {
        String token;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient restClient = cluster.getRestClient(BASIC_USER, new Header[0]);){
            response = restClient.post("/_searchguard/auth/session/with_header");
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            token = response.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((String)response.getBody(), (Object)token);
        }
        restClient = cluster.getRestClient(new Header[]{new BearerAuthorization(token)});
        try {
            response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)BASIC_USER.getName(), (Object)response.getBodyAsDocNode().get("user_name"));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void startSession_trustedProxy() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            restClient.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 42}));
            response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[]{new BasicHeader("X-Forwarded-For", "127.0.0.21")});
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
        }
        restClient = cluster.getRestClient(new Header[0]);
        try {
            restClient.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 42}));
            response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[]{new BasicHeader("X-Forwarded-For", "127.0.0.22")});
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(new Header[0]);
        try {
            response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[]{new BasicHeader("X-Forwarded-For", "127.0.0.22")});
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void nonDefaultConfigTest() throws Exception {
        String token;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient restClient = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            response = restClient.get("/_searchguard/auth/config?config_id=test_fe", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (Object)"test", (Object)((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).get("method"));
            Assert.assertEquals((String)response.getBody(), (long)1L, (long)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").size());
        }
        restClient = cluster.getRestClient(new Header[0]);
        try {
            response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.testAuthRequest("test_user", "config_id", "test_fe", "roles", "backend_role_all_access"), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            token = response.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((String)response.getBody(), (Object)token);
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(new Header[]{new BearerAuthorization(token)});
        try {
            response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"test_user", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), (Object)"backend_role_all_access", (Object)((DocNode)response.getBodyAsDocNode().getAsListOfNodes("backend_roles").get(0)).toString());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void configsAreSeparatedTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.testAuthRequest("test_user", "roles", "backend_role_all_access"), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void noRolesTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.basicAuthRequest(NO_ROLES_USER, new Object[0]), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"The user 'no_roles_user' is not allowed to log in.", (Object)response.getBodyAsDocNode().get("error"));
        }
    }

    @Test
    public void autogeneratedKeysAreEncrypted() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = restClient.get("/_searchguard/config/vars/sessions_signing_key", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            System.out.println(response.getBody());
        }
    }

    @Test
    public void justBasicAuthWithoutFrontendConfigTest() throws Exception {
        try (LocalCluster cluster = new LocalCluster.Builder().resources("session").user(BASIC_USER).authc(AUTHC).sslEnabled().singleNode().start();){
            String token;
            GenericRestClient.HttpResponse response;
            try (GenericRestClient restClient = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
                response = restClient.get("/_searchguard/auth/config", new Header[0]);
                Assert.assertEquals((String)response.getBody(), (Object)"basic", (Object)((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).get("method"));
                Assert.assertEquals((String)response.getBody(), (long)1L, (long)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").size());
            }
            restClient = cluster.getRestClient(new Header[0]);
            try {
                response = restClient.postJson("/_searchguard/auth/session", SessionIntegrationTest.basicAuthRequest(BASIC_USER, new Object[0]), new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
                token = response.getBodyAsDocNode().getAsString("token");
                Assert.assertNotNull((String)response.getBody(), (Object)token);
            }
            finally {
                if (restClient != null) {
                    restClient.close();
                }
            }
            restClient = cluster.getRestClient(new Header[]{new BearerAuthorization(token)});
            try {
                response = restClient.get("/_searchguard/authinfo", new Header[0]);
                Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                Assert.assertEquals((String)response.getBody(), (Object)BASIC_USER.getName(), (Object)response.getBodyAsDocNode().get("user_name"));
            }
            finally {
                if (restClient != null) {
                    restClient.close();
                }
            }
        }
    }

    private static Map<String, Object> basicAuthRequest(TestSgConfig.User user, Object ... additionalAttrs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("mode", "basic");
        result.put("user", user.getName());
        result.put("password", user.getPassword());
        if (additionalAttrs != null && additionalAttrs.length > 0) {
            for (int i = 0; i < additionalAttrs.length; i += 2) {
                result.put(additionalAttrs[i].toString(), additionalAttrs[i + 1]);
            }
        }
        return result;
    }

    private static Map<String, Object> testAuthRequest(String userName, Object ... additionalAttrs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("mode", "test");
        result.put("user", userName);
        result.put("secret", "indeed");
        if (additionalAttrs != null && additionalAttrs.length > 0) {
            for (int i = 0; i < additionalAttrs.length; i += 2) {
                result.put(additionalAttrs[i].toString(), additionalAttrs[i + 1]);
            }
        }
        return result;
    }
}

