/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class BulkTests {
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().user("bulk_test_user", "secret", new TestSgConfig.Role("bulk_test_user_role").clusterPermissions("*").indexPermissions("*").on("test")).build();

    @Test
    public void testBulk() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("bulk_test_user", "secret", new Header[0]);){
            String bulkBody = "{\"index\":{\"_id\":\"1\",\"_index\":\"test\"}}\n{ \"a\" : \"b\" }\n{\"index\":{\"_id\":\"1\",\"_index\":\"myindex\"}}\n{ \"a\" : \"b\" }\n";
            GenericRestClient.HttpResponse res = client.postJson("/_bulk?refresh=true", bulkBody, new Header[0]);
            MatcherAssert.assertThat((Object)res, RestMatchers.isOk());
            MatcherAssert.assertThat((Object)res.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.errors", (Object)true));
            MatcherAssert.assertThat((Object)res.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.items", (int)2));
            DocNode firstItem = res.getBodyAsDocNode().findSingleNodeByJsonPath("items[0].index");
            DocNode secondItem = res.getBodyAsDocNode().findSingleNodeByJsonPath("items[1].index");
            MatcherAssert.assertThat((Object)firstItem, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$", (String)"error")));
            MatcherAssert.assertThat((Object)secondItem, (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$", (String)"error"));
            MatcherAssert.assertThat((Object)secondItem, (Matcher)DocNodeMatchers.containsValue((String)"$.error.type", (Object)"security_exception"));
        }
    }
}

