/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography;

import com.floragunn.searchguard.test.helper.certificate.asymmetricscryptography.AsymmetricCryptographyAlgorithm;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAAsymmetricCryptographyAlgorithm
implements AsymmetricCryptographyAlgorithm {
    private static final Logger log = LogManager.getLogger(RSAAsymmetricCryptographyAlgorithm.class);
    private final KeyPairGenerator generator;

    public RSAAsymmetricCryptographyAlgorithm(Provider securityProvider, int keySize) {
        try {
            this.generator = KeyPairGenerator.getInstance("RSA", securityProvider);
            log.debug("Initialize key pair generator with keySize: {}", (Object)keySize);
            this.generator.initialize(keySize);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error while initializing", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSignatureAlgorithmName() {
        return "SHA256withRSA";
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.generator.generateKeyPair();
    }
}

