/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.internalauthtoken.InternalAuthTokenProvider;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.searchsupport.jobs.JobConfigListener;
import com.floragunn.searchsupport.jobs.SchedulerBuilder;
import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateAction;
import com.floragunn.searchsupport.jobs.config.JobConfigFactory;
import com.floragunn.searchsupport.jobs.config.JobDetailWithBaseConfig;
import com.floragunn.signals.NoSuchActionException;
import com.floragunn.signals.NoSuchWatchOnThisNodeException;
import com.floragunn.signals.NotAcknowledgeableException;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchRunner;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.support.ToXParams;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.action.invokers.AlertAction;
import com.floragunn.signals.watch.checks.StaticInput;
import com.floragunn.signals.watch.common.Ack;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.DefaultThrottlePeriodParser;
import com.floragunn.signals.watch.common.throttle.ValidatingThrottlePeriodParser;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.result.WatchLog;
import com.floragunn.signals.watch.result.WatchLogIndexWriter;
import com.floragunn.signals.watch.state.WatchState;
import com.floragunn.signals.watch.state.WatchStateIndexReader;
import com.floragunn.signals.watch.state.WatchStateIndexWriter;
import com.floragunn.signals.watch.state.WatchStateManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class SignalsTenant
implements Closeable {
    private static final Logger log = LogManager.getLogger(SignalsTenant.class);
    private final SignalsSettings settings;
    private final String name;
    private final String scopedName;
    private final String configIndexName;
    private final String watchIdPrefix;
    private final Client privilegedConfigClient;
    private final Client client;
    private final ClusterService clusterService;
    private final NodeEnvironment nodeEnvironment;
    private String nodeFilter;
    private final NamedXContentRegistry xContentRegistry;
    private final ScriptService scriptService;
    private final WatchStateManager watchStateManager;
    private final WatchStateIndexWriter watchStateWriter;
    private final WatchStateIndexReader watchStateReader;
    private final InternalAuthTokenProvider internalAuthTokenProvider;
    private final AccountRegistry accountRegistry;
    private final String nodeName;
    private final ComponentState tenantState;
    private SignalsSettings.Tenant tenantSettings;
    private final DiagnosticContext diagnosticContext;
    private Scheduler scheduler;
    private final TrustManagerRegistry trustManagerRegistry;
    private final HttpProxyHostRegistry httpProxyHostRegistry;
    private final JobFactory jobFactory = new JobFactory(){

        public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
            WatchState watchState;
            Watch watch = this.getConfig(bundle);
            if (log.isDebugEnabled()) {
                log.debug("newJob() on " + SignalsTenant.this + "@" + SignalsTenant.this.hashCode() + ": " + watch);
            }
            if ((watchState = SignalsTenant.this.watchStateManager.getWatchState(watch.getId())).isRefreshBeforeExecuting()) {
                watchState = this.refreshState(watch, watchState);
            }
            WatchLogIndexWriter watchLogWriter = WatchLogIndexWriter.forTenant(SignalsTenant.this.client, SignalsTenant.this.name, SignalsTenant.this.settings, ToXParams.of(WatchLog.ToXContentParams.INCLUDE_DATA, watch.isLogRuntimeData()));
            return new WatchRunner(watch, SignalsTenant.this.client, SignalsTenant.this.accountRegistry, SignalsTenant.this.scriptService, watchLogWriter, SignalsTenant.this.watchStateWriter, SignalsTenant.this.diagnosticContext, watchState, ExecutionEnvironment.SCHEDULED, SimulationMode.FOR_REAL, SignalsTenant.this.xContentRegistry, SignalsTenant.this.settings, SignalsTenant.this.nodeName, null, null, SignalsTenant.this.trustManagerRegistry);
        }

        private Watch getConfig(TriggerFiredBundle bundle) {
            return (Watch)((JobDetailWithBaseConfig)bundle.getJobDetail()).getBaseConfig(Watch.class);
        }

        private WatchState refreshState(Watch watch, WatchState oldState) {
            try {
                WatchState newState;
                if (log.isDebugEnabled()) {
                    log.debug("Refreshing state for " + watch.getId() + "\nOld state: " + (oldState != null ? Strings.toString((ToXContent)oldState) : null));
                }
                if ((newState = SignalsTenant.this.watchStateReader.get(watch.getId())).getNode() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Got refreshed state for " + watch.getId() + "\nThis however has a null node. Thus, it is probably the initial default state. Discarding: " + (oldState != null ? Strings.toString((ToXContent)oldState) : null));
                    }
                    return oldState;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Refreshed state for " + watch.getId() + "\nNew state: " + (oldState != null ? Strings.toString((ToXContent)oldState) : null));
                }
                newState.setNode(SignalsTenant.this.nodeName);
                return newState;
            }
            catch (Exception e) {
                log.error("Error while refreshing WatchState of " + watch.getId() + ";\nUsing original state", (Throwable)e);
                return oldState;
            }
        }
    };
    private final JobConfigListener<Watch> jobConfigListener = new JobConfigListener<Watch>(){

        public void onInit(Set<Watch> watches) {
            Set<String> watchIds = watches.stream().map(watch -> watch.getId()).collect(Collectors.toSet());
            SignalsTenant.this.tenantState.setState(ComponentState.State.INITIALIZING, "reading_states");
            Map<String, WatchState> dirtyStates = SignalsTenant.this.watchStateManager.reset(SignalsTenant.this.watchStateReader.get(watchIds), watchIds);
            if (!dirtyStates.isEmpty()) {
                SignalsTenant.this.tenantState.setState(ComponentState.State.INITIALIZING, "writing_states");
                SignalsTenant.this.watchStateWriter.putAll(dirtyStates);
            }
            SignalsTenant.this.tenantState.setState(ComponentState.State.INITIALIZED);
        }

        public void beforeChange(Set<Watch> newJobs) {
            if (newJobs != null && newJobs.size() > 0) {
                Set<String> watchIds = newJobs.stream().map(watch -> watch.getId()).collect(Collectors.toSet());
                SignalsTenant.this.tenantState.setState(ComponentState.State.INITIALIZING, "reading_states");
                if (log.isDebugEnabled()) {
                    log.debug("Reading states of newly arrived watches from index: " + watchIds);
                }
                Map<String, WatchState> statesFromIndex = SignalsTenant.this.watchStateReader.get(watchIds);
                Map<String, WatchState> dirtyStates = SignalsTenant.this.watchStateManager.add(statesFromIndex, watchIds);
                if (!dirtyStates.isEmpty()) {
                    SignalsTenant.this.tenantState.setState(ComponentState.State.INITIALIZING, "writing_states");
                    if (log.isDebugEnabled()) {
                        log.debug("Updating dirty states: " + dirtyStates);
                    }
                    SignalsTenant.this.watchStateWriter.putAll(dirtyStates);
                }
                SignalsTenant.this.tenantState.setState(ComponentState.State.INITIALIZED);
            }
        }

        public void afterChange(Set<Watch> newJobs, Map<Watch, Watch> updatedJobs, Set<Watch> deletedJobs) {
            for (Watch deletedWatch : deletedJobs) {
                SignalsTenant.this.watchStateManager.delete(deletedWatch.getId());
            }
        }
    };
    private final SignalsSettings.ChangeListener settingsChangeListener = new SignalsSettings.ChangeListener(){

        @Override
        public void onChange() {
            try {
                boolean active;
                SignalsTenant.this.tenantSettings = SignalsTenant.this.settings.getTenant(SignalsTenant.this.name);
                if (!Objects.equals(SignalsTenant.this.nodeFilter, SignalsTenant.this.tenantSettings.getNodeFilter())) {
                    log.info("Restarting tenant " + SignalsTenant.this.name + " because node filter has changed: " + SignalsTenant.this.nodeFilter + " <> " + SignalsTenant.this.tenantSettings.getNodeFilter());
                    SignalsTenant.this.nodeFilter = SignalsTenant.this.tenantSettings.getNodeFilter();
                    SignalsTenant.this.restartAsync();
                }
                boolean bl = active = SignalsTenant.this.tenantSettings.isActive() && SignalsTenant.this.settings.getDynamicSettings().isActive();
                if (active != SignalsTenant.this.isActive()) {
                    if (active) {
                        SignalsTenant.this.resume();
                    } else {
                        SignalsTenant.this.pause();
                    }
                }
            }
            catch (SchedulerException e) {
                log.error("Error in " + this, (Throwable)e);
            }
        }
    };

    public static SignalsTenant create(String name, Client client, ClusterService clusterService, NodeEnvironment nodeEnvironment, ScriptService scriptService, NamedXContentRegistry xContentRegistry, InternalAuthTokenProvider internalAuthTokenProvider, SignalsSettings settings, AccountRegistry accountRegistry, ComponentState tenantState, DiagnosticContext diagnosticContext, ThreadPool threadPool, TrustManagerRegistry trustManagerRegistry, HttpProxyHostRegistry httpProxyHostRegistry) throws SchedulerException {
        SignalsTenant instance = new SignalsTenant(name, client, clusterService, nodeEnvironment, scriptService, xContentRegistry, internalAuthTokenProvider, settings, accountRegistry, tenantState, diagnosticContext, threadPool, trustManagerRegistry, httpProxyHostRegistry);
        instance.init();
        return instance;
    }

    public SignalsTenant(String name, Client client, ClusterService clusterService, NodeEnvironment nodeEnvironment, ScriptService scriptService, NamedXContentRegistry xContentRegistry, InternalAuthTokenProvider internalAuthTokenProvider, SignalsSettings settings, AccountRegistry accountRegistry, ComponentState tenantState, DiagnosticContext diagnosticContext, ThreadPool threadPool, TrustManagerRegistry trustManagerRegistry, HttpProxyHostRegistry httpProxyHostRegistry) {
        this.name = name;
        this.settings = settings;
        this.scopedName = "signals/" + name;
        this.configIndexName = settings.getStaticSettings().getIndexNames().getWatches();
        this.watchIdPrefix = name.replace("/", "\\/") + "/";
        this.client = client;
        this.privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
        this.clusterService = clusterService;
        this.nodeEnvironment = nodeEnvironment;
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.tenantSettings = settings.getTenant(name);
        this.nodeFilter = this.tenantSettings.getNodeFilter();
        this.watchStateManager = new WatchStateManager(name, clusterService.getNodeName());
        this.watchStateWriter = new WatchStateIndexWriter(this.watchIdPrefix, settings.getStaticSettings().getIndexNames().getWatchesState(), this.privilegedConfigClient);
        this.watchStateReader = new WatchStateIndexReader(name, this.watchIdPrefix, settings.getStaticSettings().getIndexNames().getWatchesState(), this.privilegedConfigClient);
        this.internalAuthTokenProvider = internalAuthTokenProvider;
        this.accountRegistry = accountRegistry;
        this.nodeName = clusterService.getNodeName();
        this.tenantState = tenantState;
        this.diagnosticContext = diagnosticContext;
        this.trustManagerRegistry = Objects.requireNonNull(trustManagerRegistry, "Trust manager registry is required");
        this.httpProxyHostRegistry = Objects.requireNonNull(httpProxyHostRegistry, "Http proxy host registry is required");
        settings.addChangeListener(this.settingsChangeListener);
    }

    public SignalsTenant(String name, Client client, ClusterService clusterService, NodeEnvironment nodeEnvironment, ScriptService scriptService, NamedXContentRegistry xContentRegistry, InternalAuthTokenProvider internalAuthTokenProvider, SignalsSettings settings, AccountRegistry accountRegistry, DiagnosticContext diagnosticContext, ThreadPool threadPool, TrustManagerRegistry trustManagerRegistry, HttpProxyHostRegistry httpProxyHostRegistry) {
        this(name, client, clusterService, nodeEnvironment, scriptService, xContentRegistry, internalAuthTokenProvider, settings, accountRegistry, new ComponentState(0, null, "tenant"), diagnosticContext, threadPool, trustManagerRegistry, httpProxyHostRegistry);
    }

    public void init() throws SchedulerException {
        if (this.tenantSettings.isActive()) {
            this.doInit();
        } else {
            this.tenantState.setState(ComponentState.State.SUSPENDED);
        }
    }

    private void doInit() throws SchedulerException {
        log.info("Initializing alerting tenant " + this.name + "\nnodeFilter: " + this.nodeFilter);
        this.tenantState.setState(ComponentState.State.INITIALIZING);
        WatchInitializationService initContext = new WatchInitializationService(this.accountRegistry, this.scriptService, this.trustManagerRegistry, this.httpProxyHostRegistry, new DefaultThrottlePeriodParser(this.settings), ValidationLevel.LENIENT);
        this.scheduler = new SchedulerBuilder().client(this.privilegedConfigClient).name(this.scopedName).configIndex(this.configIndexName, this.getActiveConfigQuery(this.name)).stateIndex(this.settings.getStaticSettings().getIndexNames().getWatchesTriggerState()).stateIndexIdPrefix(this.watchIdPrefix).jobConfigFactory((JobConfigFactory)new Watch.JobConfigFactory(this.name, this.watchIdPrefix, initContext)).distributed(this.clusterService, this.nodeEnvironment).jobFactory(this.jobFactory).nodeFilter(this.nodeFilter).jobConfigListener(this.jobConfigListener).maxThreads(this.settings.getStaticSettings().getMaxThreads()).threadKeepAlive(this.settings.getStaticSettings().getThreadKeepAlive()).threadPriority(this.settings.getStaticSettings().getThreadPrio()).build();
        this.scheduler.start();
    }

    public void pause() throws SchedulerException {
        log.info("Suspending scheduler of " + this);
        if (this.scheduler != null) {
            this.tenantState.setState(ComponentState.State.SUSPENDED);
            this.scheduler.standby();
        }
    }

    public void resume() throws SchedulerException {
        if (this.scheduler == null || this.scheduler.isShutdown()) {
            this.doInit();
        } else if (!this.scheduler.isStarted() || this.scheduler.isInStandbyMode()) {
            log.info("Resuming scheduler of " + this);
            this.tenantState.setState(ComponentState.State.INITIALIZED);
            this.scheduler.start();
        } else {
            log.info("Scheduler is already active " + this);
        }
    }

    public boolean isActive() throws SchedulerException {
        return this.scheduler != null && this.scheduler.isStarted() && !this.scheduler.isInStandbyMode();
    }

    public void shutdown() {
        try {
            if (this.scheduler != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Going to shutdown " + this.scheduler);
                }
                this.scheduler.shutdown(true);
                this.tenantState.setState(ComponentState.State.DISABLED);
            }
        }
        catch (SchedulerException e) {
            log.error("Error wile shutting down " + this, (Throwable)e);
        }
    }

    public void shutdownHard() {
        try {
            if (this.scheduler != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Going to shutdown " + this.scheduler);
                }
                this.scheduler.shutdown(false);
                this.tenantState.setState(ComponentState.State.DISABLED);
                this.scheduler = null;
            }
        }
        catch (SchedulerException e) {
            log.error("Error wile shutting down " + this, (Throwable)e);
        }
    }

    public synchronized void restart() throws SchedulerException {
        this.shutdown();
        this.init();
    }

    public void restartAsync() {
        new Thread(){

            @Override
            public void run() {
                try {
                    SignalsTenant.this.restart();
                }
                catch (SchedulerException e) {
                    log.error("Error while restarting: " + SignalsTenant.this, (Throwable)e);
                }
            }
        }.start();
    }

    public boolean runsWatchLocally(String watchId) {
        try {
            return this.scheduler != null && this.scheduler.getJobDetail(Watch.createJobKey(watchId)) != null;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public Watch getLocallyRunningWatch(String watchId) {
        if (this.scheduler == null) {
            return null;
        }
        try {
            JobDetailWithBaseConfig jobDetail = (JobDetailWithBaseConfig)this.scheduler.getJobDetail(Watch.createJobKey(watchId));
            if (jobDetail == null) {
                return null;
            }
            return (Watch)jobDetail.getBaseConfig(Watch.class);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLocalWatchCount() {
        try {
            if (this.scheduler == null) {
                return 0;
            }
            return this.scheduler.getJobKeys(GroupMatcher.anyJobGroup()).size();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public String getWatchIdForConfigIndex(String watchId) {
        return this.watchIdPrefix + watchId;
    }

    public String getWatchIdForConfigIndex(Watch watch) {
        return this.getWatchIdForConfigIndex(watch.getId());
    }

    public IndexResponse addWatch(Watch watch, User user, ValidationLevel lifeCycleStage) throws IOException {
        try {
            return this.addWatch(watch.getId(), Strings.toString((ToXContent)watch), user, lifeCycleStage);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexResponse addWatch(String watchId, String watchJsonString, User user, ValidationLevel validationLevel) throws ConfigValidationException, IOException {
        if (log.isInfoEnabled()) {
            log.info("addWatch(" + watchId + ") on " + this);
        }
        LinkedHashMap<String, Object> watchJson = new LinkedHashMap<String, Object>(DocReader.json().readObject(watchJsonString));
        WatchInitializationService initializationService = new WatchInitializationService(this.accountRegistry, this.scriptService, this.trustManagerRegistry, this.httpProxyHostRegistry, new ValidatingThrottlePeriodParser(this.settings), validationLevel);
        final Watch watch = Watch.parse(initializationService, this.getName(), watchId, DocNode.wrap(watchJson), -1L);
        watch.setTenant(this.name);
        watch.getMeta().setLastEditByUser(user.getName());
        watch.getMeta().setLastEditByDate(new Date());
        watch.getMeta().setAuthToken(this.internalAuthTokenProvider.getJwt(user, watch.getIdAndHash()));
        watchJson.put("_tenant", watch.getTenant());
        watchJson.put("_meta", watch.getMeta().toMap());
        watchJson.put("_name", watchId);
        StaticInput.patchForIndexMappingBugFix(watchJson);
        String newWatchJsonString = DocWriter.json().writeAsString(watchJson);
        IndexResponse indexResponse = (IndexResponse)((IndexRequestBuilder)((IndexRequestBuilder)this.privilegedConfigClient.prepareIndex().setIndex(this.getConfigIndexName())).setId(this.getWatchIdForConfigIndex(watch.getId())).setSource(newWatchJsonString, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet();
        if (log.isDebugEnabled()) {
            log.debug("IndexResponse from addWatch()\n" + Strings.toString((ToXContent)indexResponse));
        }
        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
            this.watchStateWriter.put(watch.getId(), new WatchState(this.name), new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    SchedulerConfigUpdateAction.send((Client)SignalsTenant.this.privilegedConfigClient, (String)SignalsTenant.this.getScopedName());
                }

                public void onFailure(Exception e) {
                    log.warn("Error while writing initial state for " + watch + ". Ignoring", (Throwable)e);
                    SchedulerConfigUpdateAction.send((Client)SignalsTenant.this.privilegedConfigClient, (String)SignalsTenant.this.getScopedName());
                }
            });
        } else if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            SchedulerConfigUpdateAction.send((Client)this.privilegedConfigClient, (String)this.getScopedName());
        }
        return indexResponse;
    }

    public Map<String, Ack> ack(String watchId, User user) throws NoSuchWatchOnThisNodeException {
        Watch watch;
        if (log.isInfoEnabled()) {
            log.info("ack(" + watchId + ", " + user + ")");
        }
        if ((watch = this.getLocallyRunningWatch(watchId)) == null) {
            throw new NoSuchWatchOnThisNodeException(watchId, this.nodeName);
        }
        WatchState watchState = this.watchStateManager.getWatchState(watchId);
        Map<String, Ack> result = watchState.ack(user != null ? user.getName() : null, watch);
        this.watchStateWriter.put(watchId, watchState);
        return result;
    }

    public WatchState ack(String watchId, String actionId, User user) throws NoSuchWatchOnThisNodeException, NoSuchActionException, NotAcknowledgeableException {
        Watch watch;
        if (log.isInfoEnabled()) {
            log.info("ack(" + watchId + ", " + actionId + ", " + user + ")");
        }
        if ((watch = this.getLocallyRunningWatch(watchId)) == null) {
            throw new NoSuchWatchOnThisNodeException(watchId, this.nodeName);
        }
        AlertAction action = watch.getActionByName(actionId);
        if (!action.isAckEnabled()) {
            throw new NotAcknowledgeableException(watchId, actionId);
        }
        WatchState watchState = this.watchStateManager.getWatchState(watchId);
        watchState.getActionState(actionId).ack(user != null ? user.getName() : null);
        this.watchStateWriter.put(watchId, watchState);
        return watchState;
    }

    public List<String> unack(String watchId, User user) throws NoSuchWatchOnThisNodeException {
        WatchState watchState;
        if (log.isInfoEnabled()) {
            log.info("unack(" + watchId + ", " + user + ")");
        }
        if ((watchState = this.watchStateManager.peekWatchState(watchId)) == null) {
            throw new NoSuchWatchOnThisNodeException(watchId, this.nodeName);
        }
        List<String> result = watchState.unack(user != null ? user.getName() : null);
        if (log.isDebugEnabled()) {
            log.debug("Unacked actions: " + result);
        }
        this.watchStateWriter.put(watchId, watchState);
        return result;
    }

    public boolean unack(String watchId, String actionId, User user) throws NoSuchWatchOnThisNodeException {
        WatchState watchState;
        if (log.isInfoEnabled()) {
            log.info("unack(" + watchId + ", " + actionId + ", " + user + ")");
        }
        if ((watchState = this.watchStateManager.peekWatchState(watchId)) == null) {
            throw new NoSuchWatchOnThisNodeException(watchId, this.nodeName);
        }
        boolean result = watchState.getActionState(actionId).unackIfPossible(user != null ? user.getName() : null);
        this.watchStateWriter.put(watchId, watchState);
        return result;
    }

    public WatchState getWatchState(String watchId) {
        return this.watchStateManager.getWatchState(watchId);
    }

    public void deleteTenantFromIndexes() {
        log.info("Deleting watches of " + this);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.configIndexName});
        searchRequest.source(new SearchSourceBuilder().query(this.getConfigQuery(this.name)).size(10000));
        SearchResponse searchResponse = (SearchResponse)this.privilegedConfigClient.search(searchRequest).actionGet();
        int seen = 0;
        int deletedWatches = 0;
        int deletedWatchStates = 0;
        for (SearchHit hit : searchResponse.getHits()) {
            ++seen;
            DeleteResponse watchDeleteResponse = (DeleteResponse)this.privilegedConfigClient.delete(new DeleteRequest(this.configIndexName, hit.getId())).actionGet();
            deletedWatches += watchDeleteResponse.getResult() == DocWriteResponse.Result.DELETED ? 1 : 0;
            DeleteResponse watchStateDeleteResponse = (DeleteResponse)this.privilegedConfigClient.delete(new DeleteRequest(this.settings.getStaticSettings().getIndexNames().getWatchesState(), hit.getId())).actionGet();
            deletedWatchStates += watchStateDeleteResponse.getResult() == DocWriteResponse.Result.DELETED ? 1 : 0;
        }
        log.info("Deleted of  " + seen + ":\n" + deletedWatches + " watches\n" + deletedWatchStates + " watch states");
    }

    public void delete() {
        this.settings.removeChangeListener(this.settingsChangeListener);
        this.shutdown();
    }

    public WatchStateManager getWatchStateManager() {
        return this.watchStateManager;
    }

    private QueryBuilder getActiveConfigQuery(String tenant) {
        return QueryBuilders.boolQuery().must(this.getConfigQuery(tenant)).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"active", (boolean)false));
    }

    private QueryBuilder getConfigQuery(String tenant) {
        return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (String)tenant));
    }

    public String getName() {
        return this.name;
    }

    public String getConfigIndexName() {
        return this.configIndexName;
    }

    public String getScopedName() {
        return this.scopedName;
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public String toString() {
        return "SignalsTenant " + this.name;
    }

    public WatchStateIndexReader getWatchStateReader() {
        return this.watchStateReader;
    }

    public SignalsSettings getSettings() {
        return this.settings;
    }
}

