/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.signals.actions.summary.ActionProperties;
import com.floragunn.signals.actions.summary.RangesFilters;
import com.floragunn.signals.actions.summary.SortParser;
import com.floragunn.signals.actions.summary.SummaryToWatchFieldMapper;
import com.floragunn.signals.actions.summary.WatchFilter;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

class WatchStateRepository {
    private static final String PROP = "properties";
    private static final String FIELDS = "fields";
    private final String stateIndexName;
    private final PrivilegedConfigClient privilegedConfigClient;

    public WatchStateRepository(String stateIndexName, PrivilegedConfigClient privilegedConfigClient) {
        this.stateIndexName = Objects.requireNonNull(stateIndexName);
        this.privilegedConfigClient = Objects.requireNonNull(privilegedConfigClient);
    }

    public SearchResponse search(WatchFilter watchFilter, List<SortParser.SortByField> sorting) {
        Objects.requireNonNull(watchFilter, "Watch filter is required");
        Objects.requireNonNull(sorting, "Sorting is required");
        GetMappingsResponse mappings = this.getMappings();
        DocNode docNode = this.extractFieldNames(mappings);
        return this.searchWithFilteringOutMissingSortingFields(watchFilter, sorting, docNode);
    }

    private SearchResponse searchWithFilteringOutMissingSortingFields(WatchFilter watchFilter, List<SortParser.SortByField> sorting, DocNode fieldsDefinedInMappings) {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        for (SortParser.SortByField field : sorting) {
            if (!this.checkPropertyExists(fieldsDefinedInMappings, field.getDocumentFieldName())) continue;
            SortOrder order = field.isAscending() ? SortOrder.ASC : SortOrder.DESC;
            FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)field.getDocumentFieldName()).order(order);
            sourceBuilder.sort((SortBuilder)sortBuilder);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        WatchStateRepository.buildStatusCodeQuery(watchFilter, boolQueryBuilder);
        WatchStateRepository.buildWatchIdQuery(watchFilter, boolQueryBuilder);
        WatchStateRepository.buildSeverityQuery(watchFilter, boolQueryBuilder);
        WatchStateRepository.buildActionsNamesQuery(watchFilter, boolQueryBuilder);
        WatchStateRepository.buildActionsPropertiesQuery(watchFilter, boolQueryBuilder);
        WatchStateRepository.buildRangeQueries(watchFilter, boolQueryBuilder);
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        SearchRequest request = new SearchRequest(new String[]{this.stateIndexName}).source(sourceBuilder);
        return (SearchResponse)this.privilegedConfigClient.search(request).actionGet();
    }

    private static void buildRangeQueries(WatchFilter watchFilter, BoolQueryBuilder boolQueryBuilder) {
        RangesFilters ranges = watchFilter.getRangesFilters();
        if (ranges.getLevelNumericRange() != null) {
            WatchStateRepository.buildRangeOrTermQuery(boolQueryBuilder, ranges.getLevelNumericRange());
        }
        if (ranges.getActionsCheckedRange() != null) {
            WatchStateRepository.buildRangeOrTermQuery(boolQueryBuilder, ranges.getActionsCheckedRange());
        }
        if (ranges.getActionsTriggeredRange() != null) {
            WatchStateRepository.buildRangeOrTermQuery(boolQueryBuilder, ranges.getActionsTriggeredRange());
        }
        if (ranges.getActionsExecutionRange() != null) {
            WatchStateRepository.buildRangeOrTermQuery(boolQueryBuilder, ranges.getActionsExecutionRange());
        }
    }

    private static void buildActionsPropertiesQuery(WatchFilter watchFilter, BoolQueryBuilder boolQueryBuilder) {
        ActionProperties prop = watchFilter.getActionProperties();
        if (prop.getCheckResultValue() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)prop.getCheckResultName(), (Object)prop.getCheckResultValue()));
        }
        if (prop.getErrorValue() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)prop.getErrorName(), (Object)prop.getErrorValue()));
        }
        if (prop.getStatusCodeValue() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)prop.getStatusCodeName(), (Object)prop.getStatusCodeValue()));
        }
        if (prop.getStatusDetailsValue() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)prop.getStatusDetailsName(), (Object)prop.getStatusDetailsValue()));
        }
    }

    private static void buildActionsNamesQuery(WatchFilter watchFilter, BoolQueryBuilder boolQueryBuilder) {
        if (watchFilter.containsActions()) {
            BoolQueryBuilder orQueryBuilder = QueryBuilders.boolQuery();
            for (String action : watchFilter.getActionNames()) {
                ExistsQueryBuilder existsQuery = QueryBuilders.existsQuery((String)("actions." + action));
                orQueryBuilder.should((QueryBuilder)existsQuery);
            }
            boolQueryBuilder.filter((QueryBuilder)orQueryBuilder);
        }
    }

    private static void buildRangeOrTermQuery(BoolQueryBuilder boolQueryBuilder, WatchFilter.Range<?> range) {
        TermQueryBuilder rangeQuery;
        String field = range.getFieldName();
        if (range.containsEqualTo()) {
            rangeQuery = QueryBuilders.termQuery((String)field, range.getEqualTo());
        } else {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)field);
            if (range.containsLessThan()) {
                rangeQueryBuilder = rangeQueryBuilder.lt(range.getLessThan());
            }
            if (range.containsGreaterThan()) {
                rangeQueryBuilder = rangeQueryBuilder.gt(range.getGreaterThan());
            }
            rangeQuery = rangeQueryBuilder;
        }
        boolQueryBuilder.must((QueryBuilder)rangeQuery);
    }

    private static void buildSeverityQuery(WatchFilter watchFilter, BoolQueryBuilder boolQueryBuilder) {
        if (watchFilter.containsSeverities()) {
            BoolQueryBuilder orQueryBuilder = QueryBuilders.boolQuery();
            for (String severity : watchFilter.getSeverities()) {
                TermQueryBuilder query = QueryBuilders.termQuery((String)"last_status.severity", (String)severity);
                orQueryBuilder.should((QueryBuilder)query);
            }
            boolQueryBuilder.must((QueryBuilder)orQueryBuilder);
        }
    }

    private static void buildWatchIdQuery(WatchFilter watchFilter, BoolQueryBuilder boolQueryBuilder) {
        if (watchFilter.containsWatchId()) {
            MatchQueryBuilder watchIdQuery = QueryBuilders.matchQuery((String)"last_execution.watch.id", (Object)watchFilter.getWatchId());
            boolQueryBuilder.must((QueryBuilder)watchIdQuery);
        }
    }

    private static void buildStatusCodeQuery(WatchFilter watchFilter, BoolQueryBuilder boolQueryBuilder) {
        if (watchFilter.containsWatchStatusFilter()) {
            BoolQueryBuilder orQueryBuilder = QueryBuilders.boolQuery();
            for (String status : watchFilter.getWatchStatusCodes()) {
                TermQueryBuilder query = QueryBuilders.termQuery((String)SummaryToWatchFieldMapper.getSearchFieldName("status_code"), (String)status);
                orQueryBuilder.should((QueryBuilder)query);
            }
            boolQueryBuilder.must((QueryBuilder)orQueryBuilder);
        }
    }

    private GetMappingsResponse getMappings() {
        ActionFuture mappings = this.privilegedConfigClient.admin().indices().getMappings((GetMappingsRequest)new GetMappingsRequest().indices(new String[]{this.stateIndexName}));
        return (GetMappingsResponse)mappings.actionGet();
    }

    private DocNode extractFieldNames(GetMappingsResponse response) {
        try {
            return DocNode.wrap(((MappingMetadata)((ImmutableOpenMap)response.mappings().get((Object)this.stateIndexName)).get((Object)"_doc")).sourceAsMap().get(PROP));
        }
        catch (NullPointerException npe) {
            return DocNode.EMPTY;
        }
    }

    private boolean checkPropertyExists(DocNode node, String field) {
        if (node.isEmpty()) {
            return false;
        }
        String[] path = field.split("\\.");
        if ("actions".equals(path[0])) {
            if (path.length == 3) {
                return node.getAsNode(path[0], new String[]{PROP, path[1], PROP}).containsKey((Object)path[2]);
            }
            return node.getAsNode(path[0], new String[]{PROP, path[1], PROP, path[2], PROP, path[3], FIELDS}).containsKey((Object)path[4]);
        }
        return node.getAsNode(path[0], new String[]{PROP, path[1], FIELDS}).containsKey((Object)path[2]) || node.getAsNode(path[0], new String[]{PROP, path[1], PROP}).containsKey((Object)path[2]);
    }
}

