/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.ack;

import com.floragunn.signals.actions.watch.ack.TransportAckWatchAction;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AckWatchResponse
extends BaseNodesResponse<TransportAckWatchAction.NodeResponse> {
    private static final Logger log = LogManager.getLogger(AckWatchResponse.class);
    private Status status;
    private String statusMessage;

    public AckWatchResponse(ClusterName clusterName, List<TransportAckWatchAction.NodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public AckWatchResponse(StreamInput in) throws IOException {
        super(in);
        this.initStatus();
    }

    public List<TransportAckWatchAction.NodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(TransportAckWatchAction.NodeResponse::readNodeResponse);
    }

    public void writeNodesTo(StreamOutput out, List<TransportAckWatchAction.NodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public String toString() {
        return "AckWatchResponse [failures=" + this.failures() + ", nodes=" + this.getNodesMap() + "]";
    }

    private void initStatus() {
        TransportAckWatchAction.NodeResponse nodeResponse;
        if (log.isDebugEnabled()) {
            log.debug("AckWatch node responses: " + this.getNodes());
        }
        if ((nodeResponse = this.getResponsibleNodeResponse()) == null) {
            this.status = Status.NO_SUCH_WATCH;
            this.statusMessage = "Could not find watch";
            return;
        }
        this.status = nodeResponse.getStatus();
        this.statusMessage = nodeResponse.getMessage();
    }

    private TransportAckWatchAction.NodeResponse getResponsibleNodeResponse() {
        for (TransportAckWatchAction.NodeResponse nodeResponse : this.getNodes()) {
            if (nodeResponse.getStatus() != Status.SUCCESS) continue;
            return nodeResponse;
        }
        for (TransportAckWatchAction.NodeResponse nodeResponse : this.getNodes()) {
            if (nodeResponse.getStatus() != Status.ILLEGAL_STATE && nodeResponse.getStatus() != Status.NO_SUCH_ACTION && nodeResponse.getStatus() != Status.NOT_ACKNOWLEDGEABLE && nodeResponse.getStatus() != Status.NO_SUCH_TENANT) continue;
            return nodeResponse;
        }
        for (TransportAckWatchAction.NodeResponse nodeResponse : this.getNodes()) {
            if (nodeResponse.getStatus() != Status.EXCEPTION && nodeResponse.getStatus() != Status.UNAUTHORIZED) continue;
            return nodeResponse;
        }
        return null;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.initStatus();
        }
        return this.status;
    }

    public String getStatusMessage() {
        if (this.status == null) {
            this.initStatus();
        }
        return this.statusMessage;
    }

    public static enum Status {
        SUCCESS,
        NO_SUCH_WATCH,
        EXCEPTION,
        ILLEGAL_STATE,
        NO_SUCH_TENANT,
        UNAUTHORIZED,
        NO_SUCH_ACTION,
        NOT_ACKNOWLEDGEABLE;

    }
}

