/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.execute;

import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.signals.NoSuchTenantException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.SignalsUnavailableException;
import com.floragunn.signals.actions.watch.execute.ExecuteWatchRequest;
import com.floragunn.signals.actions.watch.execute.ExecuteWatchResponse;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.GotoCheckSelector;
import com.floragunn.signals.execution.WatchExecutionException;
import com.floragunn.signals.execution.WatchRunner;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.support.ToXParams;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.ValidatingThrottlePeriodParser;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.result.WatchLog;
import com.floragunn.signals.watch.result.WatchLogIndexWriter;
import com.google.common.base.Charsets;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class TransportExecuteWatchAction
extends HandledTransportAction<ExecuteWatchRequest, ExecuteWatchResponse> {
    private static final Logger log = LogManager.getLogger(TransportExecuteWatchAction.class);
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final Settings settings;
    private final ClusterService clusterService;
    private final DiagnosticContext diagnosticContext;

    @Inject
    public TransportExecuteWatchAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Client client, Settings settings, ClusterService clusterService, DiagnosticContext diagnosticContext) {
        super("cluster:admin:searchguard:tenant:signals:watch/execute", transportService, actionFilters, ExecuteWatchRequest::new);
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.settings = settings;
        this.clusterService = clusterService;
        this.diagnosticContext = diagnosticContext;
    }

    protected final void doExecute(Task task, ExecuteWatchRequest request, ActionListener<ExecuteWatchResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (request.getWatchJson() != null) {
                this.executeAnonymousWatch(user, signalsTenant, task, request, listener);
            } else if (request.getWatchId() != null) {
                this.fetchAndExecuteWatch(user, signalsTenant, task, request, listener);
            }
        }
        catch (NoSuchTenantException e) {
            listener.onResponse((Object)new ExecuteWatchResponse(e.getTenant(), request.getWatchId(), ExecuteWatchResponse.Status.TENANT_NOT_FOUND, null));
        }
        catch (SignalsUnavailableException e) {
            listener.onFailure((Exception)((Object)e.toElasticsearchException()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    private void fetchAndExecuteWatch(final User user, final SignalsTenant signalsTenant, Task task, final ExecuteWatchRequest request, final ActionListener<ExecuteWatchResponse> listener) {
        final ThreadContext threadContext = this.threadPool.getThreadContext();
        final Object remoteAddress = threadContext.getTransient("_sg_remote_address");
        final Object origin = threadContext.getTransient("_sg_origin");
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            threadContext.putHeader("_sg_conf_request", "true");
            threadContext.putTransient("_sg_user", (Object)user);
            threadContext.putTransient("_sg_remote_address", remoteAddress);
            threadContext.putTransient("_sg_origin", origin);
            ((GetRequestBuilder)this.client.prepareGet().setIndex(signalsTenant.getConfigIndexName())).setId(signalsTenant.getWatchIdForConfigIndex(request.getWatchId())).execute((ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    try {
                        if (!response.isExists()) {
                            listener.onResponse((Object)new ExecuteWatchResponse(user != null ? user.getRequestedTenant() : null, request.getWatchId(), ExecuteWatchResponse.Status.NOT_FOUND, null));
                            return;
                        }
                        WatchInitializationService initService = new WatchInitializationService(TransportExecuteWatchAction.this.signals.getAccountRegistry(), TransportExecuteWatchAction.this.scriptService, TransportExecuteWatchAction.this.signals.getTruststoreRegistry(), TransportExecuteWatchAction.this.signals.getHttpProxyHostRegistry(), new ValidatingThrottlePeriodParser(TransportExecuteWatchAction.this.signals.getSignalsSettings()), ValidationLevel.LENIENT);
                        Watch watch = Watch.parse(initService, signalsTenant.getName(), request.getWatchId(), response.getSourceAsString(), response.getVersion());
                        try (ThreadContext.StoredContext ctx = TransportExecuteWatchAction.this.threadPool.getThreadContext().stashContext();){
                            threadContext.putTransient("_sg_user", (Object)user);
                            threadContext.putTransient("_sg_remote_address", remoteAddress);
                            threadContext.putTransient("_sg_origin", origin);
                            listener.onResponse((Object)TransportExecuteWatchAction.this.executeWatch(watch, request, signalsTenant));
                        }
                    }
                    catch (ConfigValidationException e) {
                        log.error("Invalid watch definition in fetchAndExecuteWatch(). This should not happen\n" + response.getSourceAsString() + "\n" + e.getValidationErrors(), (Throwable)e);
                        listener.onResponse((Object)new ExecuteWatchResponse(signalsTenant.getName(), request.getWatchId(), ExecuteWatchResponse.Status.INVALID_WATCH_DEFINITION, (BytesReference)new BytesArray(e.toJsonString().getBytes(Charsets.UTF_8))));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void executeAnonymousWatch(User user, SignalsTenant signalsTenant, Task task, ExecuteWatchRequest request, ActionListener<ExecuteWatchResponse> listener) {
        try {
            WatchInitializationService initService = new WatchInitializationService(this.signals.getAccountRegistry(), this.scriptService, this.signals.getTruststoreRegistry(), this.signals.getHttpProxyHostRegistry(), new ValidatingThrottlePeriodParser(this.signals.getSignalsSettings()), ValidationLevel.LENIENT);
            Watch watch = Watch.parse(initService, signalsTenant.getName(), "__inline_watch", request.getWatchJson(), -1L);
            this.threadPool.generic().submit(this.threadPool.getThreadContext().preserveContext(() -> {
                try {
                    listener.onResponse((Object)this.executeWatch(watch, request, signalsTenant));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }));
        }
        catch (ConfigValidationException e) {
            listener.onResponse((Object)new ExecuteWatchResponse(signalsTenant.getName(), request.getWatchId(), ExecuteWatchResponse.Status.INVALID_WATCH_DEFINITION, (BytesReference)new BytesArray(e.toJsonString().getBytes(Charsets.UTF_8))));
        }
        catch (Exception e) {
            log.error("Error while executing anonymous watch " + (Object)((Object)request), (Throwable)e);
            listener.onFailure(e);
        }
    }

    private ExecuteWatchResponse executeWatch(Watch watch, ExecuteWatchRequest request, SignalsTenant signalsTenant) {
        WatchLogIndexWriter watchLogWriter = null;
        NestedValueMap input = null;
        GotoCheckSelector checkSelector = null;
        ToXContent.Params watchLogToXparams = ToXParams.of(WatchLog.ToXContentParams.INCLUDE_DATA, !request.isIncludeAllRuntimeAttributesInResponse(), WatchLog.ToXContentParams.INCLUDE_RUNTIME_ATTRIBUTES, request.isIncludeAllRuntimeAttributesInResponse());
        if (request.isRecordExecution()) {
            watchLogWriter = WatchLogIndexWriter.forTenant(this.client, signalsTenant.getName(), new SignalsSettings(this.settings), watchLogToXparams);
        }
        if (request.getInputJson() != null) {
            try {
                input = NestedValueMap.fromJsonString(request.getInputJson());
            }
            catch (DocumentParseException | UnexpectedDocumentStructureException e) {
                log.info("Error while parsing json: " + request.getInputJson(), e);
                return new ExecuteWatchResponse(null, request.getWatchId(), ExecuteWatchResponse.Status.INVALID_INPUT, null);
            }
        }
        if (request.getGoTo() != null) {
            try {
                checkSelector = new GotoCheckSelector(watch, request.getGoTo());
            }
            catch (IllegalArgumentException e) {
                log.info("Error while parsing goTo: " + e);
                return new ExecuteWatchResponse(null, request.getWatchId(), ExecuteWatchResponse.Status.INVALID_GOTO, null);
            }
        }
        WatchRunner watchRunner = new WatchRunner(watch, this.client, this.signals.getAccountRegistry(), this.scriptService, watchLogWriter, null, this.diagnosticContext, null, ExecutionEnvironment.TEST, request.getSimulationMode(), this.xContentRegistry, this.signals.getSignalsSettings(), this.clusterService.getNodeName(), checkSelector, input, this.signals.getTruststoreRegistry());
        try {
            WatchLog watchLog = watchRunner.execute();
            return new ExecuteWatchResponse(null, request.getWatchId(), ExecuteWatchResponse.Status.EXECUTED, this.toBytesReference((ToXContent)watchLog, watchLogToXparams));
        }
        catch (WatchExecutionException e) {
            log.info("Error while manually executing watch", (Throwable)e);
            return new ExecuteWatchResponse(null, request.getWatchId(), ExecuteWatchResponse.Status.ERROR_WHILE_EXECUTING, this.toBytesReference((ToXContent)e.getWatchLog(), watchLogToXparams));
        }
    }

    private BytesReference toBytesReference(ToXContent toXContent, ToXContent.Params toXparams) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            toXContent.toXContent(builder, toXparams);
            return BytesReference.bytes((XContentBuilder)builder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

