/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.confconv.es;

import com.floragunn.codova.config.temporal.DurationFormat;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchsupport.jobs.config.schedule.Schedule;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleImpl;
import com.floragunn.searchsupport.jobs.config.schedule.elements.DailyTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.HourlyTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.MonthlyTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.WeeklyTrigger;
import com.floragunn.signals.confconv.ConversionResult;
import com.google.common.primitives.Ints;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class ScheduleConverter {
    private final DocNode scheduleJsonNode;

    public ScheduleConverter(DocNode scheduleJsonNode) {
        this.scheduleJsonNode = scheduleJsonNode;
    }

    public ConversionResult<Schedule> convertToSignals() {
        ConversionResult<List<Trigger>> yearlyTrigger;
        ArrayList<Object> triggers = new ArrayList<Object>();
        ValidationErrors validationErrors = new ValidationErrors();
        if (this.scheduleJsonNode.hasNonNull("hourly")) {
            if (this.scheduleJsonNode.getAsNode("hourly").hasNonNull("minute")) {
                try {
                    triggers.add(HourlyTrigger.create((DocNode)this.scheduleJsonNode.getAsNode("hourly"), null));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("hourly", e);
                }
            } else {
                triggers.add(new HourlyTrigger(Collections.singletonList(0), null));
            }
        }
        if (this.scheduleJsonNode.hasNonNull("daily")) {
            ConversionResult<List<TimeOfDay>> at = ScheduleConverter.parseAt(this.scheduleJsonNode.getAsNode("daily").getAsNode("at"));
            validationErrors.add("daily.at", at.sourceValidationErrors);
            triggers.add(new DailyTrigger((List)at.element, null));
        }
        if (this.scheduleJsonNode.hasNonNull("weekly")) {
            ConversionResult<List<WeeklyTrigger>> weeklyTrigger = ScheduleConverter.parseWeekly(this.scheduleJsonNode.getAsNode("weekly"));
            validationErrors.add("weekly", weeklyTrigger.sourceValidationErrors);
            triggers.addAll((Collection)weeklyTrigger.element);
        }
        if (this.scheduleJsonNode.hasNonNull("monthly")) {
            ConversionResult<List<MonthlyTrigger>> monthlyTrigger = ScheduleConverter.parseMonthly(this.scheduleJsonNode.getAsNode("monthly"));
            validationErrors.add("monthly", monthlyTrigger.sourceValidationErrors);
            triggers.addAll((Collection)monthlyTrigger.element);
        }
        if (this.scheduleJsonNode.hasNonNull("yearly")) {
            yearlyTrigger = ScheduleConverter.parseYearly(this.scheduleJsonNode.getAsNode("yearly"));
            validationErrors.add("yearly", yearlyTrigger.sourceValidationErrors);
            triggers.addAll((Collection)yearlyTrigger.element);
        }
        if (this.scheduleJsonNode.hasNonNull("cron")) {
            yearlyTrigger = ScheduleConverter.parseCron(this.scheduleJsonNode.getAsNode("cron"));
            validationErrors.add("cron", yearlyTrigger.sourceValidationErrors);
            triggers.addAll((Collection)yearlyTrigger.element);
        }
        if (this.scheduleJsonNode.hasNonNull("interval")) {
            ConversionResult<List<Trigger>> trigger = ScheduleConverter.parseInterval(this.scheduleJsonNode.getAsNode("interval"));
            validationErrors.add("interval", trigger.sourceValidationErrors);
            triggers.addAll((Collection)trigger.element);
        }
        return new ConversionResult<ScheduleImpl>(new ScheduleImpl(triggers), validationErrors);
    }

    private static ConversionResult<List<WeeklyTrigger>> parseWeekly(DocNode weeklyNode) {
        if (weeklyNode.isList()) {
            ArrayList triggers = new ArrayList();
            ValidationErrors validationErrors = new ValidationErrors();
            for (DocNode subNode : weeklyNode.toListOfNodes()) {
                ConversionResult<List<WeeklyTrigger>> subResult = ScheduleConverter.parseWeekly(subNode);
                triggers.addAll((Collection)subResult.element);
                validationErrors.add(null, subResult.sourceValidationErrors);
            }
            return new ConversionResult<List<WeeklyTrigger>>(triggers, validationErrors);
        }
        if (weeklyNode.isMap()) {
            ConversionResult<List<DayOfWeek>> on;
            ConversionResult<List<TimeOfDay>> at;
            ValidationErrors validationErrors = new ValidationErrors();
            if (weeklyNode.hasNonNull("at")) {
                at = ScheduleConverter.parseAt(weeklyNode.getAsNode("at"));
                validationErrors.add("at", at.sourceValidationErrors);
            } else {
                at = ScheduleConverter.parseAt(weeklyNode.getAsNode("time"));
                validationErrors.add("time", at.sourceValidationErrors);
            }
            if (weeklyNode.hasNonNull("on")) {
                on = ScheduleConverter.parseOn(weeklyNode.getAsNode("on"));
                validationErrors.add("on", at.sourceValidationErrors);
            } else {
                on = ScheduleConverter.parseOn(weeklyNode.getAsNode("day"));
                validationErrors.add("day", at.sourceValidationErrors);
            }
            return new ConversionResult<List<WeeklyTrigger>>(Collections.singletonList(new WeeklyTrigger((List)on.element, (List)at.element, null)), validationErrors);
        }
        return new ConversionResult<List<WeeklyTrigger>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)weeklyNode, (Object)"array or object")));
    }

    private static ConversionResult<List<MonthlyTrigger>> parseMonthly(DocNode monthlyNode) {
        if (monthlyNode.isList()) {
            ArrayList triggers = new ArrayList();
            ValidationErrors validationErrors = new ValidationErrors();
            for (DocNode subNode : monthlyNode.toListOfNodes()) {
                ConversionResult<List<MonthlyTrigger>> subResult = ScheduleConverter.parseMonthly(subNode);
                triggers.addAll((Collection)subResult.element);
                validationErrors.add(null, subResult.sourceValidationErrors);
            }
            return new ConversionResult<List<MonthlyTrigger>>(triggers, validationErrors);
        }
        if (monthlyNode.isMap()) {
            ConversionResult<List<Integer>> on;
            ConversionResult<List<TimeOfDay>> at;
            ValidationErrors validationErrors = new ValidationErrors();
            if (monthlyNode.hasNonNull("at")) {
                at = ScheduleConverter.parseAt(monthlyNode.getAsNode("at"));
                validationErrors.add("at", at.sourceValidationErrors);
            } else {
                at = ScheduleConverter.parseAt(monthlyNode.getAsNode("time"));
                validationErrors.add("time", at.sourceValidationErrors);
            }
            if (monthlyNode.hasNonNull("on")) {
                on = ScheduleConverter.parseOnDayOfMonth(monthlyNode.getAsNode("on"));
                validationErrors.add("on", at.sourceValidationErrors);
            } else {
                on = ScheduleConverter.parseOnDayOfMonth(monthlyNode.getAsNode("day"));
                validationErrors.add("day", at.sourceValidationErrors);
            }
            return new ConversionResult<List<MonthlyTrigger>>(Collections.singletonList(new MonthlyTrigger((List)on.element, (List)at.element, null)), validationErrors);
        }
        return new ConversionResult<List<MonthlyTrigger>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)monthlyNode, (Object)"array or object")));
    }

    private static ConversionResult<List<Trigger>> parseYearly(DocNode yearlyNode) {
        if (yearlyNode.isList()) {
            ArrayList triggers = new ArrayList();
            ValidationErrors validationErrors = new ValidationErrors();
            for (DocNode subNode : yearlyNode.toListOfNodes()) {
                ConversionResult<List<Trigger>> subResult = ScheduleConverter.parseYearly(subNode);
                triggers.addAll((Collection)subResult.element);
                validationErrors.add(null, subResult.sourceValidationErrors);
            }
            return new ConversionResult<List<Trigger>>(triggers, validationErrors);
        }
        if (yearlyNode.isMap()) {
            ConversionResult<List<Integer>> inMonth;
            ConversionResult<List<Integer>> on;
            ConversionResult<List<TimeOfDay>> at;
            ValidationErrors validationErrors = new ValidationErrors();
            if (yearlyNode.hasNonNull("at")) {
                at = ScheduleConverter.parseAt(yearlyNode.getAsNode("at"));
                validationErrors.add("at", at.sourceValidationErrors);
            } else {
                at = ScheduleConverter.parseAt(yearlyNode.getAsNode("time"));
                validationErrors.add("time", at.sourceValidationErrors);
            }
            if (yearlyNode.hasNonNull("on")) {
                on = ScheduleConverter.parseOnDayOfMonth(yearlyNode.getAsNode("on"));
                validationErrors.add("on", on.sourceValidationErrors);
            } else {
                on = ScheduleConverter.parseOnDayOfMonth(yearlyNode.getAsNode("day"));
                validationErrors.add("day", on.sourceValidationErrors);
            }
            if (yearlyNode.hasNonNull("in")) {
                inMonth = ScheduleConverter.parseInMonth(yearlyNode.getAsNode("in"));
                validationErrors.add("in", inMonth.sourceValidationErrors);
            } else {
                inMonth = ScheduleConverter.parseOnDayOfMonth(yearlyNode.getAsNode("month"));
                validationErrors.add("month", inMonth.sourceValidationErrors);
            }
            ArrayList<Trigger> triggers = new ArrayList<Trigger>();
            for (TimeOfDay timeOfDay : (List)at.element) {
                for (Integer dayOfMonth : (List)on.element) {
                    String cronExpression = timeOfDay.getSecond() + " " + timeOfDay.getMinute() + " " + timeOfDay.getHour() + " " + dayOfMonth + " " + Strings.join((Iterable)((Iterable)inMonth.element), (char)',') + " *";
                    try {
                        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)cronExpression)).build();
                        triggers.add(trigger);
                    }
                    catch (ParseException e) {
                        validationErrors.add(new InvalidAttributeValue(null, (Object)cronExpression, (Object)"Quartz Cron Expression: <Seconds: 0-59|*> <Minutes: 0-59|*> <Hours: 0-23|*> <Day-of-Month: 1-31|?|*> <Month: JAN-DEC|*> <Day-of-Week: SUN-SAT|?|*> <Year: 1970-2199|*>?. Numeric ranges: 1-2; Several distinct values: 1,2; Increments: 0/15").message("Invalid cron expression: " + e.getMessage()).cause((Throwable)e));
                    }
                }
            }
            return new ConversionResult<List<Trigger>>(triggers, validationErrors);
        }
        return new ConversionResult<List<Trigger>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)yearlyNode, (Object)"array or object")));
    }

    private static ConversionResult<List<Trigger>> parseCron(DocNode cronNode) {
        if (cronNode.isList()) {
            ArrayList triggers = new ArrayList();
            ValidationErrors validationErrors = new ValidationErrors();
            for (DocNode subNode : cronNode.toListOfNodes()) {
                ConversionResult<List<Trigger>> subResult = ScheduleConverter.parseCron(subNode);
                triggers.addAll((Collection)subResult.element);
                validationErrors.add(null, subResult.sourceValidationErrors);
            }
            return new ConversionResult<List<Trigger>>(triggers, validationErrors);
        }
        if (cronNode.isString()) {
            ArrayList<Trigger> triggers = new ArrayList<Trigger>();
            ValidationErrors validationErrors = new ValidationErrors();
            try {
                Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)cronNode.toString())).build();
                triggers.add(trigger);
            }
            catch (ParseException e) {
                validationErrors.add(new InvalidAttributeValue(null, (Object)cronNode.toString(), (Object)"Quartz Cron Expression: <Seconds: 0-59|*> <Minutes: 0-59|*> <Hours: 0-23|*> <Day-of-Month: 1-31|?|*> <Month: JAN-DEC|*> <Day-of-Week: SUN-SAT|?|*> <Year: 1970-2199|*>?. Numeric ranges: 1-2; Several distinct values: 1,2; Increments: 0/15").message("Invalid cron expression: " + e.getMessage()).cause((Throwable)e));
            }
            return new ConversionResult<List<Trigger>>(triggers, validationErrors);
        }
        return new ConversionResult<List<Trigger>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)cronNode, (Object)"array or cron string")));
    }

    private static ConversionResult<List<Trigger>> parseInterval(DocNode intervalNode) {
        if (intervalNode.isList()) {
            ArrayList triggers = new ArrayList();
            ValidationErrors validationErrors = new ValidationErrors();
            for (DocNode subNode : intervalNode.toListOfNodes()) {
                ConversionResult<List<Trigger>> subResult = ScheduleConverter.parseInterval(subNode);
                triggers.addAll((Collection)subResult.element);
                validationErrors.add(null, subResult.sourceValidationErrors);
            }
            return new ConversionResult<List<Trigger>>(triggers, validationErrors);
        }
        if (intervalNode.isString()) {
            Integer numeric = Ints.tryParse((String)intervalNode.toString());
            if (numeric != null) {
                return new ConversionResult<List<Trigger>>(Collections.singletonList(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds((long)(numeric * 1000))).build()));
            }
            try {
                Duration duration = DurationFormat.INSTANCE.parse(intervalNode.toString());
                return new ConversionResult<List<Trigger>>(Collections.singletonList(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(duration.toMillis())).build()));
            }
            catch (ConfigValidationException e) {
                return new ConversionResult<List<Trigger>>(Collections.emptyList(), new ValidationErrors().add(null, e));
            }
        }
        if (intervalNode.isNumber()) {
            try {
                return new ConversionResult<List<Trigger>>(Collections.singletonList(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds((long)(intervalNode.toNumber().intValue() * 1000))).build()));
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException(e);
            }
        }
        return new ConversionResult<List<Trigger>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)intervalNode, (Object)"array or cron string")));
    }

    private static ConversionResult<List<TimeOfDay>> parseAt(DocNode atNode) {
        try {
            if (atNode == null || atNode.isNull()) {
                return new ConversionResult<List<TimeOfDay>>(Collections.singletonList(new TimeOfDay(0, 0)));
            }
            if (atNode.isList()) {
                ArrayList<TimeOfDay> at = new ArrayList<TimeOfDay>(atNode.size());
                ValidationErrors validationErrors = new ValidationErrors();
                for (DocNode atNodeElement : atNode.toListOfNodes()) {
                    try {
                        at.add(ScheduleConverter.parseTimeOfDay(atNodeElement.toString()));
                    }
                    catch (ConfigValidationException e) {
                        validationErrors.add(null, e);
                    }
                }
                return new ConversionResult<List<TimeOfDay>>(at, validationErrors);
            }
            if (atNode.isString()) {
                try {
                    return new ConversionResult<List<TimeOfDay>>(Collections.singletonList(ScheduleConverter.parseTimeOfDay(atNode.toString())));
                }
                catch (ConfigValidationException e) {
                    return new ConversionResult<List<TimeOfDay>>(Collections.emptyList(), new ValidationErrors().add(null, e));
                }
            }
            if (atNode.isMap()) {
                DocNode hourNode = atNode.getAsNode("hour");
                DocNode minuteNode = atNode.getAsNode("minute");
                if ((hourNode == null || hourNode.isNull()) && (minuteNode == null || minuteNode.isNull())) {
                    return new ConversionResult<List<TimeOfDay>>(Collections.singletonList(new TimeOfDay(0, 0)));
                }
                if (hourNode != null && hourNode.isNumber() && minuteNode != null && minuteNode.isNumber()) {
                    return new ConversionResult<List<TimeOfDay>>(Collections.singletonList(new TimeOfDay(hourNode.toNumber().intValue(), hourNode.toNumber().intValue())));
                }
                if (hourNode != null && hourNode.isNumber() && minuteNode == null) {
                    return new ConversionResult<List<TimeOfDay>>(Collections.singletonList(new TimeOfDay(hourNode.toNumber().intValue(), 0)));
                }
                if (hourNode == null || hourNode.isNull()) {
                    return new ConversionResult<List<TimeOfDay>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new MissingAttribute("hour", (Object)atNode)));
                }
                if (hourNode != null && hourNode.isList() && minuteNode != null && minuteNode.isNumber()) {
                    ValidationErrors validationErrors = new ValidationErrors();
                    int minute = minuteNode.toNumber().intValue();
                    ArrayList<TimeOfDay> at = new ArrayList<TimeOfDay>();
                    for (DocNode hour : hourNode.toListOfNodes()) {
                        if (hour.isNumber()) {
                            at.add(new TimeOfDay(hour.toNumber().intValue(), minute));
                            continue;
                        }
                        validationErrors.add((ValidationError)new InvalidAttributeValue("hour", (Object)hour, (Object)"number"));
                    }
                    return new ConversionResult<List<TimeOfDay>>(at, validationErrors);
                }
                if (hourNode != null && hourNode.isNumber() && minuteNode != null && minuteNode.isList()) {
                    ValidationErrors validationErrors = new ValidationErrors();
                    int hour = hourNode.toNumber().intValue();
                    ArrayList<TimeOfDay> at = new ArrayList<TimeOfDay>();
                    for (DocNode minute : minuteNode.toListOfNodes()) {
                        if (minute.isNumber()) {
                            at.add(new TimeOfDay(hour, minute.toNumber().intValue()));
                            continue;
                        }
                        validationErrors.add((ValidationError)new InvalidAttributeValue("minute", (Object)minute, (Object)"number"));
                    }
                    return new ConversionResult<List<TimeOfDay>>(at, validationErrors);
                }
                if (hourNode != null && hourNode.isList() && minuteNode != null && minuteNode.isList()) {
                    ValidationErrors validationErrors = new ValidationErrors();
                    ArrayList<TimeOfDay> at = new ArrayList<TimeOfDay>();
                    for (DocNode hour : hourNode.toListOfNodes()) {
                        for (DocNode minute : minuteNode.toListOfNodes()) {
                            if (hour.isNumber() && minute.isNumber()) {
                                at.add(new TimeOfDay(hour.toNumber().intValue(), minute.toNumber().intValue()));
                                continue;
                            }
                            if (!hour.isNumber()) {
                                validationErrors.add((ValidationError)new InvalidAttributeValue("hour", (Object)hour, (Object)"number"));
                            }
                            if (minute.isNumber()) continue;
                            validationErrors.add((ValidationError)new InvalidAttributeValue("minute", (Object)minute, (Object)"number"));
                        }
                    }
                    return new ConversionResult<List<TimeOfDay>>(at, validationErrors);
                }
                return new ConversionResult<List<TimeOfDay>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)atNode, null)));
            }
            return new ConversionResult<List<TimeOfDay>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)atNode, (Object)"time string or array or object")));
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static ConversionResult<List<DayOfWeek>> parseOn(DocNode onNode) {
        if (onNode == null || onNode.isNull()) {
            return new ConversionResult<List<DayOfWeek>>(Collections.singletonList(DayOfWeek.MONDAY));
        }
        if (onNode.isList()) {
            ArrayList<DayOfWeek> on = new ArrayList<DayOfWeek>(onNode.size());
            ValidationErrors validationErrors = new ValidationErrors();
            for (DocNode onNodeElement : onNode.toListOfNodes()) {
                try {
                    on.add(ScheduleConverter.getDayOfWeek(onNodeElement.toString()));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(null, e);
                }
            }
            return new ConversionResult<List<DayOfWeek>>(on, validationErrors);
        }
        if (onNode.isString()) {
            try {
                return new ConversionResult<List<DayOfWeek>>(Collections.singletonList(ScheduleConverter.getDayOfWeek(onNode.toString())));
            }
            catch (ConfigValidationException e) {
                return new ConversionResult<List<DayOfWeek>>(Collections.emptyList(), new ValidationErrors().add(null, e));
            }
        }
        return new ConversionResult<List<DayOfWeek>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)onNode, (Object)"day string or array")));
    }

    private static ConversionResult<List<Integer>> parseOnDayOfMonth(DocNode onNode) {
        try {
            if (onNode == null || onNode.isNull()) {
                return new ConversionResult<List<Integer>>(Collections.singletonList(1));
            }
            if (onNode.isList()) {
                ArrayList<Integer> on = new ArrayList<Integer>(onNode.size());
                ValidationErrors validationErrors = new ValidationErrors();
                for (DocNode onNodeElement : onNode.toListOfNodes()) {
                    if (onNodeElement.isNumber()) {
                        on.add(onNodeElement.toNumber().intValue());
                        continue;
                    }
                    validationErrors.add((ValidationError)new InvalidAttributeValue(null, (Object)onNodeElement, (Object)"number between 1 and 31"));
                }
                return new ConversionResult<List<Integer>>(on, validationErrors);
            }
            if (onNode.isNumber()) {
                return new ConversionResult<List<Integer>>(Collections.singletonList(onNode.toNumber().intValue()));
            }
            return new ConversionResult<List<Integer>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)onNode, (Object)"number between 1 and 31 or array")));
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static TimeOfDay parseTimeOfDay(String string) throws ConfigValidationException {
        try {
            int minute;
            if (string.equalsIgnoreCase("noon")) {
                return new TimeOfDay(12, 0);
            }
            if (string.equalsIgnoreCase("midnight")) {
                return new TimeOfDay(0, 0);
            }
            int colon = string.indexOf(58);
            if (colon == -1) {
                int hour = Integer.parseInt(string);
                if (hour < 0 || hour >= 24) {
                    throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)string, (Object)"Hour must be between 0 and 23"));
                }
                return new TimeOfDay(hour, 0);
            }
            int hour = Integer.parseInt(string.substring(0, colon));
            int second = 0;
            int nextColon = string.indexOf(58, colon + 1);
            if (nextColon == -1) {
                minute = Integer.parseInt(string.substring(colon + 1));
            } else {
                minute = Integer.parseInt(string.substring(colon + 1, nextColon));
                second = Integer.parseInt(string.substring(nextColon + 1));
            }
            ValidationErrors validationErrors = new ValidationErrors();
            if (hour < 0 || hour >= 24) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)string, (Object)"Hour must be between 0 and 23"));
            }
            if (minute < 0 || minute >= 60) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)string, (Object)"Minute must be between 0 and 59"));
            }
            if (second < 0 || second >= 60) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)string, (Object)"Second must be between 0 and 59"));
            }
            validationErrors.throwExceptionForPresentErrors();
            return new TimeOfDay(hour, minute, second);
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"Time of day: <HH>:<MM>:<SS>?").cause((Throwable)e));
        }
    }

    private static ConversionResult<List<Integer>> parseInMonth(DocNode node) {
        try {
            if (node == null || node.isNull()) {
                return new ConversionResult<List<Integer>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new MissingAttribute(null, (Object)node)));
            }
            if (node.isNumber()) {
                return new ConversionResult<List<Integer>>(Collections.singletonList(node.toNumber().intValue()));
            }
            if (node.isString()) {
                try {
                    return new ConversionResult<List<Integer>>(Collections.singletonList(ScheduleConverter.parseMonth(node.toString())));
                }
                catch (ConfigValidationException e) {
                    return new ConversionResult<List<Integer>>(Collections.emptyList(), new ValidationErrors().add(null, e));
                }
            }
            if (node.isList()) {
                ArrayList result = new ArrayList();
                ValidationErrors validationErrors = new ValidationErrors();
                for (DocNode subNode : node.toListOfNodes()) {
                    ConversionResult<List<Integer>> subResult = ScheduleConverter.parseInMonth(subNode);
                    result.addAll((Collection)subResult.element);
                    validationErrors.add(null, subResult.sourceValidationErrors);
                }
                return new ConversionResult<List<Integer>>(result, validationErrors);
            }
            return new ConversionResult<List<Integer>>(Collections.emptyList(), new ValidationErrors().add((ValidationError)new InvalidAttributeValue(null, (Object)node, (Object)"month")));
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Integer parseMonth(String string) throws ConfigValidationException {
        switch (string.toLowerCase()) {
            case "january": 
            case "jan": {
                return 1;
            }
            case "february": 
            case "feb": {
                return 2;
            }
            case "march": 
            case "mar": {
                return 3;
            }
            case "april": 
            case "apr": {
                return 4;
            }
            case "may": {
                return 5;
            }
            case "june": 
            case "jun": {
                return 6;
            }
            case "july": 
            case "jul": {
                return 7;
            }
            case "august": 
            case "aug": {
                return 8;
            }
            case "september": 
            case "sep": {
                return 9;
            }
            case "october": 
            case "oct": {
                return 10;
            }
            case "november": 
            case "nov": {
                return 11;
            }
            case "december": 
            case "dec": {
                return 12;
            }
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)string, (Object)"month"));
    }

    private static DayOfWeek getDayOfWeek(String string) throws ConfigValidationException {
        switch (string.toLowerCase()) {
            case "sunday": 
            case "sun": {
                return DayOfWeek.SUNDAY;
            }
            case "monday": 
            case "mon": {
                return DayOfWeek.MONDAY;
            }
            case "tuesday": 
            case "tue": {
                return DayOfWeek.TUESDAY;
            }
            case "wednesday": 
            case "wed": {
                return DayOfWeek.WEDNESDAY;
            }
            case "thursday": 
            case "thu": {
                return DayOfWeek.THURSDAY;
            }
            case "friday": 
            case "fri": {
                return DayOfWeek.FRIDAY;
            }
            case "saturday": 
            case "sat": {
                return DayOfWeek.SATURDAY;
            }
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)string, (Object)"mon|tue|wed|thu|fri|sat|sun"));
    }
}

