/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.Signals;
import com.floragunn.signals.truststore.rest.TransportTruststoreUpdatedAction;
import com.floragunn.signals.truststore.service.TruststoreCrudService;
import com.floragunn.signals.truststore.service.persistence.TruststoreRepository;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;

public class DeleteTruststoreAction
extends Action<StandardRequests.IdRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(DeleteTruststoreAction.class);
    public static final String NAME = "cluster:admin:searchguard:signals:truststores/delete";
    public static final DeleteTruststoreAction INSTANCE = new DeleteTruststoreAction();
    public static final RestApi REST_API = new RestApi().responseHeaders((Map)SearchGuardVersion.header()).handlesDelete("/_signals/truststores/{id}").with((Action)INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).name("DELETE /_signals/truststores/{id}");

    private DeleteTruststoreAction() {
        super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
    }

    public static class DeleteTruststoreHandler
    extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
        private final TruststoreCrudService truststoreCrudService;
        private final NodeClient client;

        @Inject
        public DeleteTruststoreHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
            super((Action)INSTANCE, handlerDependencies);
            PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
            TruststoreRepository truststoreRepository = new TruststoreRepository(signals.getSignalsSettings(), privilegedConfigClient);
            this.truststoreCrudService = new TruststoreCrudService(truststoreRepository);
            this.client = client;
        }

        protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
            return this.supplyAsync(() -> {
                StandardResponse response = this.truststoreCrudService.delete(request);
                log.debug("Truststore '{}' deleted", (Object)request.getId());
                TransportTruststoreUpdatedAction.TruststoreUpdatedActionType.send((Client)this.client, request.getId(), "delete").actionGet();
                log.debug("Notification related to truststore '{}' deletion send.", (Object)request.getId());
                return response;
            });
        }
    }
}

