/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.Signals;
import com.floragunn.signals.truststore.service.NoSuchTruststoreException;
import com.floragunn.signals.truststore.service.TruststoreCrudService;
import com.floragunn.signals.truststore.service.persistence.TruststoreRepository;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;

public class FindOneTruststoreAction
extends Action<StandardRequests.IdRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(FindOneTruststoreAction.class);
    public static final String NAME = "cluster:admin:searchguard:signals:truststores/findone";
    public static final FindOneTruststoreAction INSTANCE = new FindOneTruststoreAction();
    public static final RestApi REST_API = new RestApi().responseHeaders((Map)SearchGuardVersion.header()).handlesGet("/_signals/truststores/{id}").with((Action)INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).name("GET /_signals/truststores/{id}");

    private FindOneTruststoreAction() {
        super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
    }

    public static class FindOneTruststoreHandler
    extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
        private final TruststoreCrudService truststoreCrudService;

        @Inject
        public FindOneTruststoreHandler(Action.HandlerDependencies handlerDependencies, NodeClient client, Signals signals) {
            super((Action)INSTANCE, handlerDependencies);
            PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
            TruststoreRepository truststoreRepository = new TruststoreRepository(signals.getSignalsSettings(), privilegedConfigClient);
            this.truststoreCrudService = new TruststoreCrudService(truststoreRepository);
        }

        protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
            return this.supplyAsync(() -> {
                try {
                    return this.truststoreCrudService.findOne(request);
                }
                catch (NoSuchTruststoreException e) {
                    log.debug("Trust store '{}' not found", (Object)request.getId(), (Object)e);
                    return new StandardResponse(404).error(e.getMessage());
                }
                catch (Exception e) {
                    log.warn("Cannot load trust store '{}' data", (Object)request.getId(), (Object)e);
                    return new StandardResponse(500).error("Cannot parse load store data. " + e.getMessage());
                }
            });
        }
    }
}

