/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.checks;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchsupport.xcontent.ObjectTreeXContent;
import com.floragunn.signals.execution.CheckExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.script.SignalsScriptContextFactory;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.checks.AbstractInput;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public abstract class AbstractSearchInput
extends AbstractInput {
    private static final Logger log = LogManager.getLogger(AbstractSearchInput.class);
    protected final List<String> indices;
    protected TimeValue timeout;
    protected TemplateScript.Factory templateScriptFactory;
    protected SearchType searchType;
    protected IndicesOptions indicesOptions;

    public AbstractSearchInput(String name, String target, List<String> indices) {
        super(name, target);
        this.indices = Collections.unmodifiableList(indices);
    }

    public List<String> getIndices() {
        return this.indices;
    }

    protected String[] getIndicesAsArray() {
        return this.indices.toArray(new String[this.indices.size()]);
    }

    protected abstract Script createTemplateScript();

    protected String executeTemplateScript(WatchExecutionContext ctx) {
        Map<String, Object> actualTemplateScriptParams = this.getTemplateScriptParamsAsMap(ctx);
        return this.templateScriptFactory.newInstance(actualTemplateScriptParams).execute();
    }

    public void compileScripts(WatchInitializationService watchInitService) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        this.templateScriptFactory = watchInitService.compile("request.body", this.createTemplateScript(), SignalsScriptContextFactory.TEMPLATE_CONTEXT, validationErrors);
        validationErrors.throwExceptionForPresentErrors();
    }

    @Override
    public boolean execute(WatchExecutionContext ctx) throws CheckExecutionException {
        String searchBody = this.executeTemplateScript(ctx);
        if (log.isDebugEnabled()) {
            log.debug("Executed template script:\n" + searchBody);
        }
        return this.executeSearchRequest(ctx, searchBody);
    }

    protected boolean executeSearchRequest(WatchExecutionContext ctx, String searchBody) {
        SearchRequest searchRequest = this.createSearchRequest(ctx.getxContentRegistry(), searchBody);
        if (log.isDebugEnabled()) {
            log.debug("Executing: " + searchRequest);
        }
        SearchResponse searchResponse = (SearchResponse)ctx.getClient().search(searchRequest).actionGet(this.timeout != null ? this.timeout : new TimeValue(30L, TimeUnit.SECONDS));
        if (log.isDebugEnabled()) {
            log.debug("Response: " + searchResponse);
        }
        Object result = ObjectTreeXContent.toObjectTree((ToXContent)searchResponse, (ToXContent.Params)new ToXContent.MapParams(Collections.emptyMap()), () -> NestedValueMap.createNonCloningMap());
        this.setResult(ctx, result);
        return true;
    }

    protected SearchRequest createSearchRequest(NamedXContentRegistry xContentRegistry, String searchBody) {
        SearchRequest searchRequest;
        block10: {
            XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchBody);
            try {
                SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
                SearchRequest result = new SearchRequest(this.getIndicesAsArray(), searchSourceBuilder);
                if (this.searchType != null) {
                    result.searchType(this.searchType);
                }
                if (this.indicesOptions != null) {
                    result.indicesOptions(this.indicesOptions);
                }
                searchRequest = result;
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while creating search request for " + this);
                }
            }
            parser.close();
        }
        return searchRequest;
    }

    public static IndicesOptions parseIndicesOptions(DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        EnumSet wildcards = (EnumSet)((ValidatingDocNode.Attribute)vJsonNode.get("expand_wildcards").expected("all|open|none|closed")).withDefault(EnumSet.of(IndicesOptions.WildcardStates.OPEN)).by(s -> IndicesOptions.WildcardStates.parseParameter((Object)s, null));
        IndicesOptions result = IndicesOptions.fromOptions((boolean)vJsonNode.get("ignore_unavailable").withDefault(false).asBoolean(), (boolean)vJsonNode.get("allow_no_indices").withDefault(false).asBoolean(), (boolean)wildcards.contains(IndicesOptions.WildcardStates.OPEN), (boolean)wildcards.contains(IndicesOptions.WildcardStates.CLOSED), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }
}

