/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RefreshableX509TrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LogManager.getLogger(RefreshableX509TrustManager.class);
    private final String name;
    private final LocalDateTime creationTime;
    private final Supplier<X509ExtendedTrustManager> trustManagerSupplier;

    public RefreshableX509TrustManager(String name, Supplier<X509ExtendedTrustManager> trustManagerSupplier) {
        this.name = name;
        this.creationTime = LocalDateTime.now();
        this.trustManagerSupplier = Objects.requireNonNull(trustManagerSupplier);
        log.info("Refreshable x509 trust manager '{}' created at '{}'.", (Object)name, (Object)this.creationTime);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.getTrustManager().checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.getTrustManager().checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.getTrustManager().checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.getTrustManager().checkServerTrusted(chain, authType, engine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.getTrustManager().checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.getTrustManager().checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.getTrustManager().getAcceptedIssuers();
    }

    private X509ExtendedTrustManager getTrustManager() {
        X509ExtendedTrustManager x509TrustManager = this.trustManagerSupplier.get();
        log.trace("Retrieved trust manager '{}'", (Object)x509TrustManager);
        return x509TrustManager;
    }

    public String toString() {
        return "RefreshableX509TrustManager{name='" + this.name + '\'' + ", creationTime=" + this.creationTime + '}';
    }
}

