/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RejectAllTrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LogManager.getLogger(RejectAllTrustManager.class);
    private final String truststoreId;

    public RejectAllTrustManager(String truststoreId) {
        this.truststoreId = truststoreId;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.throwExceptionRelatedToInvalidCertificates();
    }

    private void throwExceptionRelatedToInvalidCertificates() throws CertificateException {
        String message = "Watch uses not existing truststore with id " + this.truststoreId + ". Please correct watch or create truststore.";
        log.warn(message);
        throw new CertificateException(message);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.throwExceptionRelatedToInvalidCertificates();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public String toString() {
        return "RejectAllTrustManager{truststoreId='" + this.truststoreId + '\'' + '}';
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.throwExceptionRelatedToInvalidCertificates();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.throwExceptionRelatedToInvalidCertificates();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.throwExceptionRelatedToInvalidCertificates();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.throwExceptionRelatedToInvalidCertificates();
    }
}

