/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.Signals;
import org.elasticsearch.cluster.metadata.Template;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SignalsTest {
    @Test
    public void shouldCreateHiddenWatchLogIndex() {
        Template template = Signals.createWathLogTemplate((String)".i_am_hidden_watch_log_index", (int)0);
        MatcherAssert.assertThat((Object)template.settings().get("index.hidden"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)template.settings().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)template.mappings(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldCreateNonHiddenWatchLogIndex() {
        Template template = Signals.createWathLogTemplate((String)"i_am_NON_hidden_watch_log_index", (int)0);
        MatcherAssert.assertThat((Object)template.settings().get("index.hidden"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)template.settings().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)template.mappings(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldCreateIndexWithExtendedLimitForDynamicMappings() {
        Template template = Signals.createWathLogTemplate((String)"i_have_custom_settings", (int)2000);
        MatcherAssert.assertThat((Object)template.settings().get("index.hidden"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)template.settings().get("mapping.total_fields.limit"), (Matcher)Matchers.equalTo((Object)"2000"));
        MatcherAssert.assertThat((Object)template.settings().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)template.mappings(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldCreateIndexWithHiddenIndexWithExtendedLimitForDynamicMappings() {
        Template template = Signals.createWathLogTemplate((String)".i_am_hidden_and_have_custom_settings", (int)4005);
        MatcherAssert.assertThat((Object)template.settings().get("index.hidden"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)template.settings().get("mapping.total_fields.limit"), (Matcher)Matchers.equalTo((Object)"4005"));
        MatcherAssert.assertThat((Object)template.settings().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)template.mappings(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldDisableDynamicMappingForRuntimeDataForHiddenIndex() throws DocumentParseException {
        Template template = Signals.createWathLogTemplate((String)".i_am_hidden_and_have_disabled_mappings", (int)-1);
        MatcherAssert.assertThat((Object)template.settings().get("index.hidden"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)template.settings().size(), (Matcher)Matchers.equalTo((Object)1));
        String mappings = template.mappings().string();
        DocNode parsedMappings = DocNode.parse((Format)Format.JSON).from(mappings);
        MatcherAssert.assertThat((Object)parsedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.data.type", (Object)"object"));
        MatcherAssert.assertThat((Object)parsedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.data.dynamic", (Object)"false"));
    }

    @Test
    public void shouldDisableDynamicMappingForRuntimeDataForNonHiddenIndex() throws DocumentParseException {
        Template template = Signals.createWathLogTemplate((String)"i_have_disabled_mappings", (int)-1);
        MatcherAssert.assertThat((Object)template.settings().get("index.hidden"), (Matcher)Matchers.equalTo((Object)"false"));
        MatcherAssert.assertThat((Object)template.settings().size(), (Matcher)Matchers.equalTo((Object)1));
        String mappings = template.mappings().string();
        DocNode parsedMappings = DocNode.parse((Format)Format.JSON).from(mappings);
        MatcherAssert.assertThat((Object)parsedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.data.type", (Object)"object"));
        MatcherAssert.assertThat((Object)parsedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.data.dynamic", (Object)"false"));
    }
}

