/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.signals.actions.summary.SummaryToWatchFieldMapper;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ActionSummaryToWatchFieldMapperTest {
    @Test
    public void shouldMapLastTriggeredFieldForMyAction() {
        String fieldName = "actions.my-action-name.triggered";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.my-action-name.triggered");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.my-action-name.triggered");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.my-action-name.last_triggered"));
    }

    @Test
    public void shouldMapLastTriggeredFieldOtherAction() {
        String fieldName = "actions.other-action.triggered";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.other-action.triggered");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.other-action.triggered");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.other-action.last_triggered"));
    }

    @Test
    public void shouldNotFindIncorrectField() {
        String fieldName = "actions.other-action.incorrect-field";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.other-action.incorrect-field");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldMapLastCheckedFieldForMyAction() {
        String fieldName = "actions.my-action-name.checked";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.my-action-name.checked");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.my-action-name.checked");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.my-action-name.last_check"));
    }

    @Test
    public void shouldMapLastCheckedFieldForOtherAction() {
        String fieldName = "actions.other-action-name.checked";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.other-action-name.checked");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.other-action-name.checked");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.other-action-name.last_check"));
    }

    @Test
    public void shouldMapCheckResultFieldForOtherAction() {
        String fieldName = "actions.other-action-name.check_result";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.other-action-name.check_result");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.other-action-name.check_result");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.other-action-name.last_check_result"));
    }

    @Test
    public void shouldMapCheckResultFieldForImportantAction() {
        String fieldName = "actions.important-action-name.check_result";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.important-action-name.check_result");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.important-action-name.check_result");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.important-action-name.last_check_result"));
    }

    @Test
    public void shouldMapLastExecutionFieldForImportantAction() {
        String fieldName = "actions.important-action-name.execution";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.important-action-name.execution");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.important-action-name.execution");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.important-action-name.last_execution"));
    }

    @Test
    public void shouldMapLastExecutionFieldForMyAction() {
        String fieldName = "actions.my-action-name.execution";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.my-action-name.execution");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.my-action-name.execution");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.my-action-name.last_execution"));
    }

    @Test
    public void shouldMapLastErrorFieldForMyAction() {
        String fieldName = "actions.my-action-name.error";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.my-action-name.error");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.my-action-name.error");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.my-action-name.last_error"));
    }

    @Test
    public void shouldMapLastErrorFieldForOtherAction() {
        String fieldName = "actions.other-action-name.error";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.other-action-name.error");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.other-action-name.error");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.other-action-name.last_error"));
    }

    @Test
    public void shouldMapLastStatusCodeFieldForOtherAction() {
        String fieldName = "actions.other-action-name.status_code";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.other-action-name.status_code");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.other-action-name.status_code");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.other-action-name.last_status.code.keyword"));
    }

    @Test
    public void shouldMapLastStatusCodeFieldForMyAction() {
        String fieldName = "actions.my-action-name.status_code";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.my-action-name.status_code");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.my-action-name.status_code");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.my-action-name.last_status.code.keyword"));
    }

    @Test
    public void shouldMapLastStatusDetailsFieldForMyAction() {
        String fieldName = "actions.my-action-name.status_details";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.my-action-name.status_details");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.my-action-name.status_details");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.my-action-name.last_status.detail.keyword"));
    }

    @Test
    public void shouldMapLastStatusDetailsFieldForFirstAction() {
        String fieldName = "actions.first-action-name.status_details";
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)"actions.first-action-name.status_details");
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName("actions.first-action-name.status_details");
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)"actions.first-action-name.last_status.detail.keyword"));
    }
}

