/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.confconv.es;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchsupport.jobs.config.schedule.Schedule;
import com.floragunn.signals.confconv.ConversionResult;
import com.floragunn.signals.confconv.es.ActionConverter;
import com.floragunn.signals.confconv.es.ConditionConverter;
import com.floragunn.signals.confconv.es.InputConverter;
import com.floragunn.signals.confconv.es.MetaConverter;
import com.floragunn.signals.confconv.es.MustacheTemplateConverter;
import com.floragunn.signals.confconv.es.ScheduleConverter;
import com.floragunn.signals.confconv.es.TransformConverter;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.auth.Auth;
import com.floragunn.signals.watch.common.auth.BasicAuth;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EsWatcherConverter {
    private final DocNode watcherJson;

    public EsWatcherConverter(DocNode watcherJson) {
        this.watcherJson = watcherJson;
    }

    public ConversionResult<Watch> convertToSignals() {
        ConversionResult<List<Object>> conversionResult;
        ValidationErrors validationErrors = new ValidationErrors();
        Schedule schedule = null;
        ArrayList<Check> checks = new ArrayList<Check>();
        List<Object> actions = Collections.emptyList();
        if (this.watcherJson.hasNonNull("metadata")) {
            conversionResult = new MetaConverter(this.watcherJson.getAsNode("metadata")).convertToSignals();
            checks.addAll((Collection)conversionResult.getElement());
            validationErrors.add("metadata", conversionResult.getSourceValidationErrors());
        }
        if (this.watcherJson.hasNonNull("trigger") && this.watcherJson.getAsNode("trigger").hasNonNull("schedule")) {
            conversionResult = new ScheduleConverter(this.watcherJson.getAsNode("trigger").getAsNode("schedule")).convertToSignals();
            schedule = (Schedule)conversionResult.getElement();
            validationErrors.add("schedule", conversionResult.getSourceValidationErrors());
        }
        if (this.watcherJson.hasNonNull("input")) {
            conversionResult = new InputConverter(this.watcherJson.getAsNode("input")).convertToSignals();
            checks.addAll((Collection)conversionResult.getElement());
            validationErrors.add("input", conversionResult.getSourceValidationErrors());
        }
        if (this.watcherJson.hasNonNull("condition")) {
            conversionResult = new ConditionConverter(this.watcherJson.getAsNode("condition")).convertToSignals();
            checks.addAll((Collection)conversionResult.getElement());
            validationErrors.add("condition", conversionResult.getSourceValidationErrors());
        }
        if (this.watcherJson.hasNonNull("transform")) {
            conversionResult = new TransformConverter(this.watcherJson.getAsNode("transform")).convertToSignals();
            checks.addAll((Collection)conversionResult.getElement());
            validationErrors.add("transform", conversionResult.getSourceValidationErrors());
        }
        if (this.watcherJson.hasNonNull("actions")) {
            conversionResult = new ActionConverter(this.watcherJson.getAsNode("actions")).convertToSignals();
            actions = conversionResult.getElement();
            validationErrors.add("actions", conversionResult.getSourceValidationErrors());
        }
        return new ConversionResult<Watch>(new Watch(null, schedule, checks, null, actions, null), validationErrors);
    }

    static ConversionResult<HttpRequestConfig> createHttpRequestConfig(DocNode jsonNode) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        URI url = null;
        if (vJsonNode.hasNonNull("url")) {
            url = vJsonNode.get("url").required().asURI();
        } else {
            String scheme = vJsonNode.get("scheme").withDefault("http").asString();
            String host = vJsonNode.get("host").required().asString();
            int port = vJsonNode.get("port").withDefault((Number)-1).asInt();
            try {
                url = new URI(scheme, null, host, port, null, null, null);
            }
            catch (URISyntaxException e) {
                validationErrors.add(new ValidationError("url", e.getMessage()).cause((Throwable)e));
            }
        }
        String path = vJsonNode.get("path").asString();
        ConversionResult<String> convertedPath = new MustacheTemplateConverter(path).convertToSignals();
        validationErrors.add("path", convertedPath.getSourceValidationErrors());
        path = convertedPath.getElement();
        String query = vJsonNode.get("params").asString();
        ConversionResult<String> convertedQuery = new MustacheTemplateConverter(query).convertToSignals();
        validationErrors.add("params", convertedQuery.getSourceValidationErrors());
        query = convertedQuery.getElement();
        String body = vJsonNode.get("body").asString();
        ConversionResult<String> convertedBody = new MustacheTemplateConverter(body).convertToSignals();
        validationErrors.add("body", convertedBody.getSourceValidationErrors());
        body = convertedBody.getElement();
        HttpRequestConfig.Method method = (HttpRequestConfig.Method)vJsonNode.get("method").withDefault((Enum)HttpRequestConfig.Method.GET).asEnum(HttpRequestConfig.Method.class);
        Map<String, String> headers = !vJsonNode.hasNonNull("headers") ? null : vJsonNode.getAsDocNode("headers").keySet().stream().collect(Collectors.toMap(key -> key, key -> {
            String headerValue = vJsonNode.get("headers").asValidatingDocNode().get(key).asString();
            if (headerValue == null) {
                validationErrors.add(new ValidationError("headers." + key, "Value cannot be null"));
                return "null";
            }
            return headerValue;
        }));
        ConversionResult<Auth> convertedAuth = null;
        if (vJsonNode.hasNonNull("auth")) {
            convertedAuth = EsWatcherConverter.createAuth(vJsonNode.getAsDocNode("auth"));
            validationErrors.add("auth", convertedAuth.getSourceValidationErrors());
        }
        Auth auth = convertedAuth != null ? (Auth)convertedAuth.getElement() : null;
        HttpRequestConfig result = new HttpRequestConfig(method, url, path, query, body, null, headers, auth, null);
        return new ConversionResult<HttpRequestConfig>(result, validationErrors);
    }

    static ConversionResult<Auth> createAuth(DocNode jsonNode) {
        if (jsonNode.hasNonNull("basic")) {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode.getAsNode("basic"), validationErrors);
            return new ConversionResult<Auth>(new BasicAuth(vJsonNode.get("username").required().asString(), vJsonNode.get("password").asString()), validationErrors);
        }
        return new ConversionResult<Object>(null, new ValidationErrors().add(new ValidationError(null, "Unknown auth type")));
    }
}

