/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.result;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.watch.common.Ack;
import com.floragunn.signals.watch.result.ErrorInfo;
import com.floragunn.signals.watch.result.Status;
import com.floragunn.signals.watch.result.WatchLog;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ActionLog
implements ToXContentObject {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    private String name;
    private Status status;
    private ErrorInfo error;
    private Date executionStart;
    private Date executionEnd;
    private Map<String, Object> data;
    private WatchExecutionContextData runtimeAttributes;
    private String request;
    private Ack ack;
    private List<ActionLog> elements;

    public ActionLog() {
    }

    public ActionLog(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Status.Code getStatusCode() {
        if (this.status != null) {
            return this.status.getCode();
        }
        return null;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getExecutionDurationMs() {
        if (this.executionStart != null && this.executionEnd != null) {
            return this.executionEnd.getTime() - this.executionStart.getTime();
        }
        return -1L;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getExecutionStart() {
        return this.executionStart;
    }

    public void setExecutionStart(Date executionStart) {
        this.executionStart = executionStart;
    }

    public Date getExecutionEnd() {
        return this.executionEnd;
    }

    public void setExecutionEnd(Date executionEnd) {
        this.executionEnd = executionEnd;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        builder.field("status", (ToXContent)this.status);
        if (this.ack != null) {
            builder.field("ack", (ToXContent)this.ack);
        }
        if (this.error != null) {
            builder.field("error", (ToXContent)this.error);
        }
        builder.field("execution_start", this.executionStart != null ? DATE_FORMATTER.format((TemporalAccessor)this.executionStart.toInstant()) : null);
        builder.field("execution_end", this.executionEnd != null ? DATE_FORMATTER.format((TemporalAccessor)this.executionEnd.toInstant()) : null);
        if (this.data != null && params.paramAsBoolean(WatchLog.ToXContentParams.INCLUDE_DATA.name(), false)) {
            builder.field("data", this.data);
        }
        if (this.runtimeAttributes != null && params.paramAsBoolean(WatchLog.ToXContentParams.INCLUDE_RUNTIME_ATTRIBUTES.name(), false)) {
            builder.field("runtime_attributes", (ToXContent)this.runtimeAttributes);
        }
        if (this.request != null) {
            builder.field("request", this.request);
        }
        if (this.elements != null) {
            builder.field("elements", this.elements);
        }
        builder.endObject();
        return builder;
    }

    public static ActionLog parse(DocNode jsonNode) {
        ActionLog result = new ActionLog(jsonNode.hasNonNull("name") ? jsonNode.getAsString("name") : null);
        if (jsonNode.hasNonNull("status")) {
            result.status = Status.parse(jsonNode.getAsNode("status"));
        }
        if (jsonNode.hasNonNull("ack")) {
            result.ack = Ack.create(jsonNode.getAsNode("ack"));
        }
        if (jsonNode.hasNonNull("execution_start")) {
            result.executionStart = Date.from(Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("execution_start"))));
        }
        if (jsonNode.hasNonNull("execution_end")) {
            result.executionStart = Date.from(Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("execution_end"))));
        }
        if (jsonNode.hasNonNull("request")) {
            result.request = jsonNode.getAsString("request");
        }
        if (jsonNode.hasNonNull("data")) {
            result.data = jsonNode.getAsNode("data").toMap();
        }
        if (jsonNode.hasNonNull("runtime_attributes")) {
            result.runtimeAttributes = WatchExecutionContextData.create(jsonNode.getAsNode("runtime_attributes"));
        }
        if (jsonNode.hasNonNull("elements") && jsonNode.get("elements") instanceof Collection) {
            result.elements = ActionLog.parseList((Collection)jsonNode.get("elements"));
        }
        return result;
    }

    public static List<ActionLog> parseList(Collection<?> arrayNode) {
        ArrayList<ActionLog> result = new ArrayList<ActionLog>(arrayNode.size());
        for (Object actionNode : arrayNode) {
            result.add(ActionLog.parse(DocNode.wrap(actionNode)));
        }
        return result;
    }

    public String toString() {
        return "ActionLog [name=" + this.name + ", status=" + this.status + ", executionStart=" + this.executionStart + ", executionEnd=" + this.executionEnd + ", data=" + this.data + "]";
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public Ack getAck() {
        return this.ack;
    }

    public void setAck(Ack ack) {
        this.ack = ack;
    }

    public List<ActionLog> getElements() {
        return this.elements;
    }

    public void setElements(List<ActionLog> elements) {
        this.elements = elements;
    }

    public WatchExecutionContextData getRuntimeAttributes() {
        return this.runtimeAttributes;
    }

    public void setRuntimeAttributes(WatchExecutionContextData runtimeAttributes) {
        this.runtimeAttributes = runtimeAttributes;
    }
}

