/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.junit.AsyncAssert;
import com.floragunn.searchsupport.junit.LoggingTestWatcher;
import com.floragunn.signals.Signals;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.checks.Check;
import java.time.Duration;
import java.util.Map;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.threadpool.ThreadPool;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class SignalsIndicesTest {
    @Rule
    public LoggingTestWatcher loggingTestWatcher = new LoggingTestWatcher();
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().nodeSettings(new Object[]{"searchguard.diagnosis.action_stack.enabled", true}).embedded().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void indexMappingUpdate() throws Exception {
        ClusterService clusterService = (ClusterService)cluster.getInjectable(ClusterService.class);
        ProtectedConfigIndexService protectedConfigIndexService = new ProtectedConfigIndexService(cluster.getInternalNodeClient(), (ClusterService)cluster.getInjectable(ClusterService.class), (ThreadPool)cluster.getInjectable(ThreadPool.class), new SearchGuardPlugin.ProtectedIndices());
        Client client = cluster.getInternalNodeClient();
        CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(new CreateIndexRequest(".signals_watches").mapping(SignalsIndicesTest.getOldWatchIndexMapping()).settings(Settings.builder().put("index.hidden", true))).actionGet();
        Assert.assertTrue((String)response.toString(), (boolean)response.isAcknowledged());
        Settings.Builder settings = Settings.builder().put("searchguard.enterprise_modules_enabled", false);
        Signals signals = new Signals(settings.build(), new ComponentState(0, "signals", "signals"));
        signals.createComponents(cluster.getInternalNodeClient(), clusterService, (ThreadPool)cluster.getInjectable(ThreadPool.class), null, null, (NodeEnvironment)cluster.getInjectable(NodeEnvironment.class), null, protectedConfigIndexService, null, (FeatureService)cluster.getInjectable(FeatureService.class));
        protectedConfigIndexService.onNodeStart();
        try {
            AsyncAssert.awaitAssert((String)"Index updated", () -> ((IndexMetadata)clusterService.state().getMetadata().indices().get(".signals_watches")).mapping().getSourceAsMap().toString().contains("value_no_map"), (Duration)Duration.ofSeconds(10L));
        }
        finally {
            System.out.println("Updated mapping: " + ((IndexMetadata)clusterService.state().getMetadata().indices().get(".signals_watches")).mapping().getSourceAsMap());
        }
    }

    static Map<String, Object> getOldWatchIndexMapping() {
        NestedValueMap result = new NestedValueMap();
        result.put("dynamic", (Object)true);
        result.put(new NestedValueMap.Path(new String[]{"properties", "checks"}), (Object)Check.getIndexMapping());
        result.put(new NestedValueMap.Path(new String[]{"properties", "_tenant", "type"}), (Object)"text");
        result.put(new NestedValueMap.Path(new String[]{"properties", "_tenant", "analyzer"}), (Object)"keyword");
        result.put(new NestedValueMap.Path(new String[]{"properties", "actions", "dynamic"}), (Object)true);
        result.put(new NestedValueMap.Path(new String[]{"properties", "actions", "properties", "checks"}), (Object)Check.getIndexMapping());
        return result;
    }

    static Map<String, Object> getOldCheckIndexMapping() {
        NestedValueMap result = new NestedValueMap();
        result.put("dynamic", (Object)true);
        NestedValueMap properties = new NestedValueMap();
        properties.put(new NestedValueMap.Path(new String[]{"request", "type"}), (Object)"object");
        properties.put(new NestedValueMap.Path(new String[]{"request", "dynamic"}), (Object)true);
        properties.put(new NestedValueMap.Path(new String[]{"request", "properties", "body", "type"}), (Object)"object");
        properties.put(new NestedValueMap.Path(new String[]{"request", "properties", "body", "dynamic"}), (Object)true);
        properties.put(new NestedValueMap.Path(new String[]{"request", "properties", "body", "enabled"}), (Object)false);
        result.put("properties", (Map)properties);
        return result;
    }
}

