/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.codova.config.temporal.DurationFormat;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchsupport.jobs.config.schedule.DefaultScheduleFactory;
import com.floragunn.searchsupport.jobs.config.schedule.Schedule;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleImpl;
import com.floragunn.searchsupport.jobs.config.schedule.elements.WeeklyTrigger;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.action.handlers.IndexAction;
import com.floragunn.signals.watch.action.handlers.WebhookAction;
import com.floragunn.signals.watch.action.handlers.email.EmailAction;
import com.floragunn.signals.watch.action.handlers.slack.SlackAction;
import com.floragunn.signals.watch.action.handlers.slack.SlackActionConf;
import com.floragunn.signals.watch.action.invokers.AlertAction;
import com.floragunn.signals.watch.action.invokers.ResolveAction;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.checks.Condition;
import com.floragunn.signals.watch.checks.SearchInput;
import com.floragunn.signals.watch.checks.StaticInput;
import com.floragunn.signals.watch.checks.Transform;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.TlsConfig;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.auth.Auth;
import com.floragunn.signals.watch.common.auth.BasicAuth;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.severity.SeverityLevel;
import com.floragunn.signals.watch.severity.SeverityMapping;
import com.google.common.base.Strings;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.action.support.WriteRequest;
import org.mockito.Mockito;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class WatchBuilder {
    private String name;
    private String description;
    private List<Trigger> triggers = new ArrayList<Trigger>();
    List<Check> inputs = new ArrayList<Check>();
    List<AlertAction> actions = new ArrayList<AlertAction>();
    List<ResolveAction> resolveActions = new ArrayList<ResolveAction>();
    SeverityMapping severityMapping;
    DurationExpression throttlePeriod;
    private Boolean logRuntimeData;
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private boolean active = true;

    public WatchBuilder(String name) {
        this.name = name;
    }

    public WatchBuilder cronTrigger(String cronExpression) {
        this.triggers.add(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build());
        return this;
    }

    public WatchBuilder atInterval(String interval) throws ConfigValidationException {
        this.triggers.add(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(DurationFormat.INSTANCE.parse(interval).toMillis())).build());
        return this;
    }

    public WatchBuilder triggerNow() {
        this.triggers.add(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0).withIntervalInMilliseconds(250L)).build());
        return this;
    }

    public WatchBuilder atMsInterval(long msInterval) {
        this.triggers.add(TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(msInterval)).build());
        return this;
    }

    public WatchBuilder weekly(Object ... params) {
        ArrayList<DayOfWeek> on = new ArrayList<DayOfWeek>();
        ArrayList<TimeOfDay> at = new ArrayList<TimeOfDay>();
        TimeZone timeZone = null;
        for (Object param : params) {
            if (param instanceof DayOfWeek) {
                on.add((DayOfWeek)param);
                continue;
            }
            if (param instanceof TimeOfDay) {
                at.add((TimeOfDay)param);
                continue;
            }
            if (param instanceof TimeZone) {
                timeZone = (TimeZone)param;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized argument " + param);
        }
        this.triggers.add((Trigger)new WeeklyTrigger(on, at, timeZone, DefaultScheduleFactory.MisfireStrategy.EXECUTE_NOW));
        return this;
    }

    public WatchBuilder unthrottled() {
        try {
            this.throttlePeriod = DurationExpression.parse((String)"0");
            return this;
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public WatchBuilder throttledFor(String expression) throws ConfigValidationException {
        this.throttlePeriod = DurationExpression.parse((String)expression);
        return this;
    }

    public WatchBuilder throttledFor(DurationExpression expression) throws ConfigValidationException {
        this.throttlePeriod = expression;
        return this;
    }

    public SearchBuilder search(String ... indices) {
        return new SearchBuilder(this, indices);
    }

    public SimpleInputBuilder put(String data) {
        return new SimpleInputBuilder(this, data);
    }

    public WatchBuilder checkCondition(String condition) {
        this.inputs.add((Check)new Condition(null, condition, "painless", null));
        return this;
    }

    public WatchBuilder logRuntimeData(boolean logRuntimeData) {
        this.logRuntimeData = logRuntimeData;
        return this;
    }

    public TransformBuilder transform(String script) {
        return new TransformBuilder(this, script);
    }

    public WatchBuilder inactive() {
        this.active = false;
        return this;
    }

    public SeverityMappingBuilder consider(String expression) {
        return new SeverityMappingBuilder(this, expression);
    }

    public ActionBuilder then() {
        return new ActionBuilder(this, null);
    }

    public ActionBuilder when(SeverityLevel first, SeverityLevel ... rest) {
        return new ActionBuilder(this, new SeverityLevel.Set(first, rest));
    }

    public Watch build() {
        Watch result = new Watch(Watch.createJobKey((String)this.name), (Schedule)new ScheduleImpl(this.triggers), this.inputs, this.severityMapping, this.actions, this.resolveActions);
        result.setDescription(this.description);
        result.setActive(this.active);
        result.setThrottlePeriod(this.throttlePeriod);
        if (this.logRuntimeData != null) {
            result.setLogRuntimeData(this.logRuntimeData.booleanValue());
        }
        return result;
    }

    public static class SearchBuilder {
        private WatchBuilder parent;
        private String[] indices;
        private String body;
        private String query;
        private String aggregation;
        private ObjectNode bodyNode = OBJECT_MAPPER.createObjectNode();

        SearchBuilder(WatchBuilder parent, String ... indices) {
            this.parent = parent;
            this.indices = indices;
        }

        public SearchBuilder attr(String key, String value) {
            this.bodyNode.put(key, value);
            return this;
        }

        public SearchBuilder attr(String key, int value) {
            this.bodyNode.put(key, value);
            return this;
        }

        public SearchBuilder size(int size) {
            return this.attr("size", size);
        }

        public SearchBuilder query(String query) {
            this.query = query;
            return this;
        }

        public SearchBuilder aggregation(DocNode aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "Aggregation doc node is required").toJsonString();
            return this;
        }

        public WatchBuilder as(String name) throws JsonProcessingException, IOException {
            if (this.body == null) {
                this.body = this.buildBody();
            }
            SearchInput searchInput = new SearchInput(name, name, Arrays.asList(this.indices), this.body);
            this.parent.inputs.add((Check)searchInput);
            return this.parent;
        }

        private String buildBody() throws JsonProcessingException, IOException {
            if (!Strings.isNullOrEmpty((String)this.query)) {
                JsonNode jsonNode = OBJECT_MAPPER.readTree(this.query);
                this.bodyNode.set("query", jsonNode);
            }
            if (!Strings.isNullOrEmpty((String)this.aggregation)) {
                this.bodyNode.set("aggs", OBJECT_MAPPER.readTree(this.aggregation));
            }
            return OBJECT_MAPPER.writeValueAsString((Object)this.bodyNode);
        }
    }

    public static class SimpleInputBuilder {
        private WatchBuilder parent;
        private String data;
        private String name;

        SimpleInputBuilder(WatchBuilder parent, String data) {
            this.parent = parent;
            this.data = data;
        }

        public SimpleInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WatchBuilder as(String name) throws JsonProcessingException, IOException {
            Map map = (Map)OBJECT_MAPPER.convertValue((Object)OBJECT_MAPPER.readTree(this.data), Map.class);
            StaticInput simpleInput = new StaticInput(this.name != null ? this.name : name, name, map);
            this.parent.inputs.add((Check)simpleInput);
            return this.parent;
        }
    }

    public static class TransformBuilder {
        private WatchBuilder parent;
        private String script;

        TransformBuilder(WatchBuilder parent, String script) {
            this.parent = parent;
            this.script = script;
        }

        public WatchBuilder as(String name) throws JsonProcessingException, IOException {
            Transform transform = new Transform(name, name, this.script, "painless", Collections.emptyMap());
            this.parent.inputs.add((Check)transform);
            return this.parent;
        }
    }

    public static class SeverityMappingBuilder {
        protected final WatchBuilder parent;
        protected final String expression;
        protected final List<SeverityMapping.Element> mapping = new ArrayList<SeverityMapping.Element>();

        SeverityMappingBuilder(WatchBuilder parent, String expression) {
            this.parent = parent;
            this.expression = expression;
        }

        public SeverityMappingElementBuilder greaterOrEqual(double threshold) {
            return new SeverityMappingElementBuilder(this, threshold);
        }

        public ActionBuilder then() {
            this.parent.severityMapping = new SeverityMapping(this.expression, null, null, this.mapping);
            return new ActionBuilder(this.parent, null);
        }

        public ActionBuilder when(SeverityLevel first, SeverityLevel ... rest) {
            this.parent.severityMapping = new SeverityMapping(this.expression, null, null, this.mapping);
            return new ActionBuilder(this.parent, new SeverityLevel.Set(first, rest));
        }
    }

    public static class ActionBuilder
    extends BaseActionBuilder {
        private SeverityLevel.Set severityLevelSet;

        ActionBuilder(WatchBuilder parent, SeverityLevel.Set severityLevelSet) {
            super(parent);
            this.severityLevelSet = severityLevelSet;
        }

        @Override
        protected void addActionHandler(ActionHandler actionHandler, AbstractActionBuilder abstractActionBuilder) {
            if (actionHandler != null) {
                this.parent.actions.add(new AlertAction(abstractActionBuilder.name, actionHandler, abstractActionBuilder.throttlePeriod, this.severityLevelSet, null, null, null, abstractActionBuilder.ackEnabled));
            }
        }
    }

    public static class SlackActionBuilder
    extends AbstractActionBuilder {
        private final SlackActionConf slackActionConf;

        SlackActionBuilder(BaseActionBuilder parent, SlackActionConf slackActionConf) {
            super(parent);
            this.slackActionConf = slackActionConf;
        }

        @Override
        protected ActionHandler finish() {
            return new SlackAction(this.slackActionConf);
        }
    }

    public static class GenericActionBuilder
    extends AbstractActionBuilder {
        private final ActionHandler actionHandler;

        GenericActionBuilder(BaseActionBuilder parent, ActionHandler actionHandler) {
            super(parent);
            this.actionHandler = actionHandler;
        }

        @Override
        protected ActionHandler finish() {
            return this.actionHandler;
        }
    }

    public static class EmailActionBuilder
    extends AbstractActionBuilder {
        private String subject;
        private String from;
        private String body;
        private String htmlBody;
        private String account;
        private List<String> to = new ArrayList<String>();
        private Map<String, EmailAction.Attachment> attachments = new LinkedHashMap<String, EmailAction.Attachment>();

        EmailActionBuilder(BaseActionBuilder parent, String subject) {
            super(parent);
            this.subject = subject;
        }

        public EmailActionBuilder to(String ... to) {
            this.to.addAll(Arrays.asList(to));
            return this;
        }

        public EmailActionBuilder from(String from) {
            this.from = from;
            return this;
        }

        public EmailActionBuilder body(String body) {
            this.body = body;
            return this;
        }

        public EmailActionBuilder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public EmailActionBuilder account(String account) {
            this.account = account;
            return this;
        }

        public EmailActionBuilder attach(String name, EmailAction.Attachment attachment) {
            this.attachments.put(name, attachment);
            return this;
        }

        @Override
        protected ActionHandler finish() {
            EmailAction result = new EmailAction();
            result.setAccount(this.account);
            result.setSubject(this.subject);
            result.setBody(this.body);
            result.setHtmlBody(this.htmlBody);
            result.setFrom(this.from);
            result.setTo(this.to);
            result.setAttachments(this.attachments);
            return result;
        }
    }

    public static class WebhookActionBuilder
    extends AbstractActionBuilder {
        private final HttpRequestConfig.Method method;
        private final URI uri;
        private Auth auth;
        private String body;
        private JsonPath jsonBodyFrom;
        private Map<String, String> headers = new HashMap<String, String>();
        private String proxy;
        private TrustManagerRegistry trustManagerRegistry = (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class);
        private HttpProxyHostRegistry httpProxyHostRegistry = (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class);
        private String truststoreId;

        WebhookActionBuilder(BaseActionBuilder parent, HttpRequestConfig.Method method, String uri) throws URISyntaxException {
            super(parent);
            this.method = method;
            this.uri = new URI(uri);
        }

        public WebhookActionBuilder basicAuth(String user, String password) {
            this.auth = new BasicAuth(user, password);
            return this;
        }

        public WebhookActionBuilder proxy(String proxy) {
            this.proxy = proxy;
            return this;
        }

        public WebhookActionBuilder body(String body) {
            if (this.jsonBodyFrom != null) {
                throw new IllegalStateException("body and jsonBodyFrom cannot be populated at the same time");
            }
            this.body = body;
            return this;
        }

        public WebhookActionBuilder jsonBodyFrom(String jsonBodyFrom) {
            return this.jsonBodyFrom(JsonPath.compile((String)jsonBodyFrom, (Predicate[])new Predicate[0]));
        }

        public WebhookActionBuilder jsonBodyFrom(JsonPath jsonBodyFrom) {
            if (this.body != null) {
                throw new IllegalStateException("body and jsonBodyFrom cannot be populated at the same time");
            }
            this.jsonBodyFrom = jsonBodyFrom;
            return this;
        }

        public WebhookActionBuilder trustManagerRegistry(TrustManagerRegistry trustManagerRegistry) {
            this.trustManagerRegistry = Objects.requireNonNull(trustManagerRegistry, "Truststore pem provider is required");
            return this;
        }

        public WebhookActionBuilder truststoreId(String truststoreId) {
            this.truststoreId = truststoreId;
            return this;
        }

        @Override
        protected ActionHandler finish() {
            boolean tlsIsRequired = !Strings.isNullOrEmpty((String)this.truststoreId);
            TlsConfig tlsConfig = null;
            if (tlsIsRequired) {
                tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
                tlsConfig.setTruststoreId(this.truststoreId);
            }
            HttpProxyConfig proxyConfig = null;
            if (!Strings.isNullOrEmpty((String)this.proxy)) {
                try {
                    proxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)this.proxy), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.LENIENT);
                }
                catch (ConfigValidationException e) {
                    throw new RuntimeException(e);
                }
            }
            return new WebhookAction(new HttpRequestConfig(this.method, this.uri, null, null, this.body, this.jsonBodyFrom, this.headers, this.auth, null), new HttpClientConfig(null, null, tlsConfig, proxyConfig));
        }
    }

    public static class IndexActionBuilder
    extends AbstractActionBuilder {
        private final String indexName;
        private WriteRequest.RefreshPolicy refreshPolicy = null;
        private String id;

        IndexActionBuilder(BaseActionBuilder parent, String indexName) {
            super(parent);
            this.indexName = indexName;
        }

        public IndexActionBuilder refreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }

        public IndexActionBuilder docId(String id) {
            this.id = id;
            return this;
        }

        @Override
        protected ActionHandler finish() {
            IndexAction action = new IndexAction(this.indexName, this.refreshPolicy);
            if (this.id != null) {
                action.setDocId(this.id);
            }
            return action;
        }
    }

    public static class LogActionBuilder
    extends AbstractActionBuilder {
        private final String template;

        LogActionBuilder(BaseActionBuilder parent, String template) {
            super(parent);
            this.template = template;
        }

        @Override
        protected ActionHandler finish() {
            return null;
        }
    }

    public static abstract class AbstractActionBuilder {
        protected final BaseActionBuilder parent;
        protected String name;
        protected DurationExpression throttlePeriod;
        protected boolean ackEnabled = true;

        AbstractActionBuilder(BaseActionBuilder parent) {
            this.parent = parent;
        }

        public AbstractActionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AbstractActionBuilder throttledFor(String duration) throws ConfigValidationException {
            this.throttlePeriod = DurationExpression.parse((String)duration);
            return this;
        }

        public AbstractActionBuilder throttledFor(DurationExpression duration) throws ParseException {
            this.throttlePeriod = duration;
            return this;
        }

        public AbstractActionBuilder ackEnabled(boolean ackEnabled) {
            this.ackEnabled = ackEnabled;
            return this;
        }

        public BaseActionBuilder and() {
            ActionHandler actionHandler = this.finish();
            if (actionHandler != null) {
                this.parent.addActionHandler(actionHandler, this);
            }
            return this.parent;
        }

        public Watch build() {
            ActionHandler actionHandler = this.finish();
            if (actionHandler != null) {
                this.parent.addActionHandler(actionHandler, this);
            }
            return this.parent.parent.build();
        }

        protected abstract ActionHandler finish();
    }

    public static class ResolveActionBuilder
    extends BaseActionBuilder {
        private SeverityLevel.Set severityLevelSet;

        ResolveActionBuilder(WatchBuilder parent, SeverityLevel severityLevel1, SeverityLevel ... severityLevel2) {
            super(parent);
            this.severityLevelSet = new SeverityLevel.Set(severityLevel1, severityLevel2);
        }

        @Override
        protected void addActionHandler(ActionHandler actionHandler, AbstractActionBuilder abstractActionBuilder) {
            if (actionHandler != null) {
                this.parent.resolveActions.add(new ResolveAction(abstractActionBuilder.name, actionHandler, this.severityLevelSet, Collections.emptyList()));
            }
        }
    }

    public static abstract class BaseActionBuilder {
        protected final WatchBuilder parent;

        BaseActionBuilder(WatchBuilder parent) {
            this.parent = parent;
        }

        public LogActionBuilder log(String template) {
            return new LogActionBuilder(this, template);
        }

        public IndexActionBuilder index(String indexName) {
            return new IndexActionBuilder(this, indexName);
        }

        public WebhookActionBuilder postWebhook(String uri) throws URISyntaxException {
            return new WebhookActionBuilder(this, HttpRequestConfig.Method.POST, uri);
        }

        public EmailActionBuilder email(String subject) {
            return new EmailActionBuilder(this, subject);
        }

        public SlackActionBuilder slack(SlackActionConf slackActionConf) {
            return new SlackActionBuilder(this, slackActionConf);
        }

        public ActionBuilder when(SeverityLevel first, SeverityLevel ... rest) {
            return new ActionBuilder(this.parent, new SeverityLevel.Set(first, rest));
        }

        public ResolveActionBuilder whenResolved(SeverityLevel severityLevel1, SeverityLevel ... severityLevel2) {
            return new ResolveActionBuilder(this.parent, severityLevel1, severityLevel2);
        }

        public GenericActionBuilder act(ActionHandler actionHandler) {
            return new GenericActionBuilder(this, actionHandler);
        }

        public GenericActionBuilder act(String actionType, Object ... properties) throws ConfigValidationException {
            NestedValueMap propertyMap = new NestedValueMap();
            for (int i = 0; i < properties.length; i += 2) {
                propertyMap.put(NestedValueMap.Path.parse((String)String.valueOf(properties[i])), properties[i + 1]);
            }
            WatchInitializationService watchInitService = new WatchInitializationService(null, null, (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class), null, ValidationLevel.STRICT);
            ActionHandler actionHandler = ActionHandler.factoryRegistry.get(actionType).create(watchInitService, DocNode.parse((Format)Format.JSON).from(propertyMap.toJsonString()));
            return new GenericActionBuilder(this, actionHandler);
        }

        protected abstract void addActionHandler(ActionHandler var1, AbstractActionBuilder var2);
    }

    public static class SeverityMappingElementBuilder {
        protected final SeverityMappingBuilder parent;
        protected final double threshold;

        SeverityMappingElementBuilder(SeverityMappingBuilder parent, double threshold) {
            this.parent = parent;
            this.threshold = threshold;
        }

        public SeverityMappingBuilder as(SeverityLevel severityLevel) {
            this.parent.mapping.add(new SeverityMapping.Element(new BigDecimal(String.valueOf(this.threshold)), severityLevel));
            return this.parent;
        }
    }
}

