/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.execution;

import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.CheckExecutionException;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.GotoCheckSelector;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.execution.WatchExecutionException;
import com.floragunn.signals.execution.WatchOperationExecutionException;
import com.floragunn.signals.script.types.SignalsObjectFunctionScript;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.action.invokers.ActionInvoker;
import com.floragunn.signals.watch.action.invokers.AlertAction;
import com.floragunn.signals.watch.action.invokers.ResolveAction;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.common.Ack;
import com.floragunn.signals.watch.common.HttpEndpointWhitelist;
import com.floragunn.signals.watch.result.ActionLog;
import com.floragunn.signals.watch.result.Status;
import com.floragunn.signals.watch.result.WatchLog;
import com.floragunn.signals.watch.result.WatchLogWriter;
import com.floragunn.signals.watch.severity.SeverityLevel;
import com.floragunn.signals.watch.severity.SeverityMapping;
import com.floragunn.signals.watch.state.ActionState;
import com.floragunn.signals.watch.state.NopActionState;
import com.floragunn.signals.watch.state.WatchState;
import com.floragunn.signals.watch.state.WatchStateWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class WatchRunner
implements Job {
    private static final Logger log = LogManager.getLogger(WatchRunner.class);
    private final Watch watch;
    private final WatchExecutionContext ctx;
    private final WatchExecutionContextData contextData;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final FeatureService featureService;
    private final WatchLogWriter watchLogWriter;
    private final WatchStateWriter<?> watchStateWriter;
    private final WatchState watchState;
    private final SignalsSettings signalsSettings;
    private final String nodeName;
    private final WatchLog watchLog = new WatchLog();
    private final SimulationMode simulationMode;
    private final GotoCheckSelector checkSelector;
    private final DiagnosticContext diagnosticContext;
    private SeverityLevel lastSeverityLevel;
    private SeverityLevel newSeverityLevel;
    private int attemptedActions = 0;
    private int executedActions = 0;
    private int throttledActions = 0;
    private int failedActions = 0;
    private int ackedActions = 0;
    private int attemptedResolveActions = 0;
    private int executedResolveActions = 0;
    private int failedResolveActions = 0;

    public WatchRunner(Watch watch, Client client, AccountRegistry accountRegistry, ScriptService scriptService, WatchLogWriter watchLogWriter, WatchStateWriter<?> watchStateWriter, DiagnosticContext diagnosticContext, WatchState watchState, ExecutionEnvironment executionEnvironment, SimulationMode simulationMode, NamedXContentRegistry xContentRegistry, SignalsSettings signalsSettings, String nodeName, GotoCheckSelector checkSelector, NestedValueMap input, TrustManagerRegistry trustManagerRegistry, ClusterService clusterService, FeatureService featureService) {
        this.watch = watch;
        this.client = client;
        this.clusterService = clusterService;
        this.featureService = featureService;
        this.scriptService = scriptService;
        this.watchLogWriter = watchLogWriter;
        this.watchStateWriter = watchStateWriter;
        this.watchState = watchState;
        this.diagnosticContext = diagnosticContext;
        this.lastSeverityLevel = watchState != null ? watchState.getLastSeverityLevel() : null;
        this.contextData = new WatchExecutionContextData(new WatchExecutionContextData.WatchInfo(watch.getId(), watch.getTenant()));
        this.ctx = new WatchExecutionContext(client, scriptService, xContentRegistry, accountRegistry, executionEnvironment, ActionInvocationType.ALERT, this.contextData, watchState != null ? watchState.getLastExecutionContextData() : null, simulationMode, new HttpEndpointWhitelist(signalsSettings.getDynamicSettings().getAllowedHttpEndpoints()), signalsSettings.getDynamicSettings().getHttpProxyConfig(), signalsSettings.getDynamicSettings().getFrontendBaseUrl(), null, trustManagerRegistry, clusterService, featureService);
        this.watchLog.setWatchId(watch.getId());
        this.watchLog.setWatchVersion(watch.getVersion());
        this.signalsSettings = signalsSettings;
        this.nodeName = nodeName;
        this.simulationMode = simulationMode;
        this.checkSelector = checkSelector;
        if (input != null) {
            this.contextData.getData().putAll(input);
        }
    }

    public Watch getWatch() {
        return this.watch;
    }

    public WatchExecutionContext getCtx() {
        return this.ctx;
    }

    public Client getClient() {
        return this.client;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public FeatureService getFeatureService() {
        return this.featureService;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.contextData.setTriggerInfo(new WatchExecutionContextData.TriggerInfo(context.getFireTime(), context.getScheduledFireTime(), context.getPreviousFireTime(), context.getNextFireTime()));
            this.execute();
        }
        catch (WatchExecutionException e) {
            log.info("Error while executing " + this.watch, (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public WatchLog execute() throws WatchExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean executeChecks() throws WatchExecutionException {
        for (Check check : this.watch.getChecks()) {
            try {
                if (this.checkSelector != null && !this.checkSelector.isSelected(check)) {
                    log.info("Skipping check " + check + " because of check selector " + this.checkSelector);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Before running " + check);
                }
                if (!check.execute(this.ctx)) {
                    this.afterNegativeTriageForAllActions();
                    this.watchLog.setStatus(new Status(Status.Code.NO_ACTION, "No action needed due to check " + check.getName()));
                    return false;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("After running " + check + "\n" + this.contextData.getData());
            }
            catch (Exception e) {
                this.watchLog.setStatus(new Status(Status.Code.EXECUTION_FAILED, "Error while executing " + check + ": " + e.getMessage()));
                if (e instanceof WatchOperationExecutionException) {
                    this.watchLog.setError(((WatchOperationExecutionException)e).toErrorInfo());
                } else {
                    this.watchLog.setError(new WatchOperationExecutionException(e).toErrorInfo());
                }
                throw new WatchExecutionException("Error while executing " + check, e, this.watchLog);
            }
        }
        return true;
    }

    private void afterNegativeTriageForAllActions() {
        for (ActionInvoker actionInvoker : this.watch.getActions()) {
            ActionState actionState = this.getActionState(actionInvoker);
            actionState.afterNegativeTriage();
        }
    }

    private boolean executeSeverityMapping() throws WatchExecutionException {
        SeverityMapping severityMapping = this.watch.getSeverityMapping();
        if (severityMapping == null) {
            return true;
        }
        try {
            SeverityMapping.EvaluationResult severityLevelEvaluationResult = severityMapping.execute(this.ctx);
            if (log.isDebugEnabled()) {
                log.debug("Determined severity level: " + severityLevelEvaluationResult);
            }
            this.contextData.setSeverity(severityLevelEvaluationResult);
            this.newSeverityLevel = severityLevelEvaluationResult.getLevel();
            if (severityLevelEvaluationResult.getLevel() == SeverityLevel.NONE) {
                this.executeResolveActions();
                this.afterNegativeTriageForAllActions();
                this.watchLog.setStatus(new Status(Status.Code.NO_ACTION, SeverityLevel.NONE, "No action needed because severity value " + severityLevelEvaluationResult.getThreshold() + " is under threshold " + severityMapping.getFirstThreshold()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.watchLog.setStatus(new Status(Status.Code.EXECUTION_FAILED, "Error while executing severity mapping: " + e.getMessage()));
            if (e instanceof WatchOperationExecutionException) {
                this.watchLog.setError(((WatchOperationExecutionException)e).toErrorInfo());
            } else {
                this.watchLog.setError(new WatchOperationExecutionException(e).toErrorInfo());
            }
            throw new WatchExecutionException("Error while executing severity mapping", e, this.watchLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActions() {
        if (this.watch.getActions().isEmpty()) {
            this.watchLog.setStatus(new Status(Status.Code.NO_ACTION, "No actions are configured"));
            return;
        }
        for (AlertAction action : this.watch.getActions()) {
            ActionLog actionLog = new ActionLog(action.getName() != null ? action.getName() : action.toString());
            this.watchLog.getActions().add(actionLog);
            ActionState actionState = this.getActionState(action);
            try {
                ActionState.BasicState basicActionState;
                block34: {
                    block35: {
                        block36: {
                            if (log.isDebugEnabled()) {
                                log.debug("Before running " + action);
                            }
                            actionLog.setExecutionStart(new Date());
                            basicActionState = actionState.beforeExecution(this.getThrottlePeriod(action));
                            if (action.getSeverityLevels() == null || action.getSeverityLevels().size() == 0) break block34;
                            if (this.newSeverityLevel == null) {
                                actionLog.setStatus(new Status(Status.Code.ACTION_FAILED, "Action " + action.getName() + " is configured with severity levels, while watch does not define severity levels"));
                                ++this.attemptedActions;
                                ++this.failedActions;
                                continue;
                            }
                            if (!action.getSeverityLevels().isGained(this.lastSeverityLevel, this.newSeverityLevel)) break block35;
                            if (basicActionState != ActionState.BasicState.THROTTLED) break block36;
                            basicActionState = ActionState.BasicState.EXECUTABLE;
                            if (log.isDebugEnabled()) {
                                log.debug("Unthrottling and executing " + action.getName() + " because configured severity level has been gained: " + this.lastSeverityLevel + " < " + action.getSeverityLevels() + " <= " + this.newSeverityLevel);
                            }
                            break block34;
                        }
                        if (!log.isDebugEnabled()) break block34;
                        log.debug("Executing " + action.getName() + " because configured severity level has been gained: " + this.lastSeverityLevel + " < " + action.getSeverityLevels() + " <= " + this.newSeverityLevel);
                        break block34;
                    }
                    if (action.getSeverityLevels().getLowest().isHigherThan(this.newSeverityLevel)) {
                        if (log.isDebugEnabled()) {
                            log.debug(this.newSeverityLevel + " is lower than lowest level of " + action);
                        }
                        actionState.afterNegativeTriage();
                        actionLog.setStatus(new Status(Status.Code.NO_ACTION, "No action because current severity is lower than severity configured for action: " + this.newSeverityLevel));
                        continue;
                    }
                    if (!action.getSeverityLevels().contains(this.newSeverityLevel)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Not executing " + action + " because the configured severity levels don't contain " + this.newSeverityLevel);
                        }
                        actionLog.setStatus(new Status(Status.Code.NO_ACTION, "No action because action is not configured for severity " + this.newSeverityLevel));
                        continue;
                    }
                }
                if (basicActionState == ActionState.BasicState.THROTTLED) {
                    actionLog.setStatus(new Status(Status.Code.ACTION_THROTTLED, null));
                    ++this.throttledActions;
                    continue;
                }
                ++this.attemptedActions;
                if (action.getForeach() == null) {
                    WatchExecutionContext ctx = this.prepareInputForAction(this.ctx, action, actionLog);
                    if (ctx == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Not executing " + action + " because the checks did not found the action to be eligible for execution");
                        }
                        actionState.afterNegativeTriage();
                        actionLog.setStatus(new Status(Status.Code.NO_ACTION, "No action due to check conditions"));
                        continue;
                    }
                    Ack acked = actionState.afterPositiveTriage();
                    if (acked != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Not executing " + action + " because it was already acked: " + acked);
                        }
                        actionLog.setStatus(new Status(Status.Code.ACKED, "Already acked"));
                        actionLog.setAck(acked);
                        ++this.ackedActions;
                        continue;
                    }
                    if (this.simulationMode == SimulationMode.FOR_REAL || this.simulationMode == SimulationMode.SIMULATE_ACTIONS) {
                        ActionExecutionResult result = action.execute(ctx);
                        if (this.simulationMode == SimulationMode.FOR_REAL) {
                            actionLog.setStatus(new Status(Status.Code.ACTION_EXECUTED, null));
                        } else {
                            actionLog.setRequest(result.getRequest());
                            actionLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action was triggered in simulation mode"));
                        }
                    } else {
                        actionLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action would have been triggered but was skipped."));
                    }
                    ++this.executedActions;
                    actionState.afterSuccessfulExecution();
                    continue;
                }
                this.executeForEachAction(action, actionState, actionLog);
            }
            catch (CheckExecutionException e) {
                log.warn("Error while executing " + action + " of " + this.watch, (Throwable)e);
                actionLog.setStatus(new Status(Status.Code.ACTION_FAILED, "Check " + e.getCheckId() + " failed: " + e.getMessage()));
                actionLog.setError(e.toErrorInfo());
                ++this.failedActions;
            }
            catch (Exception e) {
                log.warn("Error while executing " + action + " of " + this.watch, (Throwable)e);
                actionLog.setStatus(new Status(Status.Code.ACTION_FAILED, e.getMessage() != null ? e.getMessage() : e.toString()));
                if (e instanceof WatchOperationExecutionException) {
                    actionLog.setError(((WatchOperationExecutionException)e).toErrorInfo());
                } else {
                    actionLog.setError(new WatchOperationExecutionException(e).toErrorInfo());
                }
                actionState.setLastError(Instant.now());
                ++this.failedActions;
            }
            finally {
                actionLog.setExecutionEnd(new Date());
                actionState.setLastStatus(actionLog.getStatus());
                if (!log.isDebugEnabled()) continue;
                log.debug("Finished " + action + ": " + actionLog.getStatus());
            }
        }
    }

    private void executeForEachAction(AlertAction action, ActionState actionState, ActionLog actionLog) {
        SignalsObjectFunctionScript s = action.getForeach().getScriptFactory().newInstance(Collections.emptyMap(), this.ctx);
        Set<Object> collection = s.execute();
        if (!(collection instanceof Iterable)) {
            collection = Collections.singleton(collection);
        }
        ArrayList<ActionLog> elementLogs = new ArrayList<ActionLog>(collection instanceof Collection ? Math.max(((Collection)collection).size(), action.getForeachLimit()) : 100);
        actionLog.setElements(elementLogs);
        int totalElements = 0;
        int executedActions = 0;
        int errors = 0;
        for (Object elem : (Iterable)collection) {
            if (totalElements >= action.getForeachLimit()) break;
            ActionLog elementLog = new ActionLog();
            elementLogs.add(elementLog);
            ++totalElements;
            WatchExecutionContext ctx = this.ctx.clone();
            try {
                ctx.getContextData().setItem(NestedValueMap.copy(elem));
                ctx = this.prepareInputForAction(ctx, action, actionLog);
                if (ctx == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Not executing " + action + " because the checks did not found the action to be eligible for execution");
                    }
                    elementLog.setStatus(new Status(Status.Code.NO_ACTION, "No action due to check conditions"));
                    continue;
                }
                if (this.simulationMode == SimulationMode.FOR_REAL || this.simulationMode == SimulationMode.SIMULATE_ACTIONS) {
                    ActionExecutionResult result = action.execute(ctx);
                    if (this.simulationMode == SimulationMode.FOR_REAL) {
                        elementLog.setStatus(new Status(Status.Code.ACTION_EXECUTED, null));
                    } else {
                        elementLog.setRequest(result.getRequest());
                        elementLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action was triggered in simulation mode"));
                    }
                } else {
                    elementLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action would have been triggered but was skipped."));
                }
                ++executedActions;
            }
            catch (CheckExecutionException e) {
                log.warn("Error while executing " + action + " of " + this.watch, (Throwable)e);
                elementLog.setStatus(new Status(Status.Code.ACTION_FAILED, "Check " + e.getCheckId() + " failed: " + e.getMessage()));
                elementLog.setError(e.toErrorInfo());
                ++errors;
            }
            catch (ActionExecutionException e) {
                log.warn("Error while executing " + action + " of " + this.watch, (Throwable)e);
                elementLog.setStatus(new Status(Status.Code.ACTION_FAILED, e.getMessage() != null ? e.getMessage() : e.toString()));
                if (e instanceof WatchOperationExecutionException) {
                    elementLog.setError(e.toErrorInfo());
                } else {
                    elementLog.setError(new WatchOperationExecutionException(e).toErrorInfo());
                }
                ++errors;
            }
        }
        if (errors > 0) {
            actionLog.setStatus(new Status(Status.Code.ACTION_FAILED, "Action failed for " + errors + " of " + totalElements + " elements"));
            actionState.setLastError(Instant.now());
            ++this.failedActions;
        } else if (executedActions == 0) {
            actionState.afterNegativeTriage();
            actionLog.setStatus(new Status(Status.Code.NO_ACTION, "No action due to check conditions"));
        } else if (executedActions == totalElements) {
            if (this.simulationMode == SimulationMode.FOR_REAL || this.simulationMode == SimulationMode.SIMULATE_ACTIONS) {
                actionLog.setStatus(new Status(Status.Code.ACTION_EXECUTED, "Action executed for all " + totalElements + " elements"));
            } else {
                actionLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action would have been triggered."));
            }
            ++this.executedActions;
            actionState.afterSuccessfulExecution();
        } else {
            if (this.simulationMode == SimulationMode.FOR_REAL || this.simulationMode == SimulationMode.SIMULATE_ACTIONS) {
                actionLog.setStatus(new Status(Status.Code.ACTION_EXECUTED, "Action executed for " + executedActions + " of " + totalElements + " elements"));
            } else {
                actionLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action would have been triggered."));
            }
            ++this.executedActions;
            actionState.afterSuccessfulExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeResolveActions() {
        WatchExecutionContext ctx = this.ctx.with(ActionInvocationType.RESOLVE);
        for (ResolveAction action : this.watch.getResolveActions()) {
            ActionLog actionLog = new ActionLog(action.getName() != null ? action.getName() : action.toString());
            this.watchLog.getResolveActions().add(actionLog);
            try {
                if (!action.getResolvesSeverityLevels().isLost(this.lastSeverityLevel, this.newSeverityLevel)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Not running " + action + " because " + action.getResolvesSeverityLevels() + " is not in between " + this.lastSeverityLevel + " and " + this.newSeverityLevel);
                    }
                    actionLog.setStatus(new Status(Status.Code.NO_ACTION, null));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Running " + action);
                }
                ++this.attemptedResolveActions;
                actionLog.setExecutionStart(new Date());
                WatchExecutionContext actionCtx = this.prepareInputForAction(ctx, action, actionLog);
                if (actionCtx == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Not executing " + action + " because the checks did not found the action to be eligible for execution");
                    }
                    actionLog.setStatus(new Status(Status.Code.NO_ACTION, "No action due to check conditions"));
                    continue;
                }
                if (this.simulationMode == SimulationMode.FOR_REAL || this.simulationMode == SimulationMode.SIMULATE_ACTIONS) {
                    action.execute(actionCtx);
                    actionLog.setStatus(new Status(Status.Code.ACTION_EXECUTED, null));
                } else {
                    actionLog.setStatus(new Status(Status.Code.SIMULATED_ACTION_EXECUTED, "Simulate mode: Action would have been triggered."));
                }
                ++this.executedResolveActions;
            }
            catch (Exception e) {
                log.warn("Error while executing " + action + " of " + this.watch, (Throwable)e);
                actionLog.setStatus(new Status(Status.Code.ACTION_FAILED, e.getMessage() != null ? e.getMessage() : e.toString()));
                if (e instanceof WatchOperationExecutionException) {
                    actionLog.setError(((WatchOperationExecutionException)e).toErrorInfo());
                } else {
                    actionLog.setError(new WatchOperationExecutionException(e).toErrorInfo());
                }
                ++this.failedResolveActions;
            }
            finally {
                actionLog.setExecutionEnd(new Date());
                if (!log.isDebugEnabled()) continue;
                log.debug("Finished " + action + ": " + actionLog.getStatus());
            }
        }
    }

    private void setWatchLogStatus() {
        String statusMessage = this.getStatusMessage();
        if (this.executedActions + this.executedResolveActions > 0) {
            this.watchLog.setStatus(new Status(Status.Code.ACTION_EXECUTED, this.newSeverityLevel, statusMessage));
        } else if (this.failedActions + this.executedResolveActions > 0) {
            this.watchLog.setStatus(new Status(Status.Code.ACTION_FAILED, this.newSeverityLevel, statusMessage));
        } else if (this.throttledActions > 0) {
            this.watchLog.setStatus(new Status(Status.Code.ACTION_THROTTLED, this.newSeverityLevel, statusMessage));
        } else if (this.ackedActions > 0) {
            this.watchLog.setStatus(new Status(Status.Code.ACKED, this.newSeverityLevel, statusMessage));
        } else {
            this.watchLog.setStatus(new Status(Status.Code.NO_ACTION, this.newSeverityLevel, statusMessage));
        }
    }

    private DurationExpression getThrottlePeriod(AlertAction action) {
        DurationExpression lowerBound;
        DurationExpression result = action.getThrottlePeriod();
        if (result == null) {
            result = this.watch.getThrottlePeriod();
        }
        if ((lowerBound = this.signalsSettings.getThrottlePeriodLowerBound()) != null && (result == null || result.getActualDuration(0).compareTo(lowerBound.getActualDuration(0)) < 0)) {
            result = lowerBound;
        }
        if (result == null) {
            return this.signalsSettings.getDefaultThrottlePeriod();
        }
        return result;
    }

    private String getStatusMessage() {
        if (this.failedActions == 0 && this.throttledActions == 0 && this.executedActions == 0 && this.ackedActions == 0 && this.executedResolveActions == 0 && this.failedResolveActions == 0) {
            return "No action needed to be executed due to their conditions";
        }
        if (this.failedActions == 0 && this.throttledActions == 0 && this.ackedActions == 0 && this.failedResolveActions == 0) {
            return "All actions have been executed";
        }
        if (this.failedActions + this.failedResolveActions != 0 && this.failedActions == this.attemptedActions && this.failedResolveActions == this.attemptedResolveActions) {
            return "All actions failed";
        }
        if (this.throttledActions == this.watch.getActions().size() && this.attemptedResolveActions == 0) {
            return "All actions have been throttled";
        }
        if (this.ackedActions == this.attemptedActions && this.attemptedResolveActions == 0) {
            return "All actions have been acknowledged before";
        }
        StringBuilder result = new StringBuilder();
        if (this.executedActions > 0) {
            result.append(this.executedActions + " actions have been executed");
        }
        if (this.throttledActions > 0) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append(this.throttledActions + " actions were not considered because they are throttled");
        }
        if (this.ackedActions > 0) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append(this.ackedActions + " actions were not executed because they have been acknowledged before");
        }
        if (this.failedActions > 0) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append(this.failedActions + " actions failed");
        }
        if (this.executedResolveActions > 0) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append(this.executedResolveActions + " resolve actions have been executed");
        }
        if (this.failedResolveActions > 0) {
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append(this.failedResolveActions + " resolve actions failed");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WatchExecutionContext prepareInputForAction(WatchExecutionContext ctx, ActionInvoker action, ActionLog actionLog) throws CheckExecutionException {
        if (action.getChecks().isEmpty()) {
            return ctx.with(ctx.getContextData(), action);
        }
        WatchExecutionContextData actionContextData = ctx.getContextData().clone();
        try {
            ctx = ctx.with(actionContextData, action);
            for (Check input : action.getChecks()) {
                if (input.execute(ctx)) continue;
                WatchExecutionContext watchExecutionContext = null;
                return watchExecutionContext;
            }
            WatchExecutionContext watchExecutionContext = ctx;
            return watchExecutionContext;
        }
        finally {
            if ((this.watch.isLogRuntimeData() || ctx.getExecutionEnvironment() == ExecutionEnvironment.TEST) && !actionContextData.getData().equals(this.contextData.getData())) {
                actionLog.setData(actionContextData.getData());
            }
        }
    }

    private ActionState getActionState(ActionInvoker action) {
        if (this.watchState == null) {
            return new NopActionState();
        }
        if (action.getName() == null) {
            return new NopActionState();
        }
        return this.watchState.getActionState(action.getName());
    }
}

