/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.severity;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchsupport.xcontent.ObjectTreeXContent;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchOperationExecutionException;
import com.floragunn.signals.script.SignalsScript;
import com.floragunn.signals.script.SignalsScriptContextFactory;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.severity.SeverityLevel;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SeverityMapping
implements ToXContentObject {
    private String value;
    private String lang;
    private List<Element> mapping;
    private SeverityValueScript.Factory scriptFactory;
    private Order order;
    public static final SeverityMapping DUMMY_MAPPING = new SeverityMapping(null, null, Order.ASCENDING, Arrays.asList(new Element(new BigDecimal("1"), SeverityLevel.INFO), new Element(new BigDecimal("2"), SeverityLevel.WARNING), new Element(new BigDecimal("3"), SeverityLevel.ERROR), new Element(new BigDecimal("4"), SeverityLevel.CRITICAL)));

    public SeverityMapping(String value, String lang, Order order, List<Element> mapping) {
        this.value = value;
        this.lang = lang;
        this.order = order != null ? order : Order.ASCENDING;
        this.mapping = mapping;
    }

    public EvaluationResult execute(WatchExecutionContext ctx) throws WatchOperationExecutionException {
        try {
            SeverityValueScript conditionScript = this.scriptFactory.newInstance(null, ctx);
            Number currentValue = conditionScript.execute();
            if (currentValue == null || this.isNaN(currentValue)) {
                return new EvaluationResult(SeverityLevel.NONE, null, currentValue);
            }
            Element element = this.findMatchingMappingElement(new BigDecimal(currentValue.toString()));
            if (element != null) {
                return new EvaluationResult(element.getLevel(), element, currentValue);
            }
            return new EvaluationResult(SeverityLevel.NONE, null, currentValue);
        }
        catch (ScriptException e) {
            throw new WatchOperationExecutionException(e);
        }
    }

    public BigDecimal getFirstThreshold() {
        if (this.mapping.size() > 0) {
            return this.mapping.get(0).getThreshold();
        }
        return null;
    }

    public Element findMatchingMappingElement(BigDecimal value) {
        Element result = null;
        for (Element element : this.mapping) {
            if (element.threshold.compareTo(value) * this.order.getFactor() > 0) {
                return result;
            }
            result = element;
        }
        return result;
    }

    private boolean isNaN(Number number) {
        if (number == null) {
            return true;
        }
        if (number instanceof Double && ((Double)number).isNaN()) {
            return true;
        }
        return number instanceof Float && ((Float)number).isNaN();
    }

    public void compileScripts(WatchInitializationService watchInitService) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        if (this.value != null) {
            Script script = new Script(ScriptType.INLINE, this.lang != null ? this.lang : "painless", this.value, new HashMap());
            this.scriptFactory = watchInitService.compile("value", script, SeverityValueScript.CONTEXT, validationErrors);
        }
        validationErrors.throwExceptionForPresentErrors();
    }

    public Set<SeverityLevel> getDefinedLevels() {
        HashSet<SeverityLevel> result = new HashSet<SeverityLevel>();
        for (Element element : this.mapping) {
            result.add(element.level);
        }
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.value);
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.order != null) {
            builder.field("order", (Enum)this.order);
        }
        builder.field("mapping", this.mapping);
        builder.endObject();
        return builder;
    }

    public static SeverityMapping create(WatchInitializationService watchInitService, DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        String value = vJsonNode.get("value").required().asString();
        String lang = vJsonNode.get("lang").asString();
        Order order = (Order)vJsonNode.get("order").withDefault((Enum)Order.ASCENDING).asEnum(Order.class);
        List<Element> mapping = null;
        try {
            mapping = Element.createList((List<DocNode>)jsonNode.getAsListOfNodes("mapping"), order);
        }
        catch (ConfigValidationException e) {
            validationErrors.add("mapping", e);
        }
        validationErrors.throwExceptionForPresentErrors();
        SeverityMapping result = new SeverityMapping(value, lang, order, mapping);
        result.compileScripts(watchInitService);
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public List<Element> getMapping() {
        return this.mapping;
    }

    public static enum Order {
        ASCENDING(1),
        DESCENDING(-1);

        private final int factor;

        private Order(int factor) {
            this.factor = factor;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public int getFactor() {
            return this.factor;
        }
    }

    public static abstract class SeverityValueScript
    extends SignalsScript {
        public static final String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = SignalsScriptContextFactory.scriptContextFor("signals_severity_value", Factory.class);

        public SeverityValueScript(Map<String, Object> params, WatchExecutionContext watchRuntimeContext) {
            super(params, watchRuntimeContext);
        }

        public abstract Number execute();

        public static interface Factory {
            public SeverityValueScript newInstance(Map<String, Object> var1, WatchExecutionContext var2);
        }
    }

    public static class EvaluationResult
    implements ToXContentObject {
        private final SeverityLevel level;
        private final Element mappingElement;
        private final Number value;

        public EvaluationResult(SeverityLevel level, Element mappingElement, Number actualValue) {
            this.level = level;
            this.mappingElement = mappingElement;
            this.value = actualValue;
        }

        public SeverityLevel getLevel() {
            return this.level;
        }

        public Element getMappingElement() {
            return this.mappingElement;
        }

        public Number getValue() {
            return this.value;
        }

        public Number getThreshold() {
            if (this.mappingElement != null) {
                return this.mappingElement.getThreshold();
            }
            return null;
        }

        public String getName() {
            if (this.level != null) {
                return this.level.getName();
            }
            return null;
        }

        public String getId() {
            if (this.level != null) {
                return this.level.getId();
            }
            return null;
        }

        public String toString() {
            return "EvaluationResult [level=" + this.level + ", mappingElement=" + this.mappingElement + ", actualValue=" + this.value + "]";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("level", (Enum)this.level);
            builder.field("level_numeric", this.level != null ? this.level.getLevel() : 0);
            builder.field("mapping_element", (ToXContent)this.mappingElement);
            builder.field("value", this.value);
            builder.field("threshold", this.getThreshold());
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("level", this.level != null ? this.level.toMap() : null);
            map.put("name", this.getName());
            map.put("id", this.getId());
            map.put("mapping_element", this.mappingElement != null ? this.mappingElement.toMap() : null);
            map.put("value", this.value);
            map.put("threshold", this.getThreshold());
            return map;
        }

        public static EvaluationResult create(DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(docNode, validationErrors);
            SeverityLevel level = (SeverityLevel)vJsonNode.get("level").required().asEnum(SeverityLevel.class);
            BigDecimal actualValue = vJsonNode.get("value").asBigDecimal();
            Element mappingElement = null;
            if (docNode.hasNonNull("mapping_element")) {
                try {
                    mappingElement = Element.create(docNode.getAsNode("mapping_element"));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("mapping_element", e);
                }
            }
            validationErrors.throwExceptionForPresentErrors();
            return new EvaluationResult(level, mappingElement, actualValue);
        }
    }

    public static class Element
    implements ToXContent {
        private final BigDecimal threshold;
        private final SeverityLevel level;

        public Element(BigDecimal threshold, SeverityLevel level) {
            this.threshold = threshold;
            this.level = level;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("threshold", this.threshold);
            builder.field("level", this.level.getId());
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() {
            return ObjectTreeXContent.toMap((ToXContent)this);
        }

        static List<Element> createList(List<DocNode> docNodes, Order order) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            if (docNodes == null) {
                return null;
            }
            ArrayList<Element> result = new ArrayList<Element>(docNodes.size());
            for (DocNode jsonNode : docNodes) {
                try {
                    result.add(Element.create(jsonNode));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(null, e);
                }
            }
            validationErrors.throwExceptionForPresentErrors();
            result.sort((e1, e2) -> e1.threshold.compareTo(e2.threshold) * order.getFactor());
            Element.checkForDuplicateValuesAndOrdering(result, order);
            return result;
        }

        static void checkForDuplicateValuesAndOrdering(ArrayList<Element> sortedElements, Order order) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            HashSet<BigDecimal> duplicateThresholds = new HashSet<BigDecimal>();
            for (int i = 0; i < sortedElements.size() - 1; ++i) {
                if (sortedElements.get((int)i).threshold.compareTo(sortedElements.get((int)(i + 1)).threshold) != 0) continue;
                duplicateThresholds.add(sortedElements.get((int)i).threshold);
                ++i;
            }
            if (duplicateThresholds.size() > 0) {
                validationErrors.add(new ValidationError("threshold", "Contains duplicate thresholds: " + Strings.join(duplicateThresholds, (char)',')));
            }
            HashSet<SeverityLevel> seenLevels = new HashSet<SeverityLevel>();
            ArrayList<SeverityLevel> duplicateLevels = new ArrayList<SeverityLevel>();
            for (Element e : sortedElements) {
                if (seenLevels.contains(e.level)) {
                    duplicateLevels.add(e.level);
                    continue;
                }
                seenLevels.add(e.level);
            }
            if (duplicateLevels.size() > 0) {
                validationErrors.add(new ValidationError("level", "Contains duplicate levels: " + Strings.join(duplicateLevels, (char)',')));
            }
            validationErrors.throwExceptionForPresentErrors();
            for (int i = 0; i < sortedElements.size() - 1; ++i) {
                if (SeverityLevel.compare(sortedElements.get((int)i).level, sortedElements.get((int)(i + 1)).level) <= 0) continue;
                String relation = order == Order.ASCENDING ? " > " : " < ";
                validationErrors.add(new ValidationError(null, "The ordering of the thresholds is not consistent to the ordering of the levels: " + sortedElements.get((int)i).threshold + relation + sortedElements.get((int)(i + 1)).threshold + " but " + sortedElements.get((int)i).level + " > " + sortedElements.get((int)(i + 1)).level));
                validationErrors.throwExceptionForPresentErrors();
                return;
            }
        }

        static Element create(DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            BigDecimal threshold = vJsonNode.get("threshold").required().asBigDecimal();
            SeverityLevel level = (SeverityLevel)vJsonNode.get("level").required().asEnum(SeverityLevel.class);
            vJsonNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
            return new Element(threshold, level);
        }

        public BigDecimal getThreshold() {
            return this.threshold;
        }

        public SeverityLevel getLevel() {
            return this.level;
        }

        public String toString() {
            return "Element [threshold=" + this.threshold + ", level=" + this.level + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + (this.threshold == null ? 0 : this.threshold.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Element other = (Element)obj;
            if (this.level != other.level) {
                return false;
            }
            return !(this.threshold == null ? other.threshold != null : this.threshold.compareTo(other.threshold) != 0);
        }
    }
}

