/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.watch.action.handlers.email.EmailAccount;
import java.util.Collections;
import org.apache.http.Header;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Test;

public class AccountApiTest {
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void putEmailAccount_validEmailAddresses() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            String accountId = "valid_emails";
            try {
                EmailAccount emailAccount = new EmailAccount();
                emailAccount.setHost("127.0.0.1");
                emailAccount.setDefaultFrom("from@sg.test");
                emailAccount.setDefaultTo(Collections.singletonList("to@sg.test"));
                emailAccount.setDefaultCc(Collections.singletonList("Cc <cc@sg.test>"));
                emailAccount.setDefaultBcc(Collections.singletonList("\"Bcc\" <bcc@sg.test>"));
                GenericRestClient.HttpResponse response = restClient.putJson("/_signals/account/email/" + accountId, emailAccount.toJson(), new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)201));
                response = restClient.get("/_signals/account/email/" + accountId, new Header[0]);
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            }
            finally {
                restClient.delete("/_signals/account/email/" + accountId, new Header[0]);
            }
        }
    }

    @Test
    public void putEmailAccount_invalidEmailAddresses() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            String accountId = "invalid_emails";
            EmailAccount emailAccount = new EmailAccount();
            emailAccount.setHost("127.0.0.1");
            emailAccount.setDefaultFrom("fr@om@sg.test");
            emailAccount.setDefaultTo(Collections.singletonList("to@"));
            emailAccount.setDefaultCc(Collections.singletonList("Cc cc@sg.test"));
            emailAccount.setDefaultBcc(Collections.singletonList("Bcc <bcc@sg.test"));
            GenericRestClient.HttpResponse response = restClient.putJson("/_signals/account/email/" + accountId, emailAccount.toJson(), new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)400));
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"detail", (int)4));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"detail.default_from[0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"detail['default_to.0'][0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"detail['default_cc.0'][0].error", (Object)"Invalid value"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"detail['default_bcc.0'][0].error", (Object)"Invalid value"));
            response = restClient.get("/_signals/account/email/" + accountId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)404));
        }
    }

    @Test
    public void putEmailAccount_passwordGivenWithoutUser() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            String accountId = "pass_without_user";
            EmailAccount emailAccount = new EmailAccount();
            emailAccount.setHost("127.0.0.1");
            emailAccount.setPassword("pass");
            GenericRestClient.HttpResponse response = restClient.putJson("/_signals/account/email/" + accountId, emailAccount.toJson(), new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)400));
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            DocNodeMatchers.docNodeSizeEqualTo((String)"detail", (int)1);
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"detail.user[0].error", (Object)"A user must be specified if a password is specified"));
            response = restClient.get("/_signals/account/email/" + accountId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)404));
        }
    }
}

