/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.signals.truststore.rest.TruststoreLoader;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.common.TlsConfig;
import com.floragunn.signals.watch.common.ValidationLevel;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedTrustManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TlsConfigTest {
    public static final String TRUSTSTORE_ID_1 = "truststore_id_00001";
    public static final String TRUSTSTORE_ID_2 = "truststore_id_00002";
    public static final String TRUSTSTORE_ID_3 = "truststore_id_00003";
    public static final int HALF_HOUR_SECOND = 1800;
    public static final int HOUR_SECOND = 3600;
    @Mock
    private TrustManagerRegistry trustManagerRegistry;
    @Mock
    private X509ExtendedTrustManager x509TrustManager;
    private TlsConfig tlsConfig;

    @Before
    public void before() {
        this.tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
    }

    @Test
    public void shouldUseTrustManagerWithProvidedId() throws ConfigValidationException {
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_1)).thenReturn(Optional.of(this.x509TrustManager));
        this.tlsConfig.setTruststoreId(TRUSTSTORE_ID_1);
        this.tlsConfig.init();
        ((TrustManagerRegistry)Mockito.verify((Object)this.trustManagerRegistry)).findTrustManager(TRUSTSTORE_ID_1);
    }

    @Test
    public void shouldUseOtherTrustManager() throws ConfigValidationException {
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_2)).thenReturn(Optional.of(this.x509TrustManager));
        this.tlsConfig.setTruststoreId(TRUSTSTORE_ID_2);
        this.tlsConfig.init();
        ((TrustManagerRegistry)Mockito.verify((Object)this.trustManagerRegistry)).findTrustManager(TRUSTSTORE_ID_2);
    }

    @Test
    public void shouldReportErrorWhenTruststoreWithGivenIdDoesNotExist() {
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_3)).thenReturn(Optional.empty());
        this.tlsConfig.setTruststoreId(TRUSTSTORE_ID_3);
        ConfigValidationException exception = (ConfigValidationException)ThrowableAssert.assertThatThrown(() -> this.tlsConfig.init(), (Matcher[])new Matcher[]{Matchers.instanceOf(ConfigValidationException.class)});
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Trust store truststore_id_00003 not found."));
    }

    @Test
    public void shouldNotReportErrorWhenTruststoreWithGivenIdDoesNotExistAndStrictValidationIsDisabled() throws ConfigValidationException {
        this.tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.LENIENT);
        Mockito.lenient().when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_3)).thenReturn(Optional.empty());
        this.tlsConfig.setTruststoreId(TRUSTSTORE_ID_3);
        this.tlsConfig.init();
    }

    @Test
    public void shouldReadTruststoreIdFromJson() throws ConfigValidationException {
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_3)).thenReturn(Optional.of(this.x509TrustManager));
        this.tlsConfig.init(DocNode.of((String)"truststore_id", (Object)TRUSTSTORE_ID_3));
        ((TrustManagerRegistry)Mockito.verify((Object)this.trustManagerRegistry)).findTrustManager(TRUSTSTORE_ID_3);
    }

    @Test
    public void shouldReportValidationErrorWhenTruststoreIsPointedByTwoParameters() {
        String certificate = TruststoreLoader.loadCertificates("certs/twoCerts.pem");
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_1)).thenReturn(Optional.of(this.x509TrustManager));
        DocNode invalidConfiguration = DocNode.of((String)"truststore_id", (Object)TRUSTSTORE_ID_1, (String)"trusted_certs", (Object)certificate);
        ThrowableAssert.assertThatThrown(() -> this.tlsConfig.init(invalidConfiguration), (Matcher[])new Matcher[]{Matchers.instanceOf(ConfigValidationException.class)});
    }

    @Test
    public void shouldSetTlsSessionClientTimeout() throws ConfigValidationException {
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_1)).thenReturn(Optional.of(this.x509TrustManager));
        DocNode invalidConfiguration = DocNode.of((String)"truststore_id", (Object)TRUSTSTORE_ID_1, (String)"client_session_timeout", (Object)1800);
        this.tlsConfig.init(invalidConfiguration);
        ValidationErrors validationErrors = new ValidationErrors();
        SSLContext sslContext = this.tlsConfig.buildSSLContext(validationErrors);
        int sessionTimeout = sslContext.getClientSessionContext().getSessionTimeout();
        MatcherAssert.assertThat((Object)sessionTimeout, (Matcher)Matchers.equalTo((Object)1800));
        MatcherAssert.assertThat((Object)validationErrors.hasErrors(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldSetAnotherTlsSessionClientTimeout() throws ConfigValidationException {
        Mockito.when((Object)this.trustManagerRegistry.findTrustManager(TRUSTSTORE_ID_1)).thenReturn(Optional.of(this.x509TrustManager));
        DocNode invalidConfiguration = DocNode.of((String)"truststore_id", (Object)TRUSTSTORE_ID_1, (String)"client_session_timeout", (Object)3600);
        this.tlsConfig.init(invalidConfiguration);
        ValidationErrors validationErrors = new ValidationErrors();
        SSLContext sslContext = this.tlsConfig.buildSSLContext(validationErrors);
        int sessionTimeout = sslContext.getClientSessionContext().getSessionTimeout();
        MatcherAssert.assertThat((Object)sessionTimeout, (Matcher)Matchers.equalTo((Object)3600));
        MatcherAssert.assertThat((Object)validationErrors.hasErrors(), (Matcher)Matchers.equalTo((Object)false));
    }
}

