/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.signals.actions.summary.SummaryToWatchFieldMapper;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;

class SortParser {
    public static final String PREFIX_SORT_DESC = "-";
    public static final String PREFIX_SORT_ASC = "+";

    private SortParser() {
    }

    static List<SortByField> parseSortingExpression(String expression) {
        return Optional.ofNullable(expression).map(sorting -> expression.split(",")).map(Arrays::stream).orElseGet(Stream::empty).filter(Objects::nonNull).map(String::trim).filter(fieldSorting -> !Strings.isNullOrEmpty((String)fieldSorting)).map(SortParser::parseSingleSortExpression).collect(Collectors.toList());
    }

    private static SortByField parseSingleSortExpression(String fieldSorting) {
        boolean ascending = !fieldSorting.startsWith(PREFIX_SORT_DESC);
        String fieldName = SortParser.removeSortDirectionMarker(fieldSorting);
        SummaryToWatchFieldMapper sortFieldMapping = SummaryToWatchFieldMapper.findFieldByName(fieldName).orElseThrow(() -> new ElasticsearchStatusException("Cannot sort by unknown field '" + fieldName + "'", RestStatus.BAD_REQUEST, new Object[0]));
        return new SortByField(fieldName, sortFieldMapping, ascending);
    }

    private static String removeSortDirectionMarker(String fieldSorting) {
        if (PREFIX_SORT_DESC.equals(fieldSorting) || PREFIX_SORT_ASC.equals(fieldSorting)) {
            throw new ElasticsearchStatusException("Missing field name for sorting", RestStatus.BAD_REQUEST, new Object[0]);
        }
        boolean shouldRemovePrefix = fieldSorting.startsWith(PREFIX_SORT_DESC) || fieldSorting.startsWith(PREFIX_SORT_ASC);
        return shouldRemovePrefix ? fieldSorting.substring(1) : fieldSorting;
    }

    public static class SortByField {
        private final String inputName;
        private final SummaryToWatchFieldMapper mapping;
        private final boolean ascending;

        public SortByField(String inputName, SummaryToWatchFieldMapper mapping, boolean ascending) {
            this.inputName = Objects.requireNonNull(inputName, "Input field name is required");
            this.mapping = Objects.requireNonNull(mapping);
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String getDocumentFieldName() {
            return this.mapping.getDocumentFieldName(this.inputName);
        }

        public Optional<String> getSortingFormat() {
            return this.mapping.getSortingFormat();
        }
    }
}

