/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.signals.actions.watch.ackandget.AckAndGetWatchAction;
import com.floragunn.signals.actions.watch.ackandget.AckAndGetWatchRequest;
import com.floragunn.signals.actions.watch.ackandget.AckAndGetWatchResponse;
import com.floragunn.signals.actions.watch.ackandget.Acknowledgement;
import com.floragunn.signals.api.SignalsTenantAwareRestHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;

public class AckAndGetWatchApiAction
extends SignalsTenantAwareRestHandler {
    private static final Logger log = LogManager.getLogger(AckAndGetWatchApiAction.class);

    public AckAndGetWatchApiAction(Settings settings) {
        super(settings);
    }

    public String getName() {
        return "Ack and Get Watch ";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/watch/{tenant}/{id}/_ack_and_get"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/watch/{tenant}/{id}/_ack_and_get/{actionId}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/watch/{tenant}/{id}/_ack_and_get"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/watch/{tenant}/{id}/_ack_and_get/{actionId}"));
    }

    @Override
    protected final BaseRestHandler.RestChannelConsumer getRestChannelConsumer(RestRequest request, NodeClient client) throws IOException {
        String watchId = request.param("id");
        String actionId = request.param("actionId");
        request.param("tenant");
        return channel -> {
            final boolean ack = request.getHttpRequest().method() == RestRequest.Method.PUT;
            client.execute((ActionType)AckAndGetWatchAction.INSTANCE, (ActionRequest)new AckAndGetWatchRequest(watchId, actionId, ack), (ActionListener)new ActionListener<AckAndGetWatchResponse>(){

                public void onResponse(AckAndGetWatchResponse response) {
                    if (response.getStatus() == AckAndGetWatchResponse.Status.SUCCESS) {
                        AckAndGetWatchApiAction.this.createCustomRestResponse(channel, response, ack);
                    } else if (response.getStatus() == AckAndGetWatchResponse.Status.NO_SUCH_WATCH) {
                        AckAndGetWatchApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, response.getStatusMessage());
                    } else if (response.getStatus() == AckAndGetWatchResponse.Status.ILLEGAL_STATE) {
                        AckAndGetWatchApiAction.this.errorResponse(channel, RestStatus.PRECONDITION_FAILED, response.getStatusMessage());
                    } else if (response.getStatus() == AckAndGetWatchResponse.Status.NO_SUCH_ACTION) {
                        AckAndGetWatchApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, response.getStatusMessage());
                    } else if (response.getStatus() == AckAndGetWatchResponse.Status.NOT_ACKNOWLEDGEABLE) {
                        AckAndGetWatchApiAction.this.errorResponse(channel, RestStatus.BAD_REQUEST, response.getStatusMessage());
                    } else {
                        AckAndGetWatchApiAction.this.errorResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, response.getStatusMessage());
                    }
                }

                public void onFailure(Exception e) {
                    AckAndGetWatchApiAction.this.errorResponse(channel, e);
                }
            });
        };
    }

    private void createCustomRestResponse(RestChannel channel, AckAndGetWatchResponse response, boolean ack) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.prettyPrint();
            builder.humanReadable(true);
            builder.startObject();
            builder.field("status", (Enum)RestStatus.OK);
            if (ack) {
                AckAndGetWatchApiAction.appendAckResponseFragment(response, builder);
            } else {
                AckAndGetWatchApiAction.appendUnackResponseFragment(response, builder);
            }
            builder.endObject();
            channel.sendResponse(new RestResponse(RestStatus.OK, builder));
        }
        catch (Exception e) {
            log.error("Cannot build response body for (de)ack and get action", (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    private static void appendUnackResponseFragment(AckAndGetWatchResponse response, XContentBuilder builder) throws IOException {
        builder.array("unacked_action_ids", response.getUnackedActionIds());
    }

    private static void appendAckResponseFragment(AckAndGetWatchResponse response, XContentBuilder builder) throws IOException {
        builder.startArray("acked");
        for (Acknowledgement acknowledgement : response.getSortedAcknowledgements(Comparator.comparing(Acknowledgement::getAcknowledgeTime))) {
            builder.startObject();
            builder.field("action_id", acknowledgement.getActionId());
            builder.field("by_user", acknowledgement.getAcknowledgeByUser());
            builder.field("on", (Object)acknowledgement.getAcknowledgeTime());
            builder.endObject();
        }
        builder.endArray();
    }
}

