/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.severity;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.severity.SeverityLevel;
import com.floragunn.signals.watch.severity.SeverityMapping;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class SeverityMappingTest {
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private final WatchInitializationService watchInitService = new WatchInitializationService(null, scriptService, (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class), null, ValidationLevel.STRICT);
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setupDependencies() {
        xContentRegistry = (NamedXContentRegistry)cluster.getInjectable(NamedXContentRegistry.class);
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
    }

    @Test
    public void basicTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"info"), DocNode.of((String)"threshold", (Object)2, (String)"level", (Object)"error")));
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getThreshold(), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getThreshold(), (Object)new BigDecimal(2));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getLevel(), (Object)SeverityLevel.INFO);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getLevel(), (Object)SeverityLevel.ERROR);
    }

    @Test
    public void reorderTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)2, (String)"level", (Object)"error"), DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"info")));
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getThreshold(), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getThreshold(), (Object)new BigDecimal(2));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getLevel(), (Object)SeverityLevel.INFO);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getLevel(), (Object)SeverityLevel.ERROR);
    }

    @Test
    public void descendingOrderTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"order", (Object)"descending", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)2, (String)"level", (Object)"info"), DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"error")));
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getThreshold(), (Object)new BigDecimal(2));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getThreshold(), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getLevel(), (Object)SeverityLevel.INFO);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getLevel(), (Object)SeverityLevel.ERROR);
    }

    @Test
    public void descendingReOrderTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"order", (Object)"descending", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"error"), DocNode.of((String)"threshold", (Object)2, (String)"level", (Object)"info")));
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getThreshold(), (Object)new BigDecimal(2));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getThreshold(), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(0)).getLevel(), (Object)SeverityLevel.INFO);
        Assert.assertEquals((Object)((SeverityMapping.Element)severityMapping.getMapping().get(1)).getLevel(), (Object)SeverityLevel.ERROR);
    }

    @Test
    public void duplicateTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"info"), DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"error")));
        try {
            SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
            Assert.fail((String)severityMapping.toString());
        }
        catch (ConfigValidationException e) {
            Assert.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("Contains duplicate thresholds: 1"));
        }
    }

    @Test
    public void findValueTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"info"), DocNode.of((String)"threshold", (Object)2, (String)"level", (Object)"error")));
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        SeverityMapping.Element element = severityMapping.findMatchingMappingElement(new BigDecimal("0.9"));
        Assert.assertNull((Object)element);
        element = severityMapping.findMatchingMappingElement(new BigDecimal("1.0"));
        Assert.assertEquals((Object)new SeverityMapping.Element(new BigDecimal("1.0"), SeverityLevel.INFO), (Object)element);
        element = severityMapping.findMatchingMappingElement(new BigDecimal("5.0"));
        Assert.assertEquals((Object)new SeverityMapping.Element(new BigDecimal("2.0"), SeverityLevel.ERROR), (Object)element);
    }

    @Test
    public void findValueWithBigNumbersTest() throws Exception {
        String configJson = "{\"value\": \"data.x\", \"mapping\": [{\"threshold\": 123456789999, \"level\": \"info\"}, {\"threshold\": 223456789999, \"level\": \"error\"}]}";
        DocNode config = DocNode.parse((Format)Format.JSON).from(configJson);
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        SeverityMapping.Element element = severityMapping.findMatchingMappingElement(new BigDecimal("2"));
        Assert.assertNull((Object)element);
        element = severityMapping.findMatchingMappingElement(new BigDecimal("123456799999"));
        Assert.assertEquals((Object)new SeverityMapping.Element(new BigDecimal("123456789999"), SeverityLevel.INFO), (Object)element);
        element = severityMapping.findMatchingMappingElement(new BigDecimal("223457789999"));
        Assert.assertEquals((Object)new SeverityMapping.Element(new BigDecimal("223456789999"), SeverityLevel.ERROR), (Object)element);
    }

    @Test
    public void descendingFindValueTest() throws Exception {
        DocNode config = DocNode.of((String)"value", (Object)"1", (String)"order", (Object)"descending", (String)"mapping", Arrays.asList(DocNode.of((String)"threshold", (Object)1, (String)"level", (Object)"error"), DocNode.of((String)"threshold", (Object)2, (String)"level", (Object)"info")));
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        SeverityMapping.Element element = severityMapping.findMatchingMappingElement(new BigDecimal("2.9"));
        Assert.assertNull((Object)element);
        element = severityMapping.findMatchingMappingElement(new BigDecimal("2.0"));
        Assert.assertEquals((Object)new SeverityMapping.Element(new BigDecimal("2.0"), SeverityLevel.INFO), (Object)element);
        element = severityMapping.findMatchingMappingElement(new BigDecimal("-5.0"));
        Assert.assertEquals((Object)new SeverityMapping.Element(new BigDecimal("1.0"), SeverityLevel.ERROR), (Object)element);
    }

    @Test
    public void evaluationResultTest() throws Exception {
        String configJson = "{\n    \"mapping\": [\n      {\n        \"level\": \"info\",\n        \"threshold\": 100\n      },\n      {\n        \"level\": \"warning\",\n        \"threshold\": 200\n      },\n      {\n        \"level\": \"error\",\n        \"threshold\": 300\n      },\n      {\n        \"level\": \"critical\",\n        \"threshold\": 400\n      }\n    ],\n    \"value\": \"data.a\",\n    \"order\": \"ascending\"\n  }";
        DocNode config = DocNode.parse((Format)Format.JSON).from(configJson);
        SeverityMapping severityMapping = SeverityMapping.create((WatchInitializationService)this.watchInitService, (DocNode)config);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put("a", (Object)10);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        SeverityMapping.EvaluationResult evaluationResult = severityMapping.execute(ctx);
        Map evaluationResultMap = evaluationResult.toMap();
        Assert.assertNull((Object)evaluationResult.getMappingElement());
        Assert.assertEquals((Object)SeverityLevel.NONE, (Object)evaluationResult.getLevel());
        Assert.assertEquals((Object)evaluationResult.getLevel().toMap(), evaluationResultMap.get("level"));
        runtimeData.put("a", (Object)150);
        ctx = this.buildWatchExecutionContext(runtimeData);
        evaluationResult = severityMapping.execute(ctx);
        evaluationResultMap = evaluationResult.toMap();
        Assert.assertEquals((Object)evaluationResult.getMappingElement().toMap(), evaluationResultMap.get("mapping_element"));
        Assert.assertEquals((Object)SeverityLevel.INFO, (Object)evaluationResult.getLevel());
        Assert.assertEquals((Object)evaluationResult.getLevel().toMap(), evaluationResultMap.get("level"));
    }

    private WatchExecutionContext buildWatchExecutionContext(NestedValueMap runtimeData) {
        return new WatchExecutionContext(null, scriptService, xContentRegistry, null, ExecutionEnvironment.SCHEDULED, ActionInvocationType.ALERT, new WatchExecutionContextData(runtimeData), (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (ClusterService)Mockito.mock(ClusterService.class), (FeatureService)Mockito.mock(FeatureService.class));
    }

    static {
        cluster = new LocalCluster.Builder().singleNode().sslEnabled().nodeSettings(new Object[]{"signals.enabled", true, "signals.enterprise.enabled", false}).resources("sg_config/signals").enableModule(SignalsModule.class).embedded().build();
    }
}

