/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.settings.put;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PutSettingsRequest
extends ActionRequest {
    private String key;
    private String value;
    private boolean valueJson;

    public PutSettingsRequest() {
    }

    public PutSettingsRequest(String key, String value, boolean valueJson) {
        this.key = key;
        this.value = value;
        this.valueJson = valueJson;
    }

    public PutSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.key = in.readString();
        this.value = in.readOptionalString();
        this.valueJson = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.key);
        out.writeOptionalString(this.value);
        out.writeBoolean(this.valueJson);
    }

    public ActionRequestValidationException validate() {
        if (this.key == null || this.key.length() == 0) {
            return new ActionRequestValidationException();
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isValueJson() {
        return this.valueJson;
    }

    public void setValueJson(boolean valueJson) {
        this.valueJson = valueJson;
    }

    public String toString() {
        return "PutSettingsRequest [key=" + this.key + ", value=" + this.value + ", valueJson=" + this.valueJson + "]";
    }
}

