/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.Signals;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryAction;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryData;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryRequest;
import com.floragunn.signals.actions.summary.SafeDocNodeReader;
import com.floragunn.signals.actions.summary.SortParser;
import com.floragunn.signals.actions.summary.WatchStateRepository;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;

public class LoadOperatorSummaryHandler
extends Action.Handler<LoadOperatorSummaryRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(LoadOperatorSummaryHandler.class);
    private final WatchStateRepository watchStateRepository;
    private final Signals signals;

    @Inject
    public LoadOperatorSummaryHandler(Action.HandlerDependencies handlerDependencies, NodeClient nodeClient, Signals signals) {
        super((Action)LoadOperatorSummaryAction.INSTANCE, handlerDependencies);
        this.signals = signals;
        this.watchStateRepository = new WatchStateRepository(this.getStateIndexName(), PrivilegedConfigClient.adapt((Client)nodeClient));
    }

    protected CompletableFuture<StandardResponse> doExecute(LoadOperatorSummaryRequest request) {
        return this.supplyAsync(() -> {
            StandardResponse standardResponse;
            List<SortParser.SortByField> sorting = SortParser.parseSortingExpression(request.getSorting());
            SearchResponse search = this.watchStateRepository.search(request.getWatchFilter(), sorting);
            try {
                LoadOperatorSummaryData loadOperatorSummaryData = this.convertSearchResultToResponse(search);
                standardResponse = new StandardResponse(200).data((Object)loadOperatorSummaryData);
            }
            catch (Throwable throwable) {
                try {
                    search.decRef();
                    throw throwable;
                }
                catch (Exception ex) {
                    log.error("Cannot load signal watch state summary", (Throwable)ex);
                    return new StandardResponse(400).error(ex.getMessage());
                }
            }
            search.decRef();
            return standardResponse;
        });
    }

    private LoadOperatorSummaryData convertSearchResultToResponse(SearchResponse searchResponse) {
        log.debug("Watch state search result '{}'", (Object)searchResponse);
        List<LoadOperatorSummaryData.WatchSummary> watches = Arrays.stream(searchResponse.getHits().getHits()).map(this::toWatchSummary).collect(Collectors.toList());
        return new LoadOperatorSummaryData(watches);
    }

    private LoadOperatorSummaryData.WatchSummary toWatchSummary(SearchHit documentFields) {
        try {
            DocNode docNode = DocNode.parse((Format)Format.JSON).from(documentFields.getSourceAsString());
            DocNode docNodeLastStatus = SafeDocNodeReader.findSingleNodeByJsonPath(docNode, "last_status").orElse(DocNode.EMPTY);
            LoadOperatorSummaryData.WatchSeverityDetails severityDetails = SafeDocNodeReader.findSingleNodeByJsonPath(docNode, "last_execution.severity").map(this::nodeToWatchSeverity).orElse(null);
            DocNode actions = docNode.getAsNode("actions");
            HashMap<String, LoadOperatorSummaryData.ActionSummary> mapActionSummary = new HashMap<String, LoadOperatorSummaryData.ActionSummary>();
            for (String key : actions.keySet()) {
                mapActionSummary.put(key, this.nodeToActionDetails(actions.getAsNode(key)));
            }
            return new LoadOperatorSummaryData.WatchSummary(documentFields.getId(), docNodeLastStatus.getAsString("code"), docNodeLastStatus.getAsString("severity"), docNodeLastStatus.getAsString("detail"), severityDetails, mapActionSummary);
        }
        catch (DocumentParseException e) {
            throw new ElasticsearchStatusException("Cannot parse watch state search response", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private LoadOperatorSummaryData.ActionSummary nodeToActionDetails(DocNode node) {
        try {
            DocNode lastStatus = node.getAsNode("last_status");
            String statusCode = null;
            String statusDetails = null;
            if (Objects.nonNull(lastStatus)) {
                statusCode = lastStatus.getAsString("code");
                statusDetails = lastStatus.getAsString("detail");
            }
            return new LoadOperatorSummaryData.ActionSummary(SafeDocNodeReader.getInstantValue(node, "last_triggered"), SafeDocNodeReader.getInstantValue(node, "last_check"), node.getBoolean("last_check_result"), SafeDocNodeReader.getInstantValue(node, "last_execution"), node.getAsString("last_error"), statusCode, statusDetails);
        }
        catch (ConfigValidationException e) {
            throw new ElasticsearchStatusException("Cannot parse watch state action details", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private LoadOperatorSummaryData.WatchSeverityDetails nodeToWatchSeverity(DocNode node) {
        return new LoadOperatorSummaryData.WatchSeverityDetails(node.getAsString("level"), SafeDocNodeReader.getLongValue(node, "level_numeric"), SafeDocNodeReader.getDoubleValue(node, "value"), SafeDocNodeReader.getDoubleValue(node, "threshold"));
    }

    private String getStateIndexName() {
        return this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getWatchesState();
    }
}

