/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.signals.actions.summary.SummaryToWatchFieldMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LiteralSummaryToWatchFieldMapperTest {
    private final String inputFieldName;
    private final String outputFieldName;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"severity", "last_status.severity.keyword"}, {"status_code", "last_status.code.keyword"}, {"severity_details.level_numeric", "last_execution.severity.level_numeric"}, {"severity_details.current_value", "last_execution.severity.value"}, {"severity_details.threshold", "last_execution.severity.threshold"}, {"actions.status_code", "last_execution.severity.threshold"});
    }

    public LiteralSummaryToWatchFieldMapperTest(String inputFieldName, String outputFieldName) {
        this.inputFieldName = inputFieldName;
        this.outputFieldName = outputFieldName;
    }

    @Test
    public void shouldMapLiteralFieldNames() {
        Optional foundField = SummaryToWatchFieldMapper.findFieldByName((String)this.inputFieldName);
        MatcherAssert.assertThat((Object)foundField.isPresent(), (Matcher)Matchers.equalTo((Object)true));
        SummaryToWatchFieldMapper summaryField = (SummaryToWatchFieldMapper)foundField.get();
        String documentFieldName = summaryField.getDocumentFieldName(this.inputFieldName);
        MatcherAssert.assertThat((Object)documentFieldName, (Matcher)Matchers.equalTo((Object)this.outputFieldName));
    }
}

