/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.junit.matcher.ExceptionsMatchers;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.floragunn.signals.MockWebserviceProvider;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.support.InlineMustacheTemplate;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.handlers.IndexAction;
import com.floragunn.signals.watch.action.handlers.WebhookAction;
import com.floragunn.signals.watch.action.handlers.email.EmailAccount;
import com.floragunn.signals.watch.action.handlers.email.EmailAction;
import com.floragunn.signals.watch.action.handlers.slack.SlackAccount;
import com.floragunn.signals.watch.action.handlers.slack.SlackAction;
import com.floragunn.signals.watch.action.handlers.slack.SlackActionConf;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.TlsClientAuthConfig;
import com.floragunn.signals.watch.common.TlsConfig;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.google.common.collect.ImmutableMap;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import jakarta.mail.Part;
import java.net.Socket;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509ExtendedTrustManager;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"javax.script.*", "javax.crypto.*", "javax.management.*", "sun.security.*", "java.security.*", "javax.net.ssl.*", "javax.net.*", "javax.security.*"})
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AccountRegistry.class})
@NotThreadSafe
public class ActionTest {
    private static final String ROOT_CA_CERT = "-----BEGIN CERTIFICATE-----\nMIIDyDCCArCgAwIBAgIBATANBgkqhkiG9w0BAQsFADB1MRMwEQYKCZImiZPyLGQB\nGRYDY29tMRcwFQYKCZImiZPyLGQBGRYHZXhhbXBsZTEaMBgGA1UECgwRRXhhbXBs\nZSBDb20sIEluYy4xCzAJBgNVBAsMAkNBMRwwGgYDVQQDDBNyb290LmNhLmV4YW1w\nbGUuY29tMB4XDTE4MDcyMjA4MzIxNloXDTI4MDcxOTA4MzIxNlowdTETMBEGCgmS\nJomT8ixkARkWA2NvbTEXMBUGCgmSJomT8ixkARkWB2V4YW1wbGUxGjAYBgNVBAoM\nEUV4YW1wbGUgQ29tLCBJbmMuMQswCQYDVQQLDAJDQTEcMBoGA1UEAwwTcm9vdC5j\nYS5leGFtcGxlLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJC0\nQIvdszKl5IMDurJdaFnWTW7Kcmoos91dDjrD3WxdnEnDTgXskX7UuW7VPc1uuXyU\ncK1eqYq0XJWqqxtU+ufW/BUb8wZr5I5gm0RdnQQUfBj+qDR4ACKE3XbG2hC/G+iN\nLz70EHQFukGMQkdMtnday9t5K2FN0rEs1H/B1G3C6ynlR9437gYRvwsS9WrJJ+Yj\nD8pN277oQ23px9R3OjCVstV0cCmlVkjHncI4b6NGrscG4baOcGOlmzVuTf9orzFs\neg81B2ZiGE4uTyMnbbO3uYKhP/8bw4001Tx1VdDEHwTIDIYzkgGR+RWZFcKRKwSk\nVfvm8oRb+VakdpTeniECAwEAAaNjMGEwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSME\nGDAWgBQ2TT9qHHGaxBJWtwnEixPl+xE7SzAdBgNVHQ4EFgQUNk0/ahxxmsQSVrcJ\nxIsT5fsRO0swDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEBCwUAA4IBAQB3JoH4\nPPM/49C5PuyUR6lh9+L7T38cEW5fOzwj3qFTD5P3N9ZpM87ivMgykOKYEVTnqFyL\nRG5KIlEUQ0/6oSRKgdBa9G+ahaW3dbJ0Z7INkk4PJKnwG8+XDJIr3Gi8zDPrsYy/\nWwCSQMlZ7bc04PDkvl8c4cETQWcVYJGWH0Fd/y35ATvO43V9KcXv8Fs4Pzx6S/Ma\nzA0bO/sKwCb1ZI1wUHdGyk83k/ONgcdBMlta37piVdeLXv02w+gWhg0kvZY5UZjm\nkS+ZGrFX+2Txu4N/JWHTBIEOD768G0aWR9pspgAEg+eiLRxY/qHqorCMmfHuXKz7\nH7j2LXdTXQ6Aduk6\n-----END CERTIFICATE-----\n";
    private static final String KIRK_CERT = "-----BEGIN CERTIFICATE-----\nMIIEZjCCA06gAwIBAgIGAWTBHiXPMA0GCSqGSIb3DQEBCwUAMHgxEzARBgoJkiaJ\nk/IsZAEZFgNjb20xFzAVBgoJkiaJk/IsZAEZFgdleGFtcGxlMRowGAYDVQQKDBFF\neGFtcGxlIENvbSwgSW5jLjELMAkGA1UECwwCQ0ExHzAdBgNVBAMMFnNpZ25pbmcu\nY2EuZXhhbXBsZS5jb20wHhcNMTgwNzIyMDgzMjE3WhcNMjgwNzE5MDgzMjE3WjBz\nMRMwEQYKCZImiZPyLGQBGRYDY29tMRcwFQYKCZImiZPyLGQBGRYHZXhhbXBsZTEa\nMBgGA1UECgwRRXhhbXBsZSBDb20sIEluYy4xDDAKBgNVBAsMA09wczEZMBcGA1UE\nAwwQa2lyay5leGFtcGxlLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAMiwtCG4/mhIVpJgKlB5q2Rc8I+qOt8cBF9N08LwrpWwY0SMmuYdINOIlLVV\nmCvRrh4PMyveDwmVEvIzK17/btE3W7hZtxllPnGUGAkJf6ciWTxFO4kxGS3Ojfl3\nJnBA6nWU6/r8JfqhIa6A/bQR7lO84JSgEML6bxP35NeFgI6gZOsqH2RXdr8VEucJ\nMXHGYhbLXq26TeNIqPgSW0MjNFJtvnJgAycfkSh0qkTBCk7ZrvX0jI4kcd47cPHg\nkc/jt7MzWUc1KuB0pBY2ug6p9r2+pDT1dawlifH2y7K5mlyHJ0nj0VhPi0DaieNV\n/EwopLs+TOe+Pz8RHSliyaPFqM8CAwEAAaOB+jCB9zCBnwYDVR0jBIGXMIGUgBQF\n4IV2bYTghGOHzsbkqwZcTWu/vKF5pHcwdTETMBEGCgmSJomT8ixkARkWA2NvbTEX\nMBUGCgmSJomT8ixkARkWB2V4YW1wbGUxGjAYBgNVBAoMEUV4YW1wbGUgQ29tLCBJ\nbmMuMQswCQYDVQQLDAJDQTEcMBoGA1UEAwwTcm9vdC5jYS5leGFtcGxlLmNvbYIB\nAjAdBgNVHQ4EFgQUYnhPfZqEVltKK5aEjhMYjISX0TQwDAYDVR0TAQH/BAIwADAO\nBgNVHQ8BAf8EBAMCBeAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwIwDQYJKoZIhvcN\nAQELBQADggEBADZgGQP6io4giHoHlbIXc1gGTLcNN//2DyAO/W+Oq+CCMcMzPOHJ\n3g7KmN257LN6sCGzqGTRZGpaYOnL4PMhxku62oGxs25puxHzG9lsVZ9shUr4f73N\nqyxFer6GcVTehgKO5KgA1yR0MXH1vUQ6WqstjrnfiKZ+OLQvvkoczpASi+y81baG\nkyDVLo96dfAiUv254q8IlEsO83scsdt7W4INHmHP45K79sr1lcxRC1jvAbOg5eGA\n7aDD/Ve5lkR9eoXU6iYYfT/p2RjgDSDn7MJwBLuN1FSmB28bpp5Me9gPZTtT3uW+\n1k4enV7iJWXE8009a6Z0Ouwm2Bg68Wj7TAQ=\n-----END CERTIFICATE-----\n-----BEGIN CERTIFICATE-----\nMIIEUTCCAzmgAwIBAgIBAjANBgkqhkiG9w0BAQsFADB1MRMwEQYKCZImiZPyLGQB\nGRYDY29tMRcwFQYKCZImiZPyLGQBGRYHZXhhbXBsZTEaMBgGA1UECgwRRXhhbXBs\nZSBDb20sIEluYy4xCzAJBgNVBAsMAkNBMRwwGgYDVQQDDBNyb290LmNhLmV4YW1w\nbGUuY29tMB4XDTE4MDcyMjA4MzIxNloXDTI4MDcxOTA4MzIxNloweDETMBEGCgmS\nJomT8ixkARkWA2NvbTEXMBUGCgmSJomT8ixkARkWB2V4YW1wbGUxGjAYBgNVBAoM\nEUV4YW1wbGUgQ29tLCBJbmMuMQswCQYDVQQLDAJDQTEfMB0GA1UEAwwWc2lnbmlu\nZy5jYS5leGFtcGxlLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\nAK7YSOq+e6VdPmfh7CH4PoJ1Oy4bhtAwLReuT+BEzOfo5FGUoGhJ3TAhG//92BwL\nsDem89BfxDnpUmkL2mO/lO969yjVGfd+wb5/PjIao0v5B+9tFTwZnezf5RISjJc8\nqR55HeATt+xaRYmj7Wcdhe361p4GcnVgtNdslxzULW7+aRUZz7dkGtuxUHWALZWd\nUm4owpZPcVbC0CF642CuxkGYLh8uolFPowrGuL39KdtWohiQOUi0nfoYWFpzhUn/\netLnyLmjEq41a2rykgiFC7qDW6wtvSbUbXg/DqPKiq5AIMR/R4HJ6bNEQJixsGqf\nVC9NG2v5+hCeTJdRTyFOBNcCAwEAAaOB6DCB5TASBgNVHRMBAf8ECDAGAQH/AgEA\nMIGfBgNVHSMEgZcwgZSAFDZNP2occZrEEla3CcSLE+X7ETtLoXmkdzB1MRMwEQYK\nCZImiZPyLGQBGRYDY29tMRcwFQYKCZImiZPyLGQBGRYHZXhhbXBsZTEaMBgGA1UE\nCgwRRXhhbXBsZSBDb20sIEluYy4xCzAJBgNVBAsMAkNBMRwwGgYDVQQDDBNyb290\nLmNhLmV4YW1wbGUuY29tggEBMB0GA1UdDgQWBBQF4IV2bYTghGOHzsbkqwZcTWu/\nvDAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADggEBADfPaMOnKpTLQPGW\nvCvuAXvXnKUS2sI1l59mcVuMcVQnwND2viKQ92irL0jxyNLvnqC7S8ad135GvGVs\niFUWKEANg7EsSjKREuAKQYD2GmsYwIJjw2GMp0gpIJxocrzUfCDgXyDy2fZouvvw\nM4UWds3G6zwWJWtCksRrzUTe8FoUdLW/+1HA4aaK3Y+6cQfYcgMvJZvJa9hGPuqm\nuXvw6qfsmzNM+7EFEfJW70BoyuWWbo+/ft7wsZnOhQzVnbsMHHdOHnT4Ylr+fcvf\nONKfJy8w2D+YGQXdHXdDGZlcGfwykoTLjjS+SnOShqoCUiAngFNCoIOzxct9ViW5\npDGaM90=\n-----END CERTIFICATE-----\n";
    private static final String KIRK_KEY = "-----BEGIN ENCRYPTED PRIVATE KEY-----\nMIIE9jAoBgoqhkiG9w0BDAEDMBoEFJXPhgGfl3qpK2ps9gqNUx35uHCaAgIIAASC\nBMjmI3bvVJNwKmLDaj2z4MRqn4h99ktK8mAd3rFH65QRHP0VrbTJ7ymLTsWCEwXr\nQUjR87tDsgtsEFoazXv0HATPVLkAwQzHwDkps1WSaphh2MG/05QSpdMYqP8yxKVg\nHdSOabKlwh8IQIA3QDCefCYwM+jRx1hw1B1hMXabUtqN1EENdNp6bZ76qxoiPyFm\nzq3yruaBS0CjexYbdF1wOjIAtoTkD2v/B+kiVUlz+k12nK9Wk3uf4OHL26gMI/o5\nJ2tRJ5xCGHfOQaz/VCp8QV3qnpjUp/sBMNRL6O64flmbamwN5/8y1D1xP900ZSWS\nLjrfvQAaSh52O8orcaFXSoPNRYyOsLMZ4/L7ysJP6RPLGI/MwQE/XF5p/JNcFM0X\nn1DR6UJGWl7KfJy7LT2EEM3ztiH87OvSsnrYeoBTJUE5MSmhxeiWHoPus8OsxA8v\nDNHKAMMiiaxL2Wmt+et4zpZJM7wRyRNVGqHKgCYudpCB2Del8RKm4zjF1i60EVc3\nNm9ngw3veZRhiNUrIwNqJ2dx/ZUzPQ13wUAJ9H+GKSl5SrL4JXxs1yQYClbL5TBU\nluPUhzlgSHVMzl9UCevI6j6AbGCi1DkppUelR5LN7lTgiBcCMc8XoFGzhriepobX\ntZeUM+HJtjLGcq1yGLApM775JIl8LgrpkpuACMPs6dFSqwp5612hFtbaOqFmQn2P\nSC6Kk4LcV7UahCehXtLr/S5QMoJvE7HfW92/+7Ln4tc1KCBE0+7KDq5PtjQgFybo\nUoGUvXtva0m0Ff6gt1fdyoK2/y+V91fwMc/sCrlfNIA8bz9Lk98mrppOs4vfbKlq\n9BFoZwuAebO/nuXOqn4U4gKxDabDkcxuMqgxquqtpePEH583FDNKxBvVVuZpDAbb\nKTEOxXEDZvvMJeD0P99C1L6XPhpj0olCLgiC51P8/2aoLQC9YLm5I0ne+j/La7qN\ni89+0FvnaoS75VtIlIj+kbrYOzWrnGIWHsB4k1kiSfwjdOBgbb4fc3tq9xpO9Vya\nVWecagNlNvIz6Oqi8HXX9HT73kZ0GL95DB+FZsKKy03Bvys3tPEnl/R5mJlZslfr\n0rsknLRM39Kty2W577IhRY/OypLIUppfa/R1x+yE/zN3cAAiMFyQi9BQpcEF/66x\nzjGoYanv6unKojMQJ1KOgxWRgdhZfRcUomZJdgoU6/+ZzvftHQ2/KmaGOHiVdk6E\nARnYUTwTBHoIpS8d7SfZYAjj0I51ICHWpNU2ecZ7bCJEFjRdwbOHqQOV25rpAjM9\nJdUwfi/yuw+LwjmRFFe4wqn/Je15/DM+3fNIYYwSZ2tYMjeDJFvFDcqX7m/j0DLf\nG1Q65pz3hiOedkxKobHvmEygbqaAXX7gxUXKQf7NuooBfIgGiiMv0RMYZxqxYAwy\nMVG2C1+SjlhdQgkUgFfXikku4A+3b2I+UEaJ/Jot03WCzIpJ7KIFJo5Q/56dhK7e\nlRWBjhGupivqlvgWdUYGwsfd0OVpSaUChOKnO2mGPZmnyoig2F2VaE9yX8KopWkk\nk+4D/wGJWWkW0NJN/7bGVkq5nXORzCMvN3r/UcovhEbDKAiMfIZz4eGw76xpqCmR\npuulRd0958X0/eOUE8jLSHCJsdGmwfOoJ0U=\n-----END ENCRYPTED PRIVATE KEY-----\n";
    private static final String UPLOADED_TRUSTSTORE_ID = "my-uploaded-truststore-id";
    private static final String UPLOADED_PROXY_ID = "my-uploaded-proxy-id";
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private static ClusterService clusterService;
    private static FeatureService featureService;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @Rule
    public WireMockRule wireMockProxy = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").enableBrowserProxying(true).proxyPassThrough(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
    @ClassRule
    public static LocalCluster.Embedded cluster;
    private final AccountRegistry accountRegistry = (AccountRegistry)Mockito.mock(AccountRegistry.class);
    private final TrustManagerRegistry trustManagerRegistry = (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class);
    private final X509ExtendedTrustManager trustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
    private final HttpProxyHostRegistry httpProxyHostRegistry = (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class);
    private final WatchInitializationService watchInitializationService = new WatchInitializationService(this.accountRegistry, scriptService, this.trustManagerRegistry, this.httpProxyHostRegistry, null, ValidationLevel.STRICT);

    @BeforeClass
    public static void setupTestData() throws Throwable {
        cluster.before();
        Client client = cluster.getInternalNodeClient();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy"})).actionGet();
    }

    @BeforeClass
    public static void setupDependencies() throws Throwable {
        xContentRegistry = (NamedXContentRegistry)cluster.getInjectable(NamedXContentRegistry.class);
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
        clusterService = (ClusterService)cluster.getInjectable(ClusterService.class);
        featureService = (FeatureService)cluster.getInjectable(FeatureService.class);
    }

    @Before
    public void resetMock() {
        Mockito.reset((Object[])new Object[]{this.accountRegistry, this.trustManagerRegistry, this.trustManager, this.httpProxyHostRegistry});
    }

    @Test
    public void testWebhookAction() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            runtimeData.put("signalsHeader", (Object)"Signals");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            ImmutableMap headers = ImmutableMap.of((Object)"signals", (Object)"{{data.signalsHeader}}", (Object)"anotherHeader", (Object)"another header value");
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, (Map)headers, null, null);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Header signalsHeader = webhookProvider.getLastRequestHeader("signals");
            Assert.assertNotNull((String)"Webhook request should contain header named 'signals'", (Object)signalsHeader);
            Assert.assertEquals((Object)runtimeData.get((Object)"signalsHeader"), (Object)signalsHeader.getValue());
            Header anotherHeader = webhookProvider.getLastRequestHeader("anotherHeader");
            Assert.assertNotNull((String)"Webhook request should contain header named 'anotherHeader'", (Object)anotherHeader);
            Assert.assertEquals(headers.get("anotherHeader"), (Object)anotherHeader.getValue());
        }
    }

    @Test
    public void testWebhookAction_withJsonBodyFromRuntimeDataPath() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Map)ImmutableMap.of((Object)"test", (Object)"stuff"));
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, null, JsonPath.compile((String)"data.body", (Predicate[])new Predicate[0]), null, null, null);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)DocWriter.json().writeAsString(runtimeData.get((Object)"body")), (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testWebhookAction_withJsonBodyFromRuntimeDataPath_givenPathDoesNotExists() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Map)ImmutableMap.of((Object)"test", (Object)"stuff"));
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, null, JsonPath.compile((String)"data.body.fake", (Predicate[])new Predicate[0]), null, null, null);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            webhookAction.execute(ctx);
            Assert.fail();
        }
        catch (ActionExecutionException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Failed to read body from runtime data using JSON Path: $['data']['body']['fake']"));
        }
    }

    @Test
    public void testWebhookActionWithTlsCustomTrustStore() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setInlineTruststorePem(ROOT_CA_CERT);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testWebhookActionWithTlsCustomTrustStoreFailure() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            webhookAction.execute(ctx);
            Assert.fail();
        }
        catch (ActionExecutionException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("The server certificate could not be validated using the current truststore"));
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststore() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            ((X509ExtendedTrustManager)Mockito.verify((Object)this.trustManager)).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststoreFailure() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{new CertificateException("Used for test purpose")}).when((Object)this.trustManager)).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            ThrowableAssert.assertThatThrown(() -> webhookAction.execute(ctx), (Matcher[])new Matcher[]{Matchers.instanceOf(ActionExecutionException.class), ExceptionsMatchers.causeIsInstanceOfMatcher(SSLHandshakeException.class)});
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststoreFailureRecovery() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            X509ExtendedTrustManager rejectingTrustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(rejectingTrustManager));
            ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{new CertificateException("Used for test purpose")}).when((Object)rejectingTrustManager)).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.setClientSessionTimeout(Integer.valueOf(1));
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            ThrowableAssert.assertThatThrown(() -> webhookAction.execute(ctx), (Matcher[])new Matcher[]{Matchers.instanceOf(ActionExecutionException.class), ExceptionsMatchers.causeIsInstanceOfMatcher(SSLHandshakeException.class)});
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            ((X509ExtendedTrustManager)Mockito.verify((Object)this.trustManager)).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststoreShouldUseTrustManagerEachTimeWhenHttpRequestIsSendToExternalServer() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.setClientSessionTimeout(Integer.valueOf(1));
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Thread.sleep(1001L);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Thread.sleep(1001L);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            ((X509ExtendedTrustManager)Mockito.verify((Object)this.trustManager, (VerificationMode)Mockito.times((int)3))).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststoreShouldUseTrustManagerOnlyOnceToCreateTlsContextAndThenUsesCachedTlsSession() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.setClientSessionTimeout(Integer.valueOf(3600));
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Thread.sleep(1001L);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Thread.sleep(1001L);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            ((X509ExtendedTrustManager)Mockito.verify((Object)this.trustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststoreShouldDetectThatCertificateIsNotLongerTrusted() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager), (Object[])new Optional[]{Optional.of(this.trustManager), Optional.of(this.trustManager), Optional.of(this.trustManager), Optional.of(this.trustManager)});
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.setClientSessionTimeout(Integer.valueOf(1));
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            ((X509ExtendedTrustManager)Mockito.doThrow((Throwable[])new Throwable[]{new CertificateException("Used for test purpose")}).when((Object)this.trustManager)).checkServerTrusted((X509Certificate[])ArgumentMatchers.any(X509Certificate[].class), ArgumentMatchers.anyString(), (Socket)ArgumentMatchers.any(Socket.class));
            Thread.sleep(1001L);
            ThrowableAssert.assertThatThrown(() -> webhookAction.execute(ctx), (Matcher[])new Matcher[]{Matchers.instanceOf(ActionExecutionException.class), ExceptionsMatchers.causeIsInstanceOfMatcher(SSLHandshakeException.class)});
        }
    }

    @Test
    public void testWebhookActionWithUploadedTruststoreShouldDetectThatTruststoreWasRemoved() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, false);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.setClientSessionTimeout(Integer.valueOf(1));
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.empty());
            Thread.sleep(1001L);
            ThrowableAssert.assertThatThrown(() -> webhookAction.execute(ctx), (Matcher[])new Matcher[]{Matchers.instanceOf(ActionExecutionException.class), ExceptionsMatchers.causeIsInstanceOfMatcher(SSLHandshakeException.class)});
        }
    }

    @Test
    public void testWebhookActionWithUploadedProxy() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            webhookProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(UPLOADED_PROXY_ID)).thenReturn(Optional.of(HttpHost.create((String)("http://127.0.0.8:" + this.wireMockProxy.port()))));
            HttpProxyConfig httpProxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)UPLOADED_PROXY_ID), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, httpProxyConfig);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testWebhookActionWithUploadedProxy_shouldDetectProxyChange() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            webhookProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(UPLOADED_PROXY_ID)).thenReturn(Optional.of(HttpHost.create((String)("http://127.0.0.8:" + this.wireMockProxy.port()))));
            HttpProxyConfig httpProxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)UPLOADED_PROXY_ID), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, httpProxyConfig);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(UPLOADED_PROXY_ID)).thenReturn(Optional.of(HttpHost.create((String)("168.0.0.10:" + this.wireMockProxy.port()))));
            ActionExecutionException actionExecutionException = (ActionExecutionException)ThrowableAssert.assertThatThrown(() -> webhookAction.execute(ctx), (Matcher[])new Matcher[]{Matchers.instanceOf(ActionExecutionException.class)});
            Assert.assertTrue((boolean)actionExecutionException.getMessage().contains("Connect to 168.0.0.10:"));
            Assert.assertTrue((boolean)actionExecutionException.getMessage().contains("[/168.0.0.10] failed: Connection refused"));
        }
    }

    @Test
    public void testWebhookActionWithUploadedProxy_shouldDetectProxyRemoval() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            webhookProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(UPLOADED_PROXY_ID)).thenReturn(Optional.of(HttpHost.create((String)("http://127.0.0.8:" + this.wireMockProxy.port()))));
            HttpProxyConfig httpProxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)UPLOADED_PROXY_ID), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, httpProxyConfig);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(UPLOADED_PROXY_ID)).thenReturn(Optional.empty());
            ActionExecutionException actionExecutionException = (ActionExecutionException)ThrowableAssert.assertThatThrown(() -> webhookAction.execute(ctx), (Matcher[])new Matcher[]{Matchers.instanceOf(ActionExecutionException.class)});
            Assert.assertTrue((boolean)actionExecutionException.getMessage().contains(String.format("We are only accepting requests with the '%s' header set to '%s'", REQUEST_HEADER_ADDING_FILTER.getHeader().getName(), REQUEST_HEADER_ADDING_FILTER.getHeader().getValue())));
        }
    }

    @Test
    public void testWebhookActionWithTlsClientAuth() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, true);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            TlsClientAuthConfig tlsClientAuthConfig = new TlsClientAuthConfig();
            tlsClientAuthConfig.setInlineAuthCertsPem(KIRK_CERT);
            tlsClientAuthConfig.setInlineAuthKey(KIRK_KEY);
            tlsClientAuthConfig.setInlineAuthKeyPassword("secret");
            tlsClientAuthConfig.init();
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setInlineTruststorePem(ROOT_CA_CERT);
            tlsConfig.setClientAuthConfig(tlsClientAuthConfig);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            webhookAction.execute(ctx);
            Assert.assertEquals((Object)runtimeData.get((Object)"body"), (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testWebhookActionWithTlsClientAuthFailure() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", true, true);){
            Client client = cluster.getInternalNodeClient();
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setInlineTruststorePem(ROOT_CA_CERT);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            webhookAction.execute(ctx);
            Assert.fail();
        }
        catch (ActionExecutionException actionExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testWebhookActionTimeout() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
            Client client = cluster.getInternalNodeClient();
            webhookProvider.setResponseDelayMs(3330L);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
            HttpClientConfig httpClientConfig = new HttpClientConfig(Integer.valueOf(1), Integer.valueOf(1), null, null);
            WebhookAction webhookAction = new WebhookAction(httpRequestConfig, httpClientConfig);
            httpRequestConfig.compileScripts(this.watchInitializationService);
            webhookAction.execute(ctx);
            Assert.fail();
        }
        catch (ActionExecutionException e) {
            Assert.assertTrue((String)e.toString(), (boolean)e.getCause().toString().contains("Read timed out"));
        }
    }

    @Test
    public void testIndexAction() throws Exception {
        Client client = cluster.getInternalNodeClient();
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put("_id", (Object)"my_doc");
        runtimeData.put(new NestedValueMap.Path(new String[]{"o1", "oa"}), (Object)10);
        runtimeData.put(new NestedValueMap.Path(new String[]{"o1", "ob"}), (Object)20);
        runtimeData.put(new NestedValueMap.Path(new String[]{"o2"}), (Object)"test");
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        IndexAction indexAction = new IndexAction("index_action_sink", WriteRequest.RefreshPolicy.IMMEDIATE);
        indexAction.execute(ctx);
        GetResponse getResponse = (GetResponse)client.get(new GetRequest("index_action_sink", "my_doc")).actionGet();
        Assert.assertEquals((Object)"test", getResponse.getSource().get("o2"));
    }

    @Test
    public void testIndexActionWithIdTemplate() throws Exception {
        Client client = cluster.getInternalNodeClient();
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put("id_from_data", (Object)"my_doc_2");
        runtimeData.put(new NestedValueMap.Path(new String[]{"o1", "oa"}), (Object)10);
        runtimeData.put(new NestedValueMap.Path(new String[]{"o1", "ob"}), (Object)20);
        runtimeData.put(new NestedValueMap.Path(new String[]{"o2"}), (Object)"test_2");
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        IndexAction indexAction = new IndexAction("index_action_sink", WriteRequest.RefreshPolicy.IMMEDIATE);
        indexAction.setDocId(InlineMustacheTemplate.parse((ScriptService)scriptService, (String)"{{data.id_from_data}}"));
        indexAction.execute(ctx);
        GetResponse getResponse = (GetResponse)client.get(new GetRequest("index_action_sink", "my_doc_2")).actionGet();
        Assert.assertEquals((Object)"test_2", getResponse.getSource().get("o2"));
    }

    @Test
    public void testMultiDocIndexAction() throws Exception {
        Client client = cluster.getInternalNodeClient();
        ArrayList<NestedValueMap> docs = new ArrayList<NestedValueMap>();
        NestedValueMap doc1 = new NestedValueMap();
        doc1.put("_id", (Object)"my_doc_1");
        doc1.put("_index", (Object)"multidoc_index_action_sink");
        doc1.put(new NestedValueMap.Path(new String[]{"a"}), (Object)"test_1");
        docs.add(doc1);
        NestedValueMap doc2 = new NestedValueMap();
        doc2.put("_id", (Object)"my_doc_2");
        doc2.put("_index", (Object)"multidoc_index_action_sink");
        doc2.put(new NestedValueMap.Path(new String[]{"a"}), (Object)"test_2");
        docs.add(doc2);
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put("_doc", docs);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        IndexAction indexAction = new IndexAction("index_action_sink", WriteRequest.RefreshPolicy.IMMEDIATE);
        indexAction.execute(ctx);
        GetResponse getResponse = (GetResponse)client.get(new GetRequest("multidoc_index_action_sink", "my_doc_1")).actionGet();
        Assert.assertTrue((boolean)getResponse.isExists());
        Assert.assertEquals((Object)"test_1", getResponse.getSource().get("a"));
        getResponse = (GetResponse)client.get(new GetRequest("multidoc_index_action_sink", "my_doc_2")).actionGet();
        Assert.assertTrue((boolean)getResponse.isExists());
        Assert.assertEquals((Object)"test_2", getResponse.getSource().get("a"));
    }

    @Test
    public void testMultiDocIndexActionWithArray() throws Exception {
        Client client = cluster.getInternalNodeClient();
        NestedValueMap[] docs = new NestedValueMap[2];
        NestedValueMap doc1 = new NestedValueMap();
        doc1.put("_id", (Object)"my_doc_1");
        doc1.put("_index", (Object)"multidoc_index_action_sink_2");
        doc1.put(new NestedValueMap.Path(new String[]{"a"}), (Object)"test_1");
        docs[0] = doc1;
        NestedValueMap doc2 = new NestedValueMap();
        doc2.put("_id", (Object)"my_doc_2");
        doc2.put("_index", (Object)"multidoc_index_action_sink_2");
        doc2.put(new NestedValueMap.Path(new String[]{"a"}), (Object)"test_2");
        docs[1] = doc2;
        NestedValueMap runtimeData = new NestedValueMap();
        runtimeData.put("_doc", (Object)docs);
        WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
        IndexAction indexAction = new IndexAction("index_action_sink", WriteRequest.RefreshPolicy.IMMEDIATE);
        indexAction.execute(ctx);
        GetResponse getResponse = (GetResponse)client.get(new GetRequest("multidoc_index_action_sink_2", "my_doc_1")).actionGet();
        Assert.assertTrue((boolean)getResponse.isExists());
        Assert.assertEquals((Object)"test_1", getResponse.getSource().get("a"));
        getResponse = (GetResponse)client.get(new GetRequest("multidoc_index_action_sink_2", "my_doc_2")).actionGet();
        Assert.assertTrue((boolean)getResponse.isExists());
        Assert.assertEquals((Object)"test_2", getResponse.getSource().get("a"));
    }

    @Test
    public void testSlackAction() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/slack");){
            Client client = cluster.getInternalNodeClient();
            SlackAccount slackDestination = new SlackAccount();
            slackDestination.setUrl(new URI(webhookProvider.getUri()));
            Mockito.when((Object)((SlackAccount)this.accountRegistry.lookupAccount("test_destination", SlackAccount.class))).thenReturn((Object)slackDestination);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            SlackActionConf c = new SlackActionConf();
            c.setAccount("test_destination");
            c.setChannel("test_channel");
            c.setFrom("test_from");
            c.setText("{{data.body}}");
            SlackAction slackAction = new SlackAction(c);
            slackAction.compileScripts(this.watchInitializationService);
            slackAction.execute(ctx);
            Assert.assertEquals((Object)"{\"channel\":\"test_channel\",\"username\":\"test_from\",\"text\":\"stuff\"}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testSlackActionWithBlocks() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/slack");){
            Client client = cluster.getInternalNodeClient();
            SlackAccount slackDestination = new SlackAccount();
            slackDestination.setUrl(new URI(webhookProvider.getUri()));
            Mockito.when((Object)((SlackAccount)this.accountRegistry.lookupAccount("test_destination", SlackAccount.class))).thenReturn((Object)slackDestination);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            String blocksRawJson = "[\n\t\t{\n\t\t\t\"type\": \"section\",\n\t\t\t\"text\": {\n\t\t\t\t\"type\": \"mrkdwn\",\n\t\t\t\t\"text\": \"A message *with some bold text* and {{data.body}}.\"\n\t\t\t}\n\t\t}\n\t]";
            ImmutableList blocks = DocNode.parse((Format)Format.JSON).from(blocksRawJson).toList();
            SlackActionConf c = new SlackActionConf();
            c.setAccount("test_destination");
            c.setChannel("test_channel");
            c.setFrom("test_from");
            c.setBlocks((List)blocks);
            SlackAction slackAction = new SlackAction(c);
            slackAction.compileScripts(this.watchInitializationService);
            slackAction.execute(ctx);
            String expected = "{\"channel\":\"test_channel\",\"username\":\"test_from\",\"blocks\":[{\"type\":\"section\",\"text\":{\"type\":\"mrkdwn\",\"text\":\"A message *with some bold text* and stuff.\"}}]}";
            Assert.assertEquals((Object)expected, (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testSlackActionWithBlocksAndQuotesInMustacheTemplate() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/slack");){
            Client client = cluster.getInternalNodeClient();
            SlackAccount slackDestination = new SlackAccount();
            slackDestination.setUrl(new URI(webhookProvider.getUri()));
            Mockito.when((Object)((SlackAccount)this.accountRegistry.lookupAccount("test_destination", SlackAccount.class))).thenReturn((Object)slackDestination);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            runtimeData.put("someQuote", (Object)"\"a quote\"");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            String blocksRawJson = "[\n\t\t{\n\t\t\t\"type\": \"section\",\n\t\t\t\"text\": {\n\t\t\t\t\"type\": \"mrkdwn\",\n\t\t\t\t\"text\": \"A message *with some bold text* and {{data.body}} and {{data.someQuote}}.\"\n\t\t\t}\n\t\t}\n\t]";
            ImmutableList blocks = DocNode.parse((Format)Format.JSON).from(blocksRawJson).toList();
            SlackActionConf c = new SlackActionConf();
            c.setAccount("test_destination");
            c.setChannel("test_channel");
            c.setFrom("test_from");
            c.setBlocks((List)blocks);
            SlackAction slackAction = new SlackAction(c);
            slackAction.compileScripts(this.watchInitializationService);
            slackAction.execute(ctx);
            String expected = "{\"channel\":\"test_channel\",\"username\":\"test_from\",\"blocks\":[{\"type\":\"section\",\"text\":{\"type\":\"mrkdwn\",\"text\":\"A message *with some bold text* and stuff and \\\"a quote\\\".\"}}]}";
            Assert.assertEquals((Object)expected, (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testSlackActionWithBlocksAndText() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/slack");){
            Client client = cluster.getInternalNodeClient();
            SlackAccount slackDestination = new SlackAccount();
            slackDestination.setUrl(new URI(webhookProvider.getUri()));
            Mockito.when((Object)((SlackAccount)this.accountRegistry.lookupAccount("test_destination", SlackAccount.class))).thenReturn((Object)slackDestination);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            String blocksRawJson = "[\n\t\t{\n\t\t\t\"type\": \"section\",\n\t\t\t\"text\": {\n\t\t\t\t\"type\": \"mrkdwn\",\n\t\t\t\t\"text\": \"A message *with some bold text* and {{data.body}}.\"\n\t\t\t}\n\t\t}\n\t]";
            ImmutableList blocks = DocNode.parse((Format)Format.JSON).from(blocksRawJson).toList();
            SlackActionConf c = new SlackActionConf();
            c.setAccount("test_destination");
            c.setChannel("test_channel");
            c.setFrom("test_from");
            c.setText("{{data.body}}");
            c.setBlocks((List)blocks);
            SlackAction slackAction = new SlackAction(c);
            slackAction.compileScripts(this.watchInitializationService);
            slackAction.execute(ctx);
            String expected = "{\"channel\":\"test_channel\",\"username\":\"test_from\",\"text\":\"stuff\",\"blocks\":[{\"type\":\"section\",\"text\":{\"type\":\"mrkdwn\",\"text\":\"A message *with some bold text* and stuff.\"}}]}";
            Assert.assertEquals((Object)expected, (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testSlackActionWithoutBlockAndText() {
        SlackActionConf c = new SlackActionConf();
        c.setAccount("test_destination");
        c.setChannel("test_channel");
        c.setFrom("test_from");
        SlackAction slackAction = new SlackAction(c);
        try {
            slackAction.compileScripts(this.watchInitializationService);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("'text': Required attribute is missing"));
        }
    }

    @Test
    public void testSlackActionWithAttachments() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/slack");){
            Client client = cluster.getInternalNodeClient();
            SlackAccount slackDestination = new SlackAccount();
            slackDestination.setUrl(new URI(webhookProvider.getUri()));
            Mockito.when((Object)((SlackAccount)this.accountRegistry.lookupAccount("test_destination", SlackAccount.class))).thenReturn((Object)slackDestination);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("body", (Object)"stuff");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            String attachmentRawJson = "[\n      {\n          \"fallback\": \"Plain-text summary of the attachment.\",\n          \"color\": \"#2eb886\",\n          \"pretext\": \"Optional text that appears above the attachment block\",\n          \"author_name\": \"Bobby Tables\",\n          \"author_link\": \"http://flickr.com/bobby/\",\n          \"author_icon\": \"http://flickr.com/icons/bobby.jpg\",\n          \"title\": \"Slack API Documentation\",\n          \"title_link\": \"https://api.slack.com/\",\n          \"text\": \"Optional text that appears within the attachment\",\n          \"fields\": [\n              {\n                  \"title\": \"Priority\",\n                  \"value\": \"High\",\n                  \"short\": false\n              }\n          ],\n          \"image_url\": \"http://my-website.com/path/to/image.jpg\",\n          \"thumb_url\": \"http://example.com/path/to/thumb.png\",\n          \"footer\": \"Slack API\",\n          \"footer_icon\": \"https://platform.slack-edge.com/img/default_application_icon.png\",\n          \"ts\": 123456789\n      }\n  ]";
            ImmutableList attachments = DocNode.parse((Format)Format.JSON).from(attachmentRawJson).toList();
            SlackActionConf c = new SlackActionConf();
            c.setAccount("test_destination");
            c.setChannel("test_channel");
            c.setFrom("test_from");
            c.setAttachments((List)attachments);
            SlackAction slackAction = new SlackAction(c);
            slackAction.compileScripts(this.watchInitializationService);
            slackAction.execute(ctx);
            String expected = "{\"channel\":\"test_channel\",\"username\":\"test_from\",\"attachments\":[{\"fallback\":\"Plain-text summary of the attachment.\",\"color\":\"#2eb886\",\"pretext\":\"Optional text that appears above the attachment block\",\"author_name\":\"Bobby Tables\",\"author_link\":\"http://flickr.com/bobby/\",\"author_icon\":\"http://flickr.com/icons/bobby.jpg\",\"title\":\"Slack API Documentation\",\"title_link\":\"https://api.slack.com/\",\"text\":\"Optional text that appears within the attachment\",\"fields\":[{\"title\":\"Priority\",\"value\":\"High\",\"short\":false}],\"image_url\":\"http://my-website.com/path/to/image.jpg\",\"thumb_url\":\"http://example.com/path/to/thumb.png\",\"footer\":\"Slack API\",\"footer_icon\":\"https://platform.slack-edge.com/img/default_application_icon.png\",\"ts\":123456789}]}";
            Assert.assertEquals((Object)expected, (Object)webhookProvider.getLastRequestBody());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailAction() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            EmailAccount emailAccount = new EmailAccount();
            emailAccount.setHost("localhost");
            emailAccount.setPort(smtpPort);
            emailAccount.setDefaultFrom("from@default.sgtest");
            emailAccount.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
            Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailAccount);
            EmailAction emailAction = new EmailAction();
            emailAction.setBody("We searched {{data.x}} shards");
            emailAction.setSubject("Test Subject");
            emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
            emailAction.setAccount("test_destination");
            EmailAction.Attachment attachment1 = new EmailAction.Attachment();
            attachment1.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
            EmailAction.Attachment attachment2 = new EmailAction.Attachment();
            attachment2.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
            emailAction.setAttachments((Map)ImmutableMap.of((Object)"test2", (Object)attachment2, (Object)"test1", (Object)attachment1));
            emailAction.compileScripts(this.watchInitializationService);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("x", (Object)"y");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            ActionExecutionResult result = emailAction.execute(ctx);
            Assert.assertTrue((String)result.getRequest(), (boolean)result.getRequest().contains("Content-Type: text/plain"));
            Assert.assertFalse((String)result.getRequest(), (boolean)result.getRequest().contains("Content-Type: multipart/alternative"));
            if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                Assert.fail((String)"Timeout waiting for mails");
            }
            String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
            Assert.assertTrue((receivedMail.indexOf("Content-ID: <test2>") < receivedMail.indexOf("Content-ID: <test1>") ? 1 : 0) != 0);
        }
        finally {
            greenMail.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionTls() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtps"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            EmailAccount emailAccount = new EmailAccount();
            emailAccount.setHost("localhost");
            emailAccount.setPort(smtpPort);
            emailAccount.setEnableTls(true);
            emailAccount.setTrustAll(true);
            emailAccount.setDefaultFrom("from@default.sgtest");
            emailAccount.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
            Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailAccount);
            EmailAction emailAction = new EmailAction();
            emailAction.setBody("We searched {{data.x}} shards");
            emailAction.setSubject("Test Subject");
            emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
            emailAction.setAccount("test_destination");
            EmailAction.Attachment attachment1 = new EmailAction.Attachment();
            attachment1.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
            EmailAction.Attachment attachment2 = new EmailAction.Attachment();
            attachment2.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
            emailAction.setAttachments((Map)ImmutableMap.of((Object)"test2", (Object)attachment2, (Object)"test1", (Object)attachment1));
            emailAction.compileScripts(this.watchInitializationService);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("x", (Object)"y");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            ActionExecutionResult result = emailAction.execute(ctx);
            Assert.assertTrue((String)result.getRequest(), (boolean)result.getRequest().contains("Content-Type: text/plain"));
            Assert.assertFalse((String)result.getRequest(), (boolean)result.getRequest().contains("Content-Type: multipart/alternative"));
            if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                Assert.fail((String)"Timeout waiting for mails");
            }
            String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
            Assert.assertTrue((receivedMail.indexOf("Content-ID: <test2>") < receivedMail.indexOf("Content-ID: <test1>") ? 1 : 0) != 0);
        }
        finally {
            greenMail.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionWithHtmlBody() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            EmailAccount emailDestination = new EmailAccount();
            emailDestination.setHost("localhost");
            emailDestination.setPort(smtpPort);
            emailDestination.setDefaultFrom("from@default.sgtest");
            emailDestination.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
            Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailDestination);
            EmailAction emailAction = new EmailAction();
            emailAction.setHtmlBody("<p>We searched {{data.x}} shards<p/>");
            emailAction.setSubject("Test Subject");
            emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
            emailAction.setAccount("test_destination");
            EmailAction.Attachment attachment = new EmailAction.Attachment();
            attachment.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
            emailAction.setAttachments((Map)ImmutableMap.of((Object)"test", (Object)attachment));
            emailAction.compileScripts(this.watchInitializationService);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("x", (Object)"y");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            ActionExecutionResult result = emailAction.execute(ctx);
            Assert.assertTrue((boolean)result.getRequest().contains("<p>We searched y shards<p/>"));
            if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                Assert.fail((String)"Timeout waiting for mails");
            }
            String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("<p>We searched y shards<p/>"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Type: text/html"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
        }
        finally {
            greenMail.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionWithHtmlBodyAndTextBody() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            EmailAccount emailDestination = new EmailAccount();
            emailDestination.setHost("localhost");
            emailDestination.setPort(smtpPort);
            emailDestination.setDefaultFrom("from@default.sgtest");
            emailDestination.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
            Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailDestination);
            EmailAction emailAction = new EmailAction();
            emailAction.setBody("{{data.x}} shards have been searched for");
            emailAction.setHtmlBody("<p>We searched {{data.x}} shards<p/>");
            emailAction.setSubject("Test Subject");
            emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
            emailAction.setAccount("test_destination");
            EmailAction.Attachment attachment = new EmailAction.Attachment();
            attachment.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
            emailAction.setAttachments((Map)ImmutableMap.of((Object)"test", (Object)attachment));
            emailAction.compileScripts(this.watchInitializationService);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("x", (Object)"y");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            ActionExecutionResult result = emailAction.execute(ctx);
            Assert.assertTrue((boolean)result.getRequest().contains("y shards have been searched for"));
            Assert.assertTrue((boolean)result.getRequest().contains("<p>We searched y shards<p/>"));
            Assert.assertTrue((boolean)result.getRequest().contains("Content-Type: multipart/alternative"));
            Assert.assertTrue((boolean)result.getRequest().contains("Content-Type: text/plain"));
            Assert.assertTrue((boolean)result.getRequest().contains("Content-Type: text/html"));
            if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                Assert.fail((String)"Timeout waiting for mails");
            }
            String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("<p>We searched y shards<p/>"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Type: text/html"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
        }
        finally {
            greenMail.stop();
        }
    }

    @Test
    public void testEmailActionWithMissingHtmlBodyAndMissingBody() throws Exception {
        EmailAccount emailDestination = new EmailAccount();
        emailDestination.setHost("localhost");
        emailDestination.setPort(1234);
        emailDestination.setDefaultFrom("from@default.sgtest");
        emailDestination.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
        Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailDestination);
        EmailAction emailAction = new EmailAction();
        emailAction.setSubject("Test Subject");
        emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
        emailAction.setAccount("test_destination");
        EmailAction.Attachment attachment = new EmailAction.Attachment();
        attachment.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
        emailAction.setAttachments((Map)ImmutableMap.of((Object)"test", (Object)attachment));
        try {
            emailAction.compileScripts(this.watchInitializationService);
        }
        catch (ConfigValidationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Both body and html_body are empty"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionWithBasicTextRequestAndRuntimeData() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook");){
                NestedValueMap runtimeData = new NestedValueMap();
                runtimeData.put("path", (Object)"hook");
                runtimeData.put("body", (Object)"stuff");
                runtimeData.put("x", (Object)"y");
                HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
                HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
                httpRequestConfig.compileScripts(this.watchInitializationService);
                EmailAccount emailDestination = new EmailAccount();
                emailDestination.setHost("localhost");
                emailDestination.setPort(smtpPort);
                emailDestination.setDefaultFrom("from@default.sgtest");
                emailDestination.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
                Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailDestination);
                EmailAction emailAction = new EmailAction();
                emailAction.setBody("We searched {{data.x}} shards");
                emailAction.setSubject("Test Subject");
                emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
                emailAction.setAccount("test_destination");
                EmailAction.Attachment attachment = new EmailAction.Attachment();
                attachment.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
                EmailAction.Attachment attachment2 = new EmailAction.Attachment();
                attachment2.setType(EmailAction.Attachment.AttachmentType.REQUEST);
                attachment2.setRequestConfig(httpRequestConfig);
                attachment2.setHttpClientConfig(httpClientConfig);
                emailAction.setAttachments((Map)ImmutableMap.of((Object)"test", (Object)attachment, (Object)"test2", (Object)attachment2));
                emailAction.compileScripts(this.watchInitializationService);
                WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
                emailAction.execute(ctx);
                if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                    Assert.fail((String)"Timeout waiting for mails");
                }
                String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=test"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("{\"path\":\"hook\",\"x\":\"y\",\"body\":\"stuff\"}"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=test2"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Mockery"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
            }
        }
        finally {
            greenMail.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionWithPDFRequestAndRuntimeData() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            byte[] pdf = IOUtils.toByteArray((URI)FileHelper.getAbsoluteFilePathFromClassPath((String)"blank_email_attachment.pdf").toUri());
            try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", pdf, "application/pdf");){
                NestedValueMap runtimeData = new NestedValueMap();
                runtimeData.put("path", (Object)"hook");
                runtimeData.put("body", (Object)"stuff");
                runtimeData.put("x", (Object)"y");
                HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
                HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
                httpRequestConfig.compileScripts(this.watchInitializationService);
                EmailAccount emailDestination = new EmailAccount();
                emailDestination.setHost("localhost");
                emailDestination.setPort(smtpPort);
                emailDestination.setDefaultFrom("from@default.sgtest");
                emailDestination.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
                Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailDestination);
                EmailAction emailAction = new EmailAction();
                emailAction.setBody("We searched {{data.x}} shards");
                emailAction.setSubject("Test Subject");
                emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
                emailAction.setAccount("test_destination");
                EmailAction.Attachment attachment = new EmailAction.Attachment();
                attachment.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
                EmailAction.Attachment attachment2 = new EmailAction.Attachment();
                attachment2.setType(EmailAction.Attachment.AttachmentType.REQUEST);
                attachment2.setRequestConfig(httpRequestConfig);
                attachment2.setHttpClientConfig(httpClientConfig);
                emailAction.setAttachments((Map)ImmutableMap.of((Object)"test", (Object)attachment, (Object)"test2", (Object)attachment2));
                emailAction.compileScripts(this.watchInitializationService);
                WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
                emailAction.execute(ctx);
                if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                    Assert.fail((String)"Timeout waiting for mails");
                }
                String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=test"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("{\"path\":\"hook\",\"x\":\"y\",\"body\":\"stuff\"}"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=test2"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
            }
        }
        finally {
            greenMail.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionWithJSONRequestsAndRuntimeData() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            String helloWorld = "{\n   \"hello\":\"world\"\n}";
            try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/hook", helloWorld.getBytes(), "application/json");){
                NestedValueMap runtimeData = new NestedValueMap();
                runtimeData.put("path", (Object)"hook");
                runtimeData.put("body", (Object)"stuff");
                runtimeData.put("x", (Object)"y");
                HttpRequestConfig httpRequestConfig = new HttpRequestConfig(HttpRequestConfig.Method.POST, new URI(webhookProvider.getUri()), "/{{data.path}}", null, "{{data.body}}", null, null, null, null);
                HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
                httpRequestConfig.compileScripts(this.watchInitializationService);
                EmailAccount emailDestination = new EmailAccount();
                emailDestination.setHost("localhost");
                emailDestination.setPort(smtpPort);
                emailDestination.setDefaultFrom("from@default.sgtest");
                emailDestination.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
                Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailDestination);
                EmailAction emailAction = new EmailAction();
                emailAction.setBody("We searched {{data.x}} shards");
                emailAction.setSubject("Test Subject");
                emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
                emailAction.setAccount("test_destination");
                EmailAction.Attachment attachment = new EmailAction.Attachment();
                attachment.setType(EmailAction.Attachment.AttachmentType.RUNTIME);
                EmailAction.Attachment attachment2 = new EmailAction.Attachment();
                attachment2.setType(EmailAction.Attachment.AttachmentType.REQUEST);
                attachment2.setRequestConfig(httpRequestConfig);
                attachment2.setHttpClientConfig(httpClientConfig);
                EmailAction.Attachment attachment3 = new EmailAction.Attachment();
                attachment3.setType(EmailAction.Attachment.AttachmentType.REQUEST);
                attachment3.setRequestConfig(httpRequestConfig);
                attachment3.setHttpClientConfig(httpClientConfig);
                emailAction.setAttachments((Map)ImmutableMap.of((Object)"attachment3", (Object)attachment3, (Object)"test", (Object)attachment, (Object)"test2", (Object)attachment2));
                emailAction.compileScripts(this.watchInitializationService);
                WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
                emailAction.execute(ctx);
                if (!greenMail.waitForIncomingEmail(20000L, 1)) {
                    Assert.fail((String)"Timeout waiting for mails");
                }
                String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=test"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("{\"path\":\"hook\",\"x\":\"y\",\"body\":\"stuff\"}"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=test2"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("\"hello\":\"world\""));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Content-Disposition: attachment; filename=attachment3"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("\"hello\":\"world\""));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: from@default.sgtest"));
                Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: to@specific.sgtest"));
            }
        }
        finally {
            greenMail.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailActionWithEmailAddressesContainingDisplayNames() throws Exception {
        int smtpPort = SocketUtils.findAvailableTcpPort();
        GreenMail greenMail = new GreenMail(new ServerSetup(smtpPort, "127.0.0.1", "smtp"));
        greenMail.start();
        try {
            Client client = cluster.getInternalNodeClient();
            EmailAccount emailAccount = new EmailAccount();
            emailAccount.setHost("localhost");
            emailAccount.setPort(smtpPort);
            emailAccount.setDefaultFrom("from@default.sgtest");
            emailAccount.setDefaultTo(Collections.singletonList("to@default.sgtest"));
            emailAccount.setDefaultCc(Arrays.asList("cc1@default.sgtest", "cc2@default.sgtest"));
            emailAccount.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
            Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailAccount);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("x", (Object)"y");
            runtimeData.put("fromEmailAddress", (Object)"from@specific.sgtest");
            runtimeData.put("fromName", (Object)"From Specific");
            runtimeData.put("toEmailAddress", (Object)"to@specific.sgtest");
            runtimeData.put("toName", (Object)"To Specific");
            runtimeData.put("firstCcEmailAddress", (Object)"cc1@specific.sgtest");
            runtimeData.put("firstCcName", (Object)"Cc1 Specific");
            runtimeData.put("secondCcEmailAddress", (Object)"cc2@specific.sgtest");
            runtimeData.put("secondCcName", (Object)"Cc2 Specific");
            runtimeData.put("bccEmailAddress", (Object)"bcc@specific.sgtest");
            runtimeData.put("bccName", (Object)"Bcc Specific");
            EmailAction emailAction = new EmailAction();
            emailAction.setBody("We searched {{data.x}} shards");
            emailAction.setSubject("Test Subject");
            emailAction.setFrom("\"{{data.fromName}}\" <{{data.fromEmailAddress}}>");
            emailAction.setTo(Collections.singletonList("{{data.toName}} <{{data.toEmailAddress}}>"));
            emailAction.setCc(Arrays.asList("{{data.firstCcName}} <{{data.firstCcEmailAddress}}>", "<{{data.secondCcEmailAddress}}>"));
            emailAction.setBcc(Collections.singletonList("{{data.bccEmailAddress}}"));
            emailAction.setReplyTo("Reply To <replyto@specific.sgtest>");
            emailAction.setAccount("test_destination");
            emailAction.compileScripts(this.watchInitializationService);
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            ActionExecutionResult result = emailAction.execute(ctx);
            Assert.assertTrue((String)result.getRequest(), (boolean)result.getRequest().contains("Content-Type: text/plain"));
            if (!greenMail.waitForIncomingEmail(20000L, 3)) {
                Assert.fail((String)"Timeout waiting for mails");
            }
            String receivedMail = GreenMailUtil.getWholeMessage((Part)greenMail.getReceivedMessages()[0]);
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("We searched y shards"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Subject: Test Subject"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("From: From Specific <from@specific.sgtest>"));
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("To: To Specific <to@specific.sgtest>"));
            Assert.assertTrue((String)receivedMail, (receivedMail.contains("Cc: Cc1 Specific <cc1@specific.sgtest>, cc2@specific.sgtest") || receivedMail.contains("Cc: cc2@specific.sgtest, Cc1 Specific <cc1@specific.sgtest>") ? 1 : 0) != 0);
            Assert.assertTrue((String)receivedMail, (boolean)receivedMail.contains("Reply-To: Reply To <replyto@specific.sgtest>"));
        }
        finally {
            greenMail.stop();
        }
    }

    @Test
    public void testEmailActionWithMalformedEmailAddressContainingDisplayName() throws Exception {
        try {
            Client client = cluster.getInternalNodeClient();
            EmailAccount emailAccount = new EmailAccount();
            emailAccount.setHost("localhost");
            emailAccount.setPort(1234);
            emailAccount.setDefaultFrom("from@default.sgtest");
            emailAccount.setDefaultTo(Collections.singletonList("to@default.sgtest"));
            emailAccount.setDefaultCc(Arrays.asList("cc1@default.sgtest", "cc2@default.sgtest"));
            emailAccount.setDefaultBcc(new String[]{"bcc1@default.sgtest", "bcc2@default.sgtest"});
            Mockito.when((Object)((EmailAccount)this.accountRegistry.lookupAccount("test_destination", EmailAccount.class))).thenReturn((Object)emailAccount);
            NestedValueMap runtimeData = new NestedValueMap();
            EmailAction emailAction = new EmailAction();
            emailAction.setBody("We searched {{data.x}} shards");
            emailAction.setSubject("Test Subject");
            emailAction.setFrom("FromName <from@specific.sgtest");
            emailAction.setTo(Collections.singletonList("to@specific.sgtest"));
            emailAction.setAccount("test_destination");
            emailAction.compileScripts(this.watchInitializationService);
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            emailAction.execute(ctx);
            Assert.fail();
        }
        catch (ActionExecutionException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)e.getMessage().contains("Error while parsing email: FromName <from@specific.sgtest"));
        }
    }

    private WatchExecutionContext buildWatchExecutionContext(NestedValueMap runtimeData) {
        return new WatchExecutionContext(cluster.getInternalNodeClient(), scriptService, xContentRegistry, this.accountRegistry, ExecutionEnvironment.SCHEDULED, ActionInvocationType.ALERT, new WatchExecutionContextData(runtimeData), this.trustManagerRegistry, clusterService, featureService);
    }

    static {
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        cluster = new LocalCluster.Builder().singleNode().sslEnabled().nodeSettings(new Object[]{"signals.enabled", true, "signals.enterprise.enabled", false}).resources("sg_config/signals").enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

