/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.get;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class GetAccountResponse
extends ActionResponse
implements ToXContentObject {
    private String id;
    private boolean exists;
    private long version;
    private long seqNo;
    private long primaryTerm;
    private BytesReference source;

    public GetAccountResponse() {
    }

    public GetAccountResponse(String id, boolean exists) {
        this(id, exists, -1L, -1L, -1L, null);
    }

    public GetAccountResponse(String id, boolean exists, long version, long seqNo, long primaryTerm, BytesReference source) {
        this.id = id;
        this.exists = exists;
        this.version = version;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.source = source;
    }

    public GetAccountResponse(GetResponse getResponse) {
        this.id = getResponse.getId();
        this.exists = getResponse.isExists();
        this.version = getResponse.getVersion();
        this.seqNo = getResponse.getSeqNo();
        this.primaryTerm = getResponse.getPrimaryTerm();
        this.source = getResponse.getSourceAsBytesRef();
    }

    public GetAccountResponse(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.exists = in.readBoolean();
        this.version = in.readLong();
        this.seqNo = in.readLong();
        this.primaryTerm = in.readLong();
        this.source = in.readOptionalBytesReference();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.exists);
        out.writeLong(this.version);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeOptionalBytesReference(this.source);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_id", this.id);
        builder.field("found", this.exists);
        if (this.exists) {
            builder.field("_version", this.version);
            builder.field("_seq_no", this.seqNo);
            builder.field("_primary_term", this.primaryTerm);
            XContentHelper.writeRawField((String)"_source", (BytesReference)this.source, (XContentType)XContentType.JSON, (XContentBuilder)builder, (ToXContent.Params)params);
        }
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }
}

