/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.utils.CertificateAndPrivateKeyWriter;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import com.floragunn.signals.truststore.rest.TruststoreLoader;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.Header;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.bouncycastle.cert.X509CertificateHolder;

public class MockWebserviceProvider
implements Closeable {
    private HttpServer httpServer;
    private final int port;
    private final String uri;
    private final boolean ssl;
    private int responseStatusCode = 200;
    private byte[] responseBody = "Mockery".getBytes();
    private String responseContentType = "text/plain";
    private String lastRequestBody;
    private List<Header> lastRequestHeaders;
    private InetAddress lastRequestClientAddress;
    private final AtomicInteger requestCount = new AtomicInteger();
    private long responseDelayMs = 0L;
    private Header requiredHttpHeader;
    private KeyStore trustStore;

    MockWebserviceProvider(String path) throws IOException {
        this(path, SocketUtils.findAvailableTcpPort());
    }

    MockWebserviceProvider(String path, byte[] body, String contentType) throws IOException {
        this(path, SocketUtils.findAvailableTcpPort());
        this.responseContentType = contentType;
        this.responseBody = body;
    }

    MockWebserviceProvider(String path, boolean ssl) throws IOException {
        this(path, SocketUtils.findAvailableTcpPort(), ssl, ssl);
    }

    MockWebserviceProvider(String path, boolean ssl, boolean clientAuth) throws IOException {
        this(path, SocketUtils.findAvailableTcpPort(), ssl, clientAuth);
    }

    MockWebserviceProvider(String path, int port) throws IOException {
        this(path, port, false, false);
    }

    MockWebserviceProvider(String pathPattern, int port, boolean ssl, final boolean clientAuth) throws IOException {
        this.port = port;
        this.uri = MockWebserviceProvider.buildUri(pathPattern, ssl, port);
        this.ssl = ssl;
        ServerBootstrap serverBootstrap = ServerBootstrap.bootstrap().setListenerPort(port).registerHandler(pathPattern, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockWebserviceProvider.this.handleRequest(request, response, context);
            }
        });
        if (ssl) {
            serverBootstrap = serverBootstrap.setSslContext(this.createSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

                public void initialize(SSLServerSocket socket) throws SSLException {
                    socket.setNeedClientAuth(clientAuth);
                }
            }).setConnectionFactory((HttpConnectionFactory)new HttpConnectionFactory<DefaultBHttpServerConnection>(){
                private ConnectionConfig cconfig = ConnectionConfig.DEFAULT;

                public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
                    SSLTestHttpServerConnection conn = new SSLTestHttpServerConnection(this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), ConnSupport.createDecoder((ConnectionConfig)this.cconfig), ConnSupport.createEncoder((ConnectionConfig)this.cconfig), this.cconfig.getMessageConstraints(), null, null, null, null);
                    conn.bind(socket);
                    return conn;
                }
            });
        }
        this.httpServer = serverBootstrap.create();
        this.httpServer.start();
    }

    public MockWebserviceProvider acceptOnlyRequestsWithHeader(Header header) {
        this.requiredHttpHeader = header;
        return this;
    }

    public void start() throws IOException {
        this.httpServer.start();
    }

    @Override
    public void close() throws IOException {
        this.httpServer.stop();
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public String getUri() {
        return this.uri;
    }

    public int getPort() {
        return this.port;
    }

    public String trustedCertificatePem(String alias) {
        try {
            Certificate certificate = this.trustStore.getCertificate(alias);
            byte[] derCertificateBytes = certificate.getEncoded();
            X509CertificateHolder holder = new X509CertificateHolder(derCertificateBytes);
            return CertificateAndPrivateKeyWriter.writeCertificate((X509CertificateHolder)holder);
        }
        catch (IOException | KeyStoreException | CertificateEncodingException e) {
            throw new RuntimeException("Cannot write certificate as pem", e);
        }
    }

    private static String buildUri(String pathPattern, boolean ssl, int port) {
        StringBuilder result = new StringBuilder(ssl ? "https" : "http");
        result.append("://localhost:").append(port);
        if (pathPattern != null) {
            String path = pathPattern;
            if (path.endsWith("*")) {
                path = pathPattern.substring(0, pathPattern.length() - 1);
            }
            if (!path.startsWith("/")) {
                result.append("/");
            }
            result.append(path);
        }
        return result.toString();
    }

    protected void handleRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.checkClientAddress(request, response, context)) {
            return;
        }
        if (this.responseDelayMs > 0L) {
            try {
                Thread.sleep(this.responseDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        response.setStatusCode(this.responseStatusCode);
        response.setHeader("Content-Type", this.responseContentType);
        response.setEntity((HttpEntity)new ByteArrayEntity(this.responseBody));
        this.lastRequestBody = request instanceof HttpEntityEnclosingRequest ? CharStreams.toString((Readable)new InputStreamReader(((HttpEntityEnclosingRequest)request).getEntity().getContent(), Charsets.UTF_8)) : null;
        this.lastRequestHeaders = Arrays.asList(request.getAllHeaders());
        this.requestCount.incrementAndGet();
    }

    private SSLContext createSSLContext() {
        if (!this.ssl) {
            return null;
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.trustStore = KeyStore.getInstance("JKS");
            FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"tls/truststore.jks").toFile());
            this.trustStore.load(trustStream, "secret".toCharArray());
            tmf.init(this.trustStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"tls/node1-keystore.jks").toFile());
            keyStore.load(keyStream, "secret".toCharArray());
            kmf.init(keyStore, "secret".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkClientAddress(HttpRequest request, HttpResponse response, HttpContext context) throws UnsupportedEncodingException {
        HttpInetConnection connection = (HttpInetConnection)context.getAttribute("http.connection");
        this.lastRequestClientAddress = connection.getRemoteAddress();
        if (this.requiredHttpHeader != null) {
            List<Header> requestHeaders = Arrays.asList(request.getHeaders(this.requiredHttpHeader.getName()));
            if (requestHeaders.stream().anyMatch(header -> this.requiredHttpHeader.getValue().equals(header.getValue()))) {
                return true;
            }
            response.setStatusCode(451);
            response.setEntity((HttpEntity)new StringEntity("We are only accepting requests with the '" + this.requiredHttpHeader.getName() + "' header set to '" + this.requiredHttpHeader.getValue() + "'"));
            return false;
        }
        return true;
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(int responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody.getBytes();
    }

    public void setResponseBody(byte[] responseBody) {
        this.responseBody = responseBody;
    }

    public String getLastRequestBody() {
        return this.lastRequestBody;
    }

    public void setLastRequestBody(String lastRequestBody) {
        this.lastRequestBody = lastRequestBody;
    }

    public List<Header> getLastRequestHeaders() {
        return this.lastRequestHeaders;
    }

    public void setLastRequestHeaders(List<Header> lastRequestHeaders) {
        this.lastRequestHeaders = lastRequestHeaders;
    }

    public Header getLastRequestHeader(String name) {
        return ((List)Optional.ofNullable(this.lastRequestHeaders).orElse(new ArrayList())).stream().filter(header -> header.getName().equals(name)).findFirst().orElse(null);
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public long getResponseDelayMs() {
        return this.responseDelayMs;
    }

    public void setResponseDelayMs(long responseDelayMs) {
        this.responseDelayMs = responseDelayMs;
    }

    public InetAddress getLastRequestClientAddress() {
        return this.lastRequestClientAddress;
    }

    public void uploadMockServerCertificateAsTruststore(LocalCluster cluster, TestSgConfig.User user, String truststoreId) throws Exception {
        String pemCertificate = this.trustedCertificatePem("root-ca");
        try (GenericRestClient genericRestClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)user, new Header[0]);){
            TruststoreLoader.storeTruststoreInPemFormat(genericRestClient, truststoreId, "name", pemCertificate);
        }
    }

    static class SSLTestHttpServerConnection
    extends DefaultBHttpServerConnection {
        public SSLTestHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
            super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
        }

        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            return ((SSLSocket)this.getSocket()).getSession().getPeerCertificates();
        }
    }
}

