/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.util.WatchLogSearch;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.ThrottlePeriodParser;
import com.floragunn.signals.watch.common.throttle.ValidatingThrottlePeriodParser;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.result.WatchLog;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.Header;
import org.awaitility.Awaitility;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

@NotThreadSafe
public class RestApiTestMultiTenancyOff {
    public static final String SIGNALS_LOGS_INDEX_NAME = "signals__main_log";
    public static final String HUGE_DOCUMENT_INDEX = "huge_document_index";
    public static final int HUGE_DOCUMENT_FIELD_COUNT = 970;
    private static ScriptService scriptService;
    private static ThrottlePeriodParser throttlePeriodParser;
    private final WatchInitializationService watchInitializationService = new WatchInitializationService(null, scriptService, (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class), throttlePeriodParser, ValidationLevel.STRICT);
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setupTestData() {
        Client client = cluster.getInternalNodeClient();
        client.index(new IndexRequest("testsource").source(XContentType.JSON, new Object[]{"key1", "val1", "key2", "val2"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy"})).actionGet();
    }

    @BeforeClass
    public static void setupDependencies() {
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
        throttlePeriodParser = new ValidatingThrottlePeriodParser(((Signals)cluster.getInjectable(Signals.class)).getSignalsSettings());
    }

    @Test
    public void testGetWatchInNotExistingTenantUnauthorized() throws Exception {
        String tenant = "schnickschnack";
        String watchId = "get_watch_unauth";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get(watchPath, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void testGetWatchInNonDefaultTenantUnauthorized() throws Exception {
        String tenant = "redshirt_club";
        String watchId = "get_watch_unauth";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get(watchPath, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void testPutWatch() throws Exception {
        String tenant = "_main";
        String watchId = "put_test";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]).trackResources();){
            Client client = cluster.getInternalNodeClient();
            client.admin().indices().create(new CreateIndexRequest("testsink_put_watch")).actionGet();
            Watch watch = new WatchBuilder(watchId).cronTrigger("* * * * * ?").search("testsource").query("{\"match_all\" : {} }").as("testsearch").put("{\"bla\": {\"blub\": 42}}").as("teststatic").then().index("testsink_put_watch").name("testsink").build();
            GenericRestClient.HttpResponse response = restClient.putJson(watchPath, watch.toJson(), new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            response = restClient.get(watchPath, new Header[0]);
            System.out.print(response.getBody());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            watch = Watch.parseFromElasticDocument((WatchInitializationService)this.watchInitializationService, (String)"test", (String)"put_test", (String)response.getBody(), (long)-1L);
            this.awaitMinCountOfDocuments(client, "testsink_put_watch", 1L);
        }
    }

    @Test
    public void testPutWatchInNonExistingTenant() throws Exception {
        String tenant = "schnickschnack";
        String watchId = "put_test_non_existing_tenant";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]).trackResources();){
            Watch watch = new WatchBuilder(watchId).cronTrigger("* * * * * ?").search("testsource").query("{\"match_all\" : {} }").as("testsearch").put("{\"bla\": {\"blub\": 42}}").as("teststatic").then().index("testsink_put_watch").name("testsink").build();
            GenericRestClient.HttpResponse response = restClient.putJson(watchPath, watch.toJson(), new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void endpointsSupportingTenantParameterShouldNotAcceptPrivateTenant() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = restClient.get("/_signals/watch/__user__/_search", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.get("/_signals/watch/_main/_search", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.get("/_signals/watch/__user__/1", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.get("/_signals/watch/_main/1", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.post("/_signals/watch/__user__/_search");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.post("/_signals/watch/_main/_search");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.post("/_signals/watch/__user__/1/_execute");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.post("/_signals/watch/_main/1/_execute");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.put("/_signals/tenant/__user__/_active");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.put("/_signals/tenant/_main/_active");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.put("/_signals/watch/__user__/1/_ack_and_get");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.put("/_signals/watch/_main/1/_ack_and_get");
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.delete("/_signals/watch/__user__/1", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.delete("/_signals/watch/_main/1", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
            response = restClient.delete("/_signals/watch/__user__/1/_ack/1", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants"));
            response = restClient.delete("/_signals/watch/_main/1/_ack/1", new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"error.message", (Object)"Signals does not support private tenants")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchLogContainsDocumentWithHugeFieldCountAndFieldsAreNotSearchable() throws Exception {
        String tenant = "_main";
        String watchId = "watch_which_creates_huge_logs";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        String testSink = "testsink_" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]).trackResources();){
            Client client = cluster.getInternalNodeClient();
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(HUGE_DOCUMENT_INDEX).settings(Settings.builder().put("mapping.total_fields.limit", 3000).build());
            client.admin().indices().create(createIndexRequest).actionGet();
            Object[] hugeDocument = new String[1940];
            for (int i = 0; i < hugeDocument.length; i += 2) {
                hugeDocument[i] = "key_" + i;
                hugeDocument[i + 1] = "value_" + i;
            }
            client.index(((IndexRequest)new IndexRequest(HUGE_DOCUMENT_INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, hugeDocument)).actionGet();
            try {
                client.admin().indices().delete(new DeleteIndexRequest(SIGNALS_LOGS_INDEX_NAME)).actionGet();
            }
            catch (IndexNotFoundException i) {
                // empty catch block
            }
            client.admin().indices().create(new CreateIndexRequest(testSink).settings(Settings.builder().put("mapping.total_fields.limit", 3000).build())).actionGet();
            Watch watch = new WatchBuilder(watchId).logRuntimeData(true).atMsInterval(100L).search(HUGE_DOCUMENT_INDEX).query("{\"match_all\" : {} }").as("testsearch").put("{\"bla\": {\"blub\": 42}}").as("teststatic").then().index(testSink).throttledFor("1000h").name("testsink").build();
            GenericRestClient.HttpResponse response = restClient.putJson(watchPath, (ToXContentObject)watch);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            long watchVersion = Long.parseLong(response.getBodyAsDocNode().getAsString("_version"));
            List<WatchLog> watchLogs = new WatchLogSearch(client).index(SIGNALS_LOGS_INDEX_NAME).watchId(watchId).watchVersion(watchVersion).fromTheStart().count(1).await();
            int watchSearchResultsCount = ((DocNode)DocNode.wrap((Object)watchLogs.get(0).getData()).getAsNode("testsearch").getAsNode("hits").getAsListOfNodes("hits").get(0)).getAsNode("_source").size();
            MatcherAssert.assertThat((Object)watchSearchResultsCount, (Matcher)Matchers.equalTo((Object)970));
            TermQueryBuilder queryBuilder = QueryBuilders.termQuery((String)"data.testsearch.hits.hits._source.key_418.keyword", (String)"value_418");
            SearchResponse searchResponse = (SearchResponse)client.search(new SearchRequest(new String[]{SIGNALS_LOGS_INDEX_NAME}).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder).size(1))).actionGet();
            try {
                MatcherAssert.assertThat((Object)searchResponse.getHits().getHits(), (Matcher)Matchers.arrayWithSize((int)0));
            }
            finally {
                searchResponse.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCountOfDocuments(Client client, String index) throws InterruptedException, ExecutionException {
        SearchRequest request = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        request.source(searchSourceBuilder);
        SearchResponse response = (SearchResponse)client.search(request).get();
        try {
            long l = response.getHits().getTotalHits().value();
            return l;
        }
        finally {
            response.decRef();
        }
    }

    private long awaitMinCountOfDocuments(Client client, String index, long minCount) throws Exception {
        return (Long)Awaitility.await((String)String.format("Number of documents in index %s >= %d", index, minCount)).atMost(Duration.ofSeconds(10L)).pollInterval(Duration.ofMillis(10L)).until(() -> this.getCountOfDocuments(client, index), Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(minCount)));
    }

    static {
        cluster = new LocalCluster.Builder().singleNode().sslEnabled().resources("sg_config/signals-no-mt").nodeSettings(new Object[]{"signals.enabled", true, "searchguard.enterprise_modules_enabled", false, "signals.index_names.log", SIGNALS_LOGS_INDEX_NAME, "signals.watch_log.mapping_total_fields_limit", -1}).enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

