/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.result;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.watch.result.ActionLog;
import com.floragunn.signals.watch.result.ErrorInfo;
import com.floragunn.signals.watch.result.Status;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class WatchLog
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(WatchLog.class);
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    private String id;
    private String tenant;
    private String watchId;
    private long watchVersion = -1L;
    private Status status;
    private Date executionStart;
    private Date executionFinished;
    private ErrorInfo error;
    private String node;
    private Map<String, Object> data;
    private WatchExecutionContextData runtimeAttributes;
    private List<ActionLog> actions;
    private List<ActionLog> resolveActions;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWatchId() {
        return this.watchId;
    }

    public void setWatchId(String watchId) {
        this.watchId = watchId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public Date getExecutionStart() {
        return this.executionStart;
    }

    public void setExecutionStart(Date executionStart) {
        this.executionStart = executionStart;
    }

    public Date getExecutionFinished() {
        return this.executionFinished;
    }

    public void setExecutionFinished(Date executionFinished) {
        this.executionFinished = executionFinished;
    }

    public List<ActionLog> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionLog> actions) {
        this.actions = actions;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("tenant", this.tenant);
        builder.field("watch_id", this.watchId);
        if (this.watchVersion > 0L) {
            builder.field("watch_version", this.watchVersion);
        }
        builder.field("status", (ToXContent)this.status);
        if (this.error != null) {
            builder.field("error", (ToXContent)this.error);
        }
        builder.field("execution_start", this.executionStart != null ? DATE_FORMATTER.format((TemporalAccessor)this.executionStart.toInstant()) : null);
        builder.field("execution_end", this.executionFinished != null ? DATE_FORMATTER.format((TemporalAccessor)this.executionFinished.toInstant()) : null);
        if (params.paramAsBoolean(ToXContentParams.INCLUDE_DATA.name(), false)) {
            builder.field("data", this.data);
        }
        if (params.paramAsBoolean(ToXContentParams.INCLUDE_RUNTIME_ATTRIBUTES.name(), false)) {
            builder.field("runtime_attributes", (ToXContent)this.runtimeAttributes);
        }
        builder.startArray("actions");
        for (ActionLog actionLog : this.actions) {
            actionLog.toXContent(builder, params);
        }
        builder.endArray();
        if (this.resolveActions != null && this.resolveActions.size() > 0) {
            builder.startArray("resolve_actions");
            for (ActionLog actionLog : this.resolveActions) {
                actionLog.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.node != null) {
            builder.field("node", this.node);
        }
        builder.endObject();
        return builder;
    }

    public static WatchLog parse(String id, String json) throws ParseException {
        try {
            return WatchLog.parse(id, DocNode.parse((Format)Format.JSON).from(json));
        }
        catch (DocumentParseException e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    public static WatchLog parse(String id, DocNode jsonNode) throws ParseException {
        WatchLog result = new WatchLog();
        result.id = id;
        if (jsonNode.hasNonNull("tenant")) {
            result.tenant = jsonNode.getAsString("tenant");
        }
        if (jsonNode.hasNonNull("watch_id")) {
            result.watchId = jsonNode.getAsString("watch_id");
        }
        if (jsonNode.hasNonNull("watch_version")) {
            try {
                result.watchVersion = jsonNode.getNumber("watch_version").longValue();
            }
            catch (ConfigValidationException e) {
                log.error("Error while parsing " + String.valueOf(jsonNode), (Throwable)e);
            }
        }
        if (jsonNode.hasNonNull("status")) {
            result.status = Status.parse(jsonNode.getAsNode("status"));
        }
        if (jsonNode.hasNonNull("execution_start")) {
            result.executionStart = Date.from(Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("execution_start"))));
        }
        if (jsonNode.hasNonNull("execution_end")) {
            result.executionFinished = Date.from(Instant.from(DATE_FORMATTER.parse(jsonNode.getAsString("execution_end"))));
        }
        if (jsonNode.hasNonNull("data")) {
            result.data = jsonNode.getAsNode("data").toMap();
        }
        if (jsonNode.hasNonNull("runtime_attributes")) {
            result.runtimeAttributes = WatchExecutionContextData.create(jsonNode.getAsNode("runtime_attributes"));
        }
        if (jsonNode.hasNonNull("actions") && jsonNode.get("actions") instanceof Collection) {
            result.actions = ActionLog.parseList((Collection)jsonNode.get("actions"));
        }
        if (jsonNode.hasNonNull("resolve_actions") && jsonNode.get("resolve_actions") instanceof Collection) {
            result.resolveActions = ActionLog.parseList((Collection)jsonNode.get("resolve_actions"));
        }
        if (jsonNode.hasNonNull("node")) {
            result.node = jsonNode.getAsString("node");
        }
        return result;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }

    public List<ActionLog> getResolveActions() {
        return this.resolveActions;
    }

    public void setResolveActions(List<ActionLog> resolveActions) {
        this.resolveActions = resolveActions;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public WatchExecutionContextData getRuntimeAttributes() {
        return this.runtimeAttributes;
    }

    public void setRuntimeAttributes(WatchExecutionContextData runtimeAttributes) {
        this.runtimeAttributes = runtimeAttributes;
    }

    public long getWatchVersion() {
        return this.watchVersion;
    }

    public void setWatchVersion(long watchVersion) {
        this.watchVersion = watchVersion;
    }

    public static enum ToXContentParams {
        INCLUDE_DATA,
        INCLUDE_RUNTIME_ATTRIBUTES;

    }
}

