/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.invokers;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.script.types.SignalsObjectFunctionScript;
import com.floragunn.signals.support.InlinePainlessScript;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;

public abstract class ActionInvoker
implements ToXContent {
    protected final String name;
    protected final ActionHandler handler;
    protected final List<Check> checks;
    protected final InlinePainlessScript<SignalsObjectFunctionScript.Factory> foreach;
    protected final int foreachLimit;

    protected ActionInvoker(String name, ActionHandler handler, List<Check> checks, InlinePainlessScript<SignalsObjectFunctionScript.Factory> foreach, Integer foreachLimit) {
        this.name = name;
        this.handler = handler;
        this.checks = checks != null ? Collections.unmodifiableList(checks) : null;
        this.foreach = foreach;
        this.foreachLimit = foreachLimit != null ? foreachLimit : 100;
    }

    public String getName() {
        return this.name;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public String toString() {
        return this.handler != null ? this.handler.getClass().getSimpleName() + " " + this.name : this.name;
    }

    public ActionExecutionResult execute(WatchExecutionContext ctx) throws ActionExecutionException {
        return this.handler.execute(ctx);
    }

    public String toJson() {
        return Strings.toString((ToXContent)this);
    }

    protected static List<Check> createNestedChecks(WatchInitializationService watchInitService, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) {
        if (vJsonNode.hasNonNull("checks")) {
            if (vJsonNode.getDocumentNode().get("checks") instanceof List) {
                try {
                    return Check.create(watchInitService, (List)vJsonNode.getDocumentNode().get("checks"));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("checks", e);
                }
            } else {
                validationErrors.add((ValidationError)new InvalidAttributeValue("checks", (Object)vJsonNode.get("checks"), (Object)"Array", (Object)vJsonNode));
            }
        }
        return Collections.emptyList();
    }

    public ActionHandler getHandler() {
        return this.handler;
    }

    public InlinePainlessScript<SignalsObjectFunctionScript.Factory> getForeach() {
        return this.foreach;
    }

    public int getForeachLimit() {
        return this.foreachLimit;
    }
}

