/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.searchguard.support.WildcardMatcher;
import java.net.URI;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpEndpointWhitelist {
    private static final Logger log = LogManager.getLogger(HttpEndpointWhitelist.class);
    private final List<String> whitelist;

    public HttpEndpointWhitelist(List<String> whitelist) {
        this.whitelist = whitelist;
    }

    public void check(URI uri) throws NotWhitelistedException {
        String uriAsString = uri.toString();
        if (log.isDebugEnabled()) {
            log.debug("Checking " + String.valueOf(uri) + " against " + String.valueOf(this.whitelist));
        }
        for (String entry : this.whitelist) {
            if (!WildcardMatcher.match((String)entry, (String)uriAsString)) continue;
            return;
        }
        throw new NotWhitelistedException(uri);
    }

    public static class NotWhitelistedException
    extends Exception {
        private static final long serialVersionUID = 5274286136737656655L;

        public NotWhitelistedException(URI uri) {
            super("The URI is not whitelisted: " + String.valueOf(uri));
        }
    }
}

