/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.ackandget;

import java.io.IOException;
import java.time.Instant;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class Acknowledgement {
    private final Instant acknowledgeTime;
    private final String acknowledgeByUser;
    private final String actionId;

    public Acknowledgement(Instant acknowledgeTime, String acknowledgeByUser, String actionId) {
        this.acknowledgeTime = acknowledgeTime;
        this.acknowledgeByUser = acknowledgeByUser;
        this.actionId = actionId;
    }

    public Instant getAcknowledgeTime() {
        return this.acknowledgeTime;
    }

    public String getAcknowledgeByUser() {
        return this.acknowledgeByUser;
    }

    public String getActionId() {
        return this.actionId;
    }

    static class AcknowledgementReader
    implements Writeable.Reader<Acknowledgement> {
        AcknowledgementReader() {
        }

        public Acknowledgement read(StreamInput stream) throws IOException {
            return new Acknowledgement(stream.readInstant(), stream.readString(), stream.readString());
        }
    }

    static class AcknowledgementWriter
    implements Writeable.Writer<Acknowledgement> {
        AcknowledgementWriter() {
        }

        public void write(StreamOutput stream, Acknowledgement acknowledgement) throws IOException {
            stream.writeInstant(acknowledgement.getAcknowledgeTime());
            stream.writeString(acknowledgement.getAcknowledgeByUser());
            stream.writeString(acknowledgement.getActionId());
        }
    }
}

