/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.util;

import com.floragunn.signals.watch.result.WatchLog;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class WatchLogSearch {
    private static final Logger log = LogManager.getLogger(WatchLogSearch.class);
    private Client client;
    private String watchId;
    private Long watchVersion;
    private String tenantName = "_main";
    private String index = null;
    private int count = 1;
    private SortOrder searchSortOrder = SortOrder.DESC;
    private SortOrder resultSortOrder = SortOrder.ASC;
    private Duration timeout = Duration.ofSeconds(10L);

    public WatchLogSearch(Client client) {
        this.client = client;
    }

    public WatchLogSearch watchId(String watchId) {
        this.watchId = watchId;
        return this;
    }

    public WatchLogSearch watchVersion(long watchVersion) {
        this.watchVersion = watchVersion;
        return this;
    }

    public WatchLogSearch tenant(String tenant) {
        this.tenantName = tenant;
        return this;
    }

    public WatchLogSearch index(String index) {
        this.index = index;
        return this;
    }

    public WatchLogSearch count(int count) {
        this.count = count;
        return this;
    }

    public WatchLogSearch toTheEnd() {
        this.searchSortOrder = SortOrder.DESC;
        this.resultSortOrder = SortOrder.ASC;
        return this;
    }

    public WatchLogSearch fromTheStart() {
        this.searchSortOrder = SortOrder.ASC;
        this.resultSortOrder = SortOrder.ASC;
        return this;
    }

    public WatchLogSearch timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WatchLog> peek() {
        try {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            if (this.watchId != null) {
                queryBuilder = queryBuilder.must((QueryBuilder)new TermQueryBuilder("watch_id", this.watchId));
            }
            if (this.watchVersion != null) {
                queryBuilder = queryBuilder.must((QueryBuilder)new TermQueryBuilder("watch_version", (Object)this.watchVersion));
            }
            if (this.tenantName != null) {
                queryBuilder = queryBuilder.must((QueryBuilder)new TermQueryBuilder("tenant", this.tenantName));
            }
            SearchResponse searchResponse = (SearchResponse)this.client.search(new SearchRequest(new String[]{this.index}).source(new SearchSourceBuilder().size(0).query((QueryBuilder)queryBuilder).sort("execution_end", this.resultSortOrder).aggregation((AggregationBuilder)AggregationBuilders.topHits((String)"execution_end").sort("execution_end", this.searchSortOrder).size(this.count)))).actionGet();
            try {
                if (searchResponse.getAggregations() == null) {
                    List<WatchLog> list = Collections.emptyList();
                    return list;
                }
                TopHits topHits = (TopHits)searchResponse.getAggregations().get("execution_end");
                SearchHit[] result = new ArrayList(this.count);
                if (topHits != null) {
                    for (SearchHit searchHit : topHits.getHits().getHits()) {
                        result.add(WatchLog.parse((String)searchHit.getId(), (String)searchHit.getSourceAsString()));
                    }
                }
                SearchHit[] searchHitArray = result;
                return searchHitArray;
            }
            finally {
                searchResponse.decRef();
            }
        }
        catch (SearchPhaseExecutionException | IndexNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in getMostRecenWatchLog(" + this.tenantName + ", " + this.watchId + ")", e);
        }
    }

    public WatchLog awaitSingle() {
        List<WatchLog> result = this.await(this.timeout);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<WatchLog> await() {
        return this.await(this.timeout);
    }

    public List<WatchLog> await(Duration timeout) {
        try {
            long start = System.currentTimeMillis();
            long end = start + timeout.toMillis();
            Throwable indexNotFoundException = null;
            long lastDebugLog = start;
            while (System.currentTimeMillis() < end) {
                try {
                    List<WatchLog> watchLogs = this.peek();
                    if (watchLogs.size() == this.count) {
                        log.info("Found " + String.valueOf(watchLogs) + " for " + this.watchId + " after " + (System.currentTimeMillis() - start) + " ms");
                        return watchLogs;
                    }
                    if (lastDebugLog < System.currentTimeMillis() - 1000L) {
                        log.debug("Still waiting for watch logs; found so far: " + String.valueOf(watchLogs));
                        lastDebugLog = System.currentTimeMillis();
                    }
                    indexNotFoundException = null;
                }
                catch (SearchPhaseExecutionException | IndexNotFoundException e) {
                    indexNotFoundException = e;
                }
                Thread.sleep(10L);
            }
            if (indexNotFoundException != null) {
                log.warn("Did not find watch log index for " + this.watchId + " after " + (System.currentTimeMillis() - start) + " ms: ", indexNotFoundException);
            } else {
                log.warn("Did not find watch log for " + this.watchId + " after " + (System.currentTimeMillis() - start) + " ms\n\n" + String.valueOf(this.peek()));
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            log.error("Exception in awaitWatchLog for " + this.watchId + ")", (Throwable)e);
            throw new RuntimeException("Exception in awaitWatchLog for " + this.watchId + ")", e);
        }
    }
}

