/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.handlers.email;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.signals.accounts.NoSuchAccountException;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionException;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.action.handlers.email.EmailAccount;
import com.floragunn.signals.watch.action.handlers.email.SignalsMailer;
import com.floragunn.signals.watch.common.HttpClient;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.HttpUtils;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.init.WatchInitializationService;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.email.EmailBuilder;

public class EmailAction
extends ActionHandler {
    public static final String TYPE = "email";
    private static final Logger log = LogManager.getLogger(EmailAction.class);
    private String account;
    private String subject;
    private String from;
    private String body;
    private String htmlBody;
    private List<String> to;
    private List<String> cc;
    private List<String> bcc;
    private String replyTo;
    private Map<String, Attachment> attachments = new LinkedHashMap<String, Attachment>();
    private TemplateScript.Factory fromScript;
    private List<TemplateScript.Factory> toScript;
    private List<TemplateScript.Factory> ccScript;
    private List<TemplateScript.Factory> bccScript;
    private TemplateScript.Factory subjectScript;
    private TemplateScript.Factory bodyScript;
    private TemplateScript.Factory htmlBodyScript;
    private TemplateScript.Factory replyToScript;

    public void compileScripts(WatchInitializationService watchInitService) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        this.fromScript = watchInitService.compileTemplate("from", this.from, validationErrors);
        this.subjectScript = watchInitService.compileTemplate("subject", this.subject, validationErrors);
        this.bodyScript = watchInitService.compileTemplate("body", this.body, validationErrors);
        this.htmlBodyScript = watchInitService.compileTemplate("html_body", this.htmlBody, validationErrors);
        this.toScript = watchInitService.compileTemplates("to", this.to, validationErrors);
        this.ccScript = watchInitService.compileTemplates("cc", this.cc, validationErrors);
        this.bccScript = watchInitService.compileTemplates("bcc", this.bcc, validationErrors);
        this.replyToScript = watchInitService.compileTemplate("reply_to", this.replyTo, validationErrors);
        if (Objects.isNull(this.htmlBody) && Objects.isNull(this.body)) {
            validationErrors.add(new ValidationError("body", "Both body and html_body are empty"));
        }
        validationErrors.throwExceptionForPresentErrors();
    }

    @Override
    public ActionExecutionResult execute(WatchExecutionContext ctx) throws ActionExecutionException {
        try {
            String destinationId = this.getAccount();
            EmailAccount destination = ctx.getAccountRegistry().lookupAccount(destinationId, EmailAccount.class);
            Email email = this.renderMail(ctx, destination);
            SignalsMailer sm = new SignalsMailer(destination);
            if (ctx.getSimulationMode() == SimulationMode.FOR_REAL) {
                sm.sendMail(email);
            }
            return new ActionExecutionResult(EmailAction.mailToDebugString(email));
        }
        catch (NoSuchAccountException e) {
            throw new ActionExecutionException((ActionHandler)this, (Throwable)e);
        }
        catch (MailException e) {
            throw new ActionExecutionException((ActionHandler)this, "Error while sending mail: " + e.getMessage(), e);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Email renderMail(WatchExecutionContext ctx, EmailAccount destination) throws ActionExecutionException {
        try {
            EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
            if (this.fromScript != null) {
                emailBuilder.from(this.emailToInternetAddress(this.render(ctx, this.fromScript)));
            } else if (destination.getDefaultFrom() != null) {
                emailBuilder.from(this.emailToInternetAddress(destination.getDefaultFrom()));
            } else {
                throw new ActionExecutionException((ActionHandler)this, "No from address defined in destination " + String.valueOf(destination));
            }
            if (this.toScript != null) {
                emailBuilder.toMultipleAddresses(this.emailsToInternetAddresses(this.render(ctx, this.toScript)));
            } else if (destination.getDefaultTo() != null) {
                emailBuilder.toMultipleAddresses(this.emailsToInternetAddresses(destination.getDefaultTo()));
            }
            if (this.ccScript != null) {
                emailBuilder.ccMultipleAddresses(this.emailsToInternetAddresses(this.render(ctx, this.ccScript)));
            } else if (destination.getDefaultCc() != null) {
                emailBuilder.ccMultipleAddresses(this.emailsToInternetAddresses(destination.getDefaultCc()));
            }
            if (this.bccScript != null) {
                emailBuilder.bccMultipleAddresses(this.emailsToInternetAddresses(this.render(ctx, this.bccScript)));
            } else if (destination.getDefaultCc() != null) {
                emailBuilder.bccMultipleAddresses(this.emailsToInternetAddresses(destination.getDefaultBcc()));
            }
            if (this.replyToScript != null) {
                emailBuilder.withReplyTo(this.emailToInternetAddress(this.render(ctx, this.replyToScript)));
            }
            emailBuilder.withSubject(this.render(ctx, this.subjectScript));
            emailBuilder.withPlainText(this.render(ctx, this.bodyScript));
            emailBuilder.withHTMLText(this.render(ctx, this.htmlBodyScript));
            List<Map.Entry<String, Attachment>> contexts = this.getAttachments(Attachment.AttachmentType.RUNTIME);
            for (Map.Entry<String, Attachment> context : contexts) {
                String fileName = context.getKey();
                String json = ctx.getContextData().getData().toJsonString();
                if (json == null) continue;
                emailBuilder.withAttachment(fileName, json.getBytes(StandardCharsets.UTF_8), "application/json");
            }
            List<Map.Entry<String, Attachment>> requests = this.getAttachments(Attachment.AttachmentType.REQUEST);
            for (Map.Entry<String, Attachment> r : requests) {
                String fileName = r.getKey();
                Attachment attachment = r.getValue();
                if (attachment == null || attachment.httpClientConfig == null || attachment.requestConfig == null) continue;
                HttpClient httpClient = attachment.httpClientConfig.createHttpClient(ctx.getHttpProxyConfig());
                try {
                    CloseableHttpResponse response;
                    HttpUriRequest request = attachment.requestConfig.createHttpRequest(ctx);
                    if (log.isDebugEnabled()) {
                        log.debug("Going to execute: " + String.valueOf(request));
                    }
                    if ((response = AccessController.doPrivileged(() -> httpClient.execute(request))).getStatusLine().getStatusCode() >= 400) {
                        throw new WatchExecutionException("HTTP request returned error: " + String.valueOf(response.getStatusLine()) + "\n\n" + HttpUtils.getEntityAsDebugString((HttpResponse)response), null);
                    }
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        response.getEntity().writeTo((OutputStream)baos);
                        String contentType = response.getEntity().getContentType().getValue();
                        emailBuilder.withAttachment(fileName, baos.toByteArray(), contentType);
                    }
                }
                finally {
                    if (httpClient == null) continue;
                    httpClient.close();
                }
            }
            return emailBuilder.buildEmail();
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionExecutionException((ActionHandler)this, "Error while rendering mail: " + e.getMessage(), e);
        }
    }

    private List<Map.Entry<String, Attachment>> getAttachments(Attachment.AttachmentType type) {
        ArrayList<Map.Entry<String, Attachment>> result = new ArrayList<Map.Entry<String, Attachment>>();
        if (this.getAttachments() != null) {
            for (Map.Entry<String, Attachment> entry : this.getAttachments().entrySet()) {
                if (Strings.isNullOrEmpty((String)entry.getKey()) || entry.getValue() == null || type != entry.getValue().getType()) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.account != null) {
            builder.field("account", this.account);
        }
        if (this.to != null) {
            builder.field("to", this.to);
        }
        if (this.from != null) {
            builder.field("from", this.from);
        }
        if (this.cc != null) {
            builder.field("cc", this.cc);
        }
        if (this.bcc != null) {
            builder.field("bcc", this.bcc);
        }
        if (this.replyTo != null) {
            builder.field("reply_to", this.replyTo);
        }
        builder.field("subject", this.subject);
        if (this.body != null) {
            builder.field("text_body", this.body);
        }
        if (this.htmlBody != null) {
            builder.field("html_body", this.htmlBody);
        }
        if (this.attachments != null && this.attachments.size() > 0) {
            builder.field("attachments", this.attachments);
        }
        return builder;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, Attachment> attachments) {
        this.attachments = attachments;
    }

    private static String mailToDebugString(Email email) {
        try {
            MimeMessage message = EmailAction.mailToMimeMessage(email);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            message.writeTo((OutputStream)os);
            return os.toString("UTF-8");
        }
        catch (Exception e) {
            log.error("Error while rendering mail: ", (Throwable)e);
            return null;
        }
    }

    private static MimeMessage mailToMimeMessage(Email email) throws MessagingException {
        try {
            Address[] addresses;
            MimeMessage message = new MimeMessage((Session)null);
            message.setSubject(email.getSubject(), "UTF-8");
            message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), "UTF-8"));
            List replyToRecipients = email.getReplyToRecipients();
            if (replyToRecipients != null && (addresses = (Address[])replyToRecipients.stream().filter(Objects::nonNull).flatMap(r -> Arrays.stream(EmailAction.toInternetAddressArray(r))).toArray(Address[]::new)).length > 0) {
                message.setReplyTo(addresses);
            }
            if (email.getRecipients() != null) {
                for (Recipient recipient : email.getRecipients()) {
                    message.setRecipient(recipient.getType(), EmailAction.toInternetAddress(recipient));
                }
            }
            if (email.getPlainText() != null && email.getHTMLText() != null) {
                MimeMultipart multipart = new MimeMultipart("alternative");
                MimeBodyPart plainMessagePart = new MimeBodyPart();
                plainMessagePart.setText(email.getPlainText(), "utf-8");
                multipart.addBodyPart((BodyPart)plainMessagePart);
                MimeBodyPart htmlMessagePart = new MimeBodyPart();
                htmlMessagePart.setContent((Object)email.getHTMLText(), "text/html; charset=\"utf-8\"");
                multipart.addBodyPart((BodyPart)htmlMessagePart);
                message.setContent((Multipart)multipart);
            } else if (email.getHTMLText() != null) {
                message.setContent((Object)email.getHTMLText(), "text/html; charset=\"utf-8\"");
            } else if (email.getPlainText() != null) {
                message.setText(email.getPlainText());
            } else {
                message.setText("");
            }
            message.setSentDate(new Date());
            return message;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private InternetAddress emailToInternetAddress(String emailWithDisplayName) throws ActionExecutionException {
        try {
            return new InternetAddress(emailWithDisplayName, true);
        }
        catch (AddressException e) {
            throw new ActionExecutionException((ActionHandler)this, "Error while parsing email: " + emailWithDisplayName + ", cause: " + e.getMessage(), e);
        }
    }

    private List<InternetAddress> emailsToInternetAddresses(List<String> emailWithDisplayName) throws ActionExecutionException {
        ArrayList<InternetAddress> internedAddresses = new ArrayList<InternetAddress>(emailWithDisplayName.size());
        for (String namedEmail : emailWithDisplayName) {
            internedAddresses.add(this.emailToInternetAddress(namedEmail));
        }
        return internedAddresses;
    }

    private static Address[] toInternetAddressArray(Recipient recipient) {
        try {
            if (recipient != null) {
                return new Address[]{new InternetAddress(recipient.getAddress(), recipient.getName(), "UTF-8")};
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Address toInternetAddress(Recipient recipient) {
        try {
            if (recipient != null) {
                return new InternetAddress(recipient.getAddress(), recipient.getName(), "UTF-8");
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public static class Attachment
    implements ToXContentObject {
        private AttachmentType type;
        private HttpRequestConfig requestConfig;
        private HttpClientConfig httpClientConfig;

        public HttpClientConfig getHttpClientConfig() {
            return this.httpClientConfig;
        }

        public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
            this.httpClientConfig = httpClientConfig;
        }

        public HttpRequestConfig getRequestConfig() {
            return this.requestConfig;
        }

        public void setRequestConfig(HttpRequestConfig requestConfig) {
            this.requestConfig = requestConfig;
        }

        public AttachmentType getType() {
            return this.type;
        }

        public void setType(AttachmentType type) {
            this.type = type;
        }

        static Map<String, Attachment> create(DocNode objectNode, WatchInitializationService watchInitService, ValidationErrors validationErrors) {
            HashMap<String, Attachment> result = new HashMap<String, Attachment>();
            for (Map.Entry entry : objectNode.entrySet()) {
                ValidatingDocNode element = new ValidatingDocNode(DocNode.wrap(entry.getValue()), validationErrors);
                Attachment attachment = new Attachment();
                if (element.hasNonNull("type")) {
                    Optional<AttachmentType> type = AttachmentType.of(element.get("type").asString());
                    type.ifPresent(t -> {
                        attachment.setType((AttachmentType)((Object)t));
                        if (t == AttachmentType.REQUEST && element.hasNonNull("request")) {
                            try {
                                HttpClientConfig httpClientConfig = HttpClientConfig.create(element, watchInitService.getTrustManagerRegistry(), watchInitService.getHttpProxyHostRegistry(), ValidationLevel.STRICT);
                                attachment.setHttpClientConfig(httpClientConfig);
                            }
                            catch (ConfigValidationException e) {
                                validationErrors.add(null, e);
                            }
                            try {
                                HttpRequestConfig requestConfig = HttpRequestConfig.create(watchInitService, element.getDocumentNode().getAsNode("request"));
                                attachment.setRequestConfig(requestConfig);
                            }
                            catch (ConfigValidationException e) {
                                validationErrors.add("request", e);
                            }
                        }
                    });
                }
                result.put((String)entry.getKey(), attachment);
            }
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", (Enum)this.type);
            if (this.type == AttachmentType.REQUEST) {
                builder.field("request", (ToXContent)this.requestConfig);
                if (this.httpClientConfig != null) {
                    this.httpClientConfig.toXContent(builder, params);
                }
            }
            builder.endObject();
            return builder;
        }

        public static enum AttachmentType {
            REQUEST("request"),
            RUNTIME("runtime");

            private final String type;

            private AttachmentType(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }

            public static Optional<AttachmentType> of(String t) {
                switch (t.toLowerCase()) {
                    case "request": {
                        return Optional.of(REQUEST);
                    }
                    case "runtime": {
                        return Optional.of(RUNTIME);
                    }
                }
                return Optional.empty();
            }
        }
    }

    public static class Factory
    extends ActionHandler.Factory<EmailAction> {
        public Factory() {
            super(EmailAction.TYPE);
        }

        @Override
        protected EmailAction create(WatchInitializationService watchInitService, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) throws ConfigValidationException {
            ImmutableList to = vJsonNode.get("to").asListOfStrings();
            ImmutableList cc = vJsonNode.get("cc").asListOfStrings();
            ImmutableList bcc = vJsonNode.get("bcc").asListOfStrings();
            String subject = vJsonNode.get("subject").required().asString();
            String account = vJsonNode.get("account").asString();
            String replyTo = vJsonNode.get("reply_to").asString();
            watchInitService.verifyAccount(account, EmailAccount.class, validationErrors, vJsonNode.getDocumentNode());
            String body = vJsonNode.get("text_body").required().asString();
            String htmlBody = vJsonNode.get("html_body").asString();
            String from = vJsonNode.get("from").asString();
            Map<String, Attachment> attachments = Collections.emptyMap();
            if (vJsonNode.hasNonNull("attachments") && vJsonNode.getDocumentNode().get("attachments") instanceof Map) {
                attachments = Attachment.create(vJsonNode.getDocumentNode().getAsNode("attachments"), watchInitService, validationErrors);
            }
            validationErrors.throwExceptionForPresentErrors();
            EmailAction result = new EmailAction();
            result.setAccount(account);
            result.setTo((List<String>)to);
            result.setCc((List<String>)cc);
            result.setBcc((List<String>)bcc);
            result.setBody(body);
            result.setHtmlBody(htmlBody);
            result.setSubject(subject);
            result.setFrom(from);
            result.setAttachments(attachments);
            result.setReplyTo(replyTo);
            result.compileScripts(watchInitService);
            return result;
        }
    }
}

