/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common.throttle;

import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.watch.common.throttle.ThrottlePeriodParser;
import java.time.Duration;

public class ValidatingThrottlePeriodParser
extends ThrottlePeriodParser {
    public ValidatingThrottlePeriodParser(SignalsSettings signalsSettings) {
        super(signalsSettings);
    }

    @Override
    public DurationExpression parseThrottle(String throttle) throws ConfigValidationException {
        DurationExpression lowerBoundExpression = this.signalsSettings.getThrottlePeriodLowerBound();
        if (throttle == null) {
            return lowerBoundExpression;
        }
        DurationExpression throttleDurationExpression = DurationExpression.parse((String)throttle);
        if (lowerBoundExpression != null) {
            Duration lowerBoundDuration = lowerBoundExpression.getActualDuration(0);
            Duration throttleDuration = throttleDurationExpression.getActualDuration(0);
            if (throttleDuration.compareTo(lowerBoundDuration) < 0) {
                throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)throttle, (Object)String.format("Throttle period: %s longer than configured lower bound: %s", throttleDurationExpression, lowerBoundExpression)));
            }
        }
        return throttleDurationExpression;
    }
}

