/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.result;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.signals.watch.severity.SeverityLevel;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class Status
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(Status.class);
    private Code code;
    private String detail;
    private SeverityLevel severityLevel;

    public Status(Code code, String detail) {
        this.code = code;
        this.detail = detail;
    }

    public Status(Code code, SeverityLevel severityLevel, String detail) {
        this.code = code;
        this.detail = detail;
        this.severityLevel = severityLevel;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("code", (Enum)this.code);
        if (this.severityLevel != null) {
            builder.field("severity", this.severityLevel.toString());
        }
        builder.field("detail", this.detail);
        builder.endObject();
        return builder;
    }

    public String toString() {
        if (this.detail == null && this.severityLevel == null) {
            return String.valueOf((Object)this.code);
        }
        StringBuilder result = new StringBuilder(String.valueOf((Object)this.code));
        if (this.severityLevel != null) {
            if (this.severityLevel == SeverityLevel.NONE) {
                result.append(" [OK]");
            } else {
                result.append(" [").append(this.severityLevel.getId().toUpperCase()).append("]");
            }
        }
        if (this.detail != null) {
            result.append(" ").append(this.detail);
        }
        return result.toString();
    }

    public static Status parse(DocNode jsonNode) {
        Code code = null;
        String detail = null;
        SeverityLevel severityLevel = null;
        if (jsonNode.hasNonNull("code")) {
            code = Code.valueOf(jsonNode.getAsString("code"));
        }
        if (jsonNode.hasNonNull("detail")) {
            detail = jsonNode.getAsString("detail");
        }
        if (jsonNode.hasNonNull("severity")) {
            try {
                severityLevel = SeverityLevel.getById(jsonNode.getAsString("severity"));
            }
            catch (Exception e) {
                log.error("Invalid severity level in " + String.valueOf(jsonNode) + "; ignoring", (Throwable)e);
            }
        }
        return new Status(code, severityLevel, detail);
    }

    public static enum Code {
        EXECUTION_FAILED,
        NO_ACTION,
        ACTION_EXECUTED,
        SIMULATED_ACTION_EXECUTED,
        ACTION_FAILED,
        ACTION_THROTTLED,
        ACKED;

    }
}

