/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.truststore.rest.TruststoreLoader;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.search.SearchHit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;

public class TrustedCertificatesRestActionHandlersAndTruststoreIndexMappingTest {
    private static final Logger log = LogManager.getLogger(TrustedCertificatesRestActionHandlersAndTruststoreIndexMappingTest.class);
    public static final String TRUSTSTORE_ID_1 = "truststore-id-001";
    public static final String TRUSTSTORE_ID_2 = "truststore-id-002";
    public static final String TRUSTSTORE_ID_3 = "truststore-id-003";
    private static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS.withTenantPermission(new String[]{"cluster:admin:searchguard:tenant:signals:*"}).on(new String[]{"SGS_GLOBAL_TENANT"})});
    private static final TestSgConfig.User READONLY_USER = new TestSgConfig.User("readonly_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("read-only-role").indexPermissions(new String[]{"SGS_READ"}).on(new String[]{"*"})});
    private static final TestSgConfig.Role READ_TRUSTSTORES_ROLE = new TestSgConfig.Role("read-truststores-role").clusterPermissions(new String[]{"cluster:admin:searchguard:signals:truststores/findall", "cluster:admin:searchguard:signals:truststores/findone"});
    private static final TestSgConfig.User READ_TRUSTSTORES_USER = new TestSgConfig.User("read-truststores-user").roles(new TestSgConfig.Role[]{READ_TRUSTSTORES_ROLE});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().user(USER_ADMIN).user(READONLY_USER).user(READ_TRUSTSTORES_USER).enableModule(SignalsModule.class).nodeSettings(new Object[]{"signals.enabled", true}).waitForComponents(new String[]{"signals"}).embedded().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void clearData() {
        Client client = cluster.getPrivilegedInternalNodeClient();
        SearchResponse searchResponse = (SearchResponse)client.search(new SearchRequest(new String[]{".signals_truststores"})).actionGet();
        try {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String id = hit.getId();
                client.delete((DeleteRequest)new DeleteRequest(".signals_truststores").id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
                log.info("Document with id '{}' deleted from index '{}'.", (Object)id, (Object)".signals_truststores");
            }
        }
        finally {
            searchResponse.decRef();
        }
    }

    @Test
    public void shouldNotFindTrustStoreWhichDoesNotExist() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores/does-not-exists", new Header[0]);
            log.info("Load one truststore by id response '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)response.getBody(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        }
    }

    @Test
    public void shouldLoadTruststoreById() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_2, "certs/twoCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_3, "certs/oneCert.pem");
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores/truststore-id-001", new Header[0]);
            log.info("Load one truststore by id response '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.certificates", (int)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[0].issuer", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[0].subject", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[1].issuer", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[1].subject", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[2].issuer", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[2].subject", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2"));
        }
    }

    @Test
    public void shouldLoadExactlyTheSamePemFile() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            String genuinePem = TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_2, "certs/threeCerts.pem");
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores/truststore-id-002", new Header[0]);
            log.info("Load one truststore by id response '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            String returnedPem = body.getAsNode("data").getAsString("raw_pem");
            MatcherAssert.assertThat((Object)returnedPem, (Matcher)Matchers.equalTo((Object)genuinePem));
        }
    }

    @Test
    public void shouldGetEmptyTruststoreList() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores", new Header[0]);
            log.info("Get truststore by id '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data", (int)0));
        }
    }

    @Test
    public void shouldGetListWithOneTruststore() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores", new Header[0]);
            log.info("Get all truststores response '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data", (int)1));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data[0].certificates", (int)3));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data[0].certificates[0].issuer", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data[0].certificates[0].subject", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data[0].certificates[1].issuer", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data[0].certificates[1].subject", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data[0].certificates[2].issuer", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2"));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"data[0].certificates[2].subject", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2"));
        }
    }

    @Test
    public void shouldGetListWithMultipleTruststores() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            List<DocNode> truststores = this.saveRandomTruststores(12);
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores", new Header[0]);
            log.info("Get all truststores response '{}'", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            ImmutableList responseData = response.getBodyAsDocNode().getAsListOfNodes("data");
            MatcherAssert.assertThat((Object)responseData, (Matcher)Matchers.hasSize((int)truststores.size()));
            for (int i = 0; i < truststores.size(); ++i) {
                MatcherAssert.assertThat((Object)((DocNode)responseData.get(i)), (Matcher)DocNodeMatchers.containsValue((String)"id", (Object)truststores.get(i).get("id")));
                ImmutableList truststoreCerts = truststores.get(i).getAsListOfNodes("certificates");
                MatcherAssert.assertThat((Object)((DocNode)responseData.get(i)), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"certificates", (int)truststoreCerts.size()));
                for (int j = 0; j < truststoreCerts.size(); ++j) {
                    MatcherAssert.assertThat((Object)((DocNode)responseData.get(i)), (Matcher)DocNodeMatchers.containsValue((String)("certificates[" + j + "].issuer"), (Object)((DocNode)truststoreCerts.get(j)).get("issuer")));
                    MatcherAssert.assertThat((Object)((DocNode)responseData.get(i)), (Matcher)DocNodeMatchers.containsValue((String)("certificates[" + j + "].subject"), (Object)((DocNode)truststoreCerts.get(j)).get("subject")));
                }
            }
        }
    }

    @Test
    public void shouldUploadTruststore() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            String pem = TruststoreLoader.loadCertificates("certs/threeCerts.pem");
            String body = DocNode.of((String)"name", (Object)"my PKI", (String)"pem", (Object)pem).toJsonString();
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/truststore-id-001", body, new Header[0]);
            log.info("Upload truststore status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode bodyAsDocNode = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.name", (Object)"my PKI"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.id", (Object)TRUSTSTORE_ID_1));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.certificates", (int)3));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[0].issuer", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[0].subject", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[1].issuer", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[1].subject", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[2].issuer", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[2].subject", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2"));
        }
    }

    @Test
    public void shouldReplaceTruststore() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            String pem = TruststoreLoader.loadCertificates("certs/oneCert.pem");
            String body = DocNode.of((String)"name", (Object)"my PKI", (String)"pem", (Object)pem).toJsonString();
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/truststore-id-001", body, new Header[0]);
            log.info("Replace truststore status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode bodyAsDocNode = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.name", (Object)"my PKI"));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.id", (Object)TRUSTSTORE_ID_1));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.certificates", (int)1));
            MatcherAssert.assertThat((Object)bodyAsDocNode, (Matcher)DocNodeMatchers.containsValue((String)"data.raw_pem", (Object)pem));
        }
    }

    @Test
    public void shouldUploadExpiredCertificate() throws Exception {
        Date validityStartDate = Date.from(LocalDateTime.of(1999, 1, 1, 12, 0).atZone(ZoneOffset.UTC).toInstant());
        Date validityEndDate = Date.from(LocalDateTime.of(2001, 1, 1, 12, 0).atZone(ZoneOffset.UTC).toInstant());
        String expiredCertificatePem = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard", validityStartDate, validityEndDate).build().getCaCertificate().getCertificateString();
        String name = "I am a little outdated";
        String body = DocNode.of((String)"name", (Object)"I am a little outdated", (String)"pem", (Object)expiredCertificatePem).toJsonString();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/truststore-id-001", body, new Header[0]);
            log.info("Upload truststore status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode responseBody = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"data.name", (Object)"I am a little outdated"));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[0].not_before", (Object)"1999-01-01T12:00:00.000Z"));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"data.certificates[0].not_after", (Object)"2001-01-01T12:00:00.000Z"));
        }
    }

    @Test
    public void shouldValidateCertificatesAndReportErrors() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            String invalidCertificatePem = "-----BEGIN CERTIFICATE-----invalid certificate-----END CERTIFICATE-----";
            String body = DocNode.of((String)"name", (Object)"my PKI", (String)"pem", (Object)invalidCertificatePem).toJsonString();
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/truststore-id-001", body, new Header[0]);
            log.info("Replace truststore status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
        }
    }

    @Test
    public void shouldReturnErrorsOccuredDuringCertificateParsing() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            String body = DocNode.of((String)"name", (Object)"my PKI", (String)"pem", (Object)"this is invalid certificate").toJsonString();
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/truststore-id-001", body, new Header[0]);
            log.info("Replace truststore status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
        }
    }

    @Test
    public void shouldNotDeleteTruststoreIfTruststoreDoesNotExists() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.delete("/_signals/truststores/not-exists", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)response.getBody(), (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
        }
    }

    @Test
    public void shouldNotDeleteTruststoreIfTruststoreIsUsedByWatch() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            String watchPath = "/_signals/watch/_main/webhook_with_truststore";
            String lowerCaseTruststoreId = TRUSTSTORE_ID_1.toLowerCase();
            String upperCaseTruststoreId = TRUSTSTORE_ID_1.toUpperCase();
            TruststoreLoader.storeTruststore(client, lowerCaseTruststoreId, "certs/threeCerts.pem");
            TruststoreLoader.storeTruststore(client, upperCaseTruststoreId, "certs/threeCerts.pem");
            Watch watch = new WatchBuilder("test_with_truststore").cronTrigger("0 0 */1 * * ?").then().postWebhook("http://localhost:3233").truststoreId(lowerCaseTruststoreId).name("webhook").build();
            GenericRestClient.HttpResponse response = client.putJson(watchPath, watch.toJson(), new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            response = client.delete("/_signals/truststores/" + lowerCaseTruststoreId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.error.message", (Object)"The truststore is still in use"));
            response = client.delete("/_signals/truststores/" + upperCaseTruststoreId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.delete(watchPath, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            response = client.delete("/_signals/truststores/" + lowerCaseTruststoreId, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void shouldDeleteExistingTruststore() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_2, "certs/twoCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_3, "certs/oneCert.pem");
            GenericRestClient.HttpResponse response = client.delete("/_signals/truststores/truststore-id-001", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)client.get("/_signals/truststores/truststore-id-001", new Header[0]).getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)client.get("/_signals/truststores/truststore-id-002", new Header[0]).getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)client.get("/_signals/truststores/truststore-id-003", new Header[0]).getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void shouldDeleteAnotherExistingTruststore() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_2, "certs/twoCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_3, "certs/oneCert.pem");
            GenericRestClient.HttpResponse response = client.delete("/_signals/truststores/truststore-id-002", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)client.get("/_signals/truststores/truststore-id-001", new Header[0]).getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)client.get("/_signals/truststores/truststore-id-002", new Header[0]).getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)client.get("/_signals/truststores/truststore-id-003", new Header[0]).getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void shouldNotAccessTruststoreIndexDirectly() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);
             GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_2, "certs/twoCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_3, "certs/oneCert.pem");
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data", (int)3));
            response = client.get("/.signals_truststores/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
            response = adminCertClient.get("/.signals_truststores/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"hits.total.value", (Object)3));
        }
    }

    @Test
    public void shouldNotGetCertificatesWhenUserHasNoRequiredPermission() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_2, "certs/twoCerts.pem");
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_3, "certs/oneCert.pem");
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)READONLY_USER, new Header[0]);
        try {
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void shouldReadOneTruststoreWithReadTruststoresUserAccount() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)READ_TRUSTSTORES_USER, new Header[0]);
        try {
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores/truststore-id-001", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data.certificates", (int)3));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void shouldReadAllTruststoreWithReadTruststoresUserAccount() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            TruststoreLoader.storeTruststore(client, TRUSTSTORE_ID_1, "certs/threeCerts.pem");
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)READ_TRUSTSTORES_USER, new Header[0]);
        try {
            GenericRestClient.HttpResponse response = client.get("/_signals/truststores", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"data[0].certificates", (int)3));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void shouldNotCreateTruststoresWithReadTruststoresUserAccount() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)READ_TRUSTSTORES_USER, new Header[0]);){
            String pem = TruststoreLoader.loadCertificates("certs/threeCerts.pem");
            String body = DocNode.of((String)"name", (Object)"my PKI", (String)"pem", (Object)pem).toJsonString();
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/truststore-id-001", body, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void shouldUsePredefinedMappingForTruststoreIndex() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            String nameWhichLooksLikeDate = "2023-05-08T13:35:53.508955Z";
            TruststoreLoader.storeTruststore(client, "certificate-id-1", "certs/oneCert.pem", nameWhichLooksLikeDate);
            String pem = TruststoreLoader.loadCertificates("certs/threeCerts.pem");
            String body = DocNode.of((String)"name", (Object)"regular and valid name", (String)"pem", (Object)pem).toJsonString();
            GenericRestClient.HttpResponse response = client.putJson("/_signals/truststores/another-id", body, new Header[0]);
            log.info("Upload truststore status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    private List<DocNode> saveRandomTruststores(int noOfTruststores) throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            ImmutableMap certNoToRepresentation = ImmutableMap.of((Object)1, (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"issuer", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0", (String)"subject", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0")}), (Object)2, (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"issuer", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0", (String)"subject", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"), DocNode.of((String)"issuer", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1", (String)"subject", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1")}), (Object)3, (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"issuer", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0", (String)"subject", (Object)"CN=root.ca.number-0.com,OU=SearchGuard,O=index-0"), DocNode.of((String)"issuer", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1", (String)"subject", (Object)"CN=root.ca.number-1.com,OU=SearchGuard,O=index-1"), DocNode.of((String)"issuer", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2", (String)"subject", (Object)"CN=root.ca.number-2.com,OU=SearchGuard,O=index-2")}));
            ImmutableMap certNoToPem = ImmutableMap.of((Object)1, (Object)"certs/oneCert.pem", (Object)2, (Object)"certs/twoCerts.pem", (Object)3, (Object)"certs/threeCerts.pem");
            ArrayList<DocNode> trustStores = new ArrayList<DocNode>();
            for (int trustNo = 1; trustNo <= noOfTruststores; ++trustNo) {
                int certNo = new Random().nextInt(3) + 1;
                String trustName = "name-" + trustNo;
                TruststoreLoader.storeTruststore(client, String.valueOf(trustNo), (String)certNoToPem.get(certNo), trustName);
                trustStores.add(DocNode.of((String)"id", (Object)trustNo, (String)"name", (Object)trustName, (String)"certificates", certNoToRepresentation.get(certNo)));
            }
            ArrayList<DocNode> arrayList = trustStores;
            return arrayList;
        }
    }
}

