/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.signals.truststore.rest.CreateOrReplaceTruststoreAction;
import com.floragunn.signals.truststore.rest.TruststoreLoader;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;

public class UploadCertificatesRequestTest {
    private static final String ENCAPSULATION_BOUNDARY_BEGINNING = "-----BEGIN CERTIFICATE-----";
    private static final String ENCAPSULATION_BOUNDARY_END = "-----END CERTIFICATE-----";
    private static final String CERTIFICATE_PATTERN = "\\A-----BEGIN CERTIFICATE-----[A-Za-z0-9=+/\\v]+-----END CERTIFICATE-----\\z";

    @Test
    public void shouldSplitOneCertificate() {
        String pemCertificates = TruststoreLoader.loadCertificates("certs/oneCert.pem");
        CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest uploadCertificatesRequest = this.request(pemCertificates);
        List certificates = uploadCertificatesRequest.getCertificates();
        MatcherAssert.assertThat((Object)certificates, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)certificates.get(0)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSplitTwoCertificates() {
        String pemCertificates = TruststoreLoader.loadCertificates("certs/twoCerts.pem");
        CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest uploadCertificatesRequest = this.request(pemCertificates);
        List certificates = uploadCertificatesRequest.getCertificates();
        MatcherAssert.assertThat((Object)certificates, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((String)certificates.get(0)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)certificates.get(1)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSplitCertificates() {
        String pemCertificates = TruststoreLoader.loadCertificates("certs/threeCerts.pem");
        CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest uploadCertificatesRequest = this.request(pemCertificates);
        List certificates = uploadCertificatesRequest.getCertificates();
        MatcherAssert.assertThat((Object)certificates, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((String)certificates.get(0)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)certificates.get(1)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)certificates.get(2)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSplitCertificatesWithoutNewLines() {
        String pemCertificates = TruststoreLoader.loadCertificates("certs/threeCerts.pem").replaceAll("\\v", "");
        CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest uploadCertificatesRequest = this.request(pemCertificates);
        List certificates = uploadCertificatesRequest.getCertificates();
        MatcherAssert.assertThat((Object)certificates, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((String)certificates.get(0)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)certificates.get(1)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)certificates.get(2)).matches(CERTIFICATE_PATTERN), (Matcher)Matchers.equalTo((Object)true));
    }

    private CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest request(String pem) {
        UnparsedDocument document = (UnparsedDocument)Mockito.mock(UnparsedDocument.class);
        DocNode docNode = DocNode.of((String)"name", (Object)"my name is certificate", (String)"pem", (Object)pem);
        try {
            Mockito.when((Object)document.parseAsDocNode()).thenReturn((Object)docNode);
            return new CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest("id", document);
        }
        catch (DocumentParseException e) {
            throw new RuntimeException("Cannot create UploadCertificateRequest", e);
        }
    }
}

