/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.ack;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.NoSuchActionException;
import com.floragunn.signals.NoSuchWatchOnThisNodeException;
import com.floragunn.signals.NotAcknowledgeableException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.actions.watch.ack.AckWatchRequest;
import com.floragunn.signals.actions.watch.ack.AckWatchResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportAckWatchAction
extends TransportNodesAction<AckWatchRequest, AckWatchResponse, NodeRequest, NodeResponse, Void> {
    private static final Logger log = LogManager.getLogger(TransportAckWatchAction.class);
    private final Signals signals;
    private final ThreadPool threadPool;

    @Inject
    public TransportAckWatchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Signals signals) {
        super("cluster:admin:searchguard:tenant:signals:watch/ack", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
        this.signals = signals;
        this.threadPool = threadPool;
    }

    protected AckWatchResponse newResponse(AckWatchRequest request, List<NodeResponse> responses, List<FailedNodeException> failures) {
        return new AckWatchResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        try {
            DiscoveryNode localNode = this.clusterService.localNode();
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                return new NodeResponse(localNode, AckWatchResponse.Status.UNAUTHORIZED, "Request did not contain user");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (signalsTenant == null) {
                return new NodeResponse(localNode, AckWatchResponse.Status.NO_SUCH_TENANT, "No such tenant: " + user.getRequestedTenant());
            }
            if (request.watchId == null) {
                throw new IllegalArgumentException("request.watchId is null");
            }
            if (!signalsTenant.runsWatchLocally(request.watchId)) {
                return new NodeResponse(localNode, AckWatchResponse.Status.NO_SUCH_WATCH, "This node does not run " + request.watchId);
            }
            if (request.actionId != null) {
                try {
                    if (request.ack) {
                        signalsTenant.ack(request.watchId, request.actionId, user);
                        return new NodeResponse(localNode, AckWatchResponse.Status.SUCCESS, "Acknowledged");
                    }
                    signalsTenant.unack(request.watchId, request.actionId, user);
                    return new NodeResponse(localNode, AckWatchResponse.Status.SUCCESS, "Un-acknowledged");
                }
                catch (IllegalStateException e) {
                    return new NodeResponse(localNode, AckWatchResponse.Status.ILLEGAL_STATE, e.getMessage());
                }
            }
            if (request.ack) {
                ArrayList<String> ackedActions = new ArrayList<String>(signalsTenant.ack(request.watchId, user).keySet());
                if (ackedActions.size() == 0) {
                    return new NodeResponse(localNode, AckWatchResponse.Status.ILLEGAL_STATE, "No actions are in an acknowlegable state");
                }
                return new NodeResponse(localNode, AckWatchResponse.Status.SUCCESS, "Acknowledged: " + String.valueOf(ackedActions));
            }
            List<String> unackedActions = signalsTenant.unack(request.watchId, user);
            if (unackedActions.size() == 0) {
                return new NodeResponse(localNode, AckWatchResponse.Status.ILLEGAL_STATE, "No actions are in an un-acknowlegable state");
            }
            return new NodeResponse(localNode, AckWatchResponse.Status.SUCCESS, "Un-acknowledged: " + String.valueOf(unackedActions));
        }
        catch (NoSuchWatchOnThisNodeException e) {
            return new NodeResponse(this.clusterService.localNode(), AckWatchResponse.Status.ILLEGAL_STATE, "The watch has not been initialized yet");
        }
        catch (NoSuchActionException e) {
            return new NodeResponse(this.clusterService.localNode(), AckWatchResponse.Status.NO_SUCH_ACTION, e.getMessage());
        }
        catch (NotAcknowledgeableException e) {
            return new NodeResponse(this.clusterService.localNode(), AckWatchResponse.Status.NOT_ACKNOWLEDGEABLE, e.getMessage());
        }
        catch (Exception e) {
            log.error("Error while acknowledging " + String.valueOf((Object)request), (Throwable)e);
            return new NodeResponse(this.clusterService.localNode(), AckWatchResponse.Status.EXCEPTION, e.toString());
        }
    }

    protected NodeRequest newNodeRequest(AckWatchRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private AckWatchResponse.Status status;
        private String message;

        public NodeResponse(DiscoveryNode node, AckWatchResponse.Status status, String message) {
            super(node);
            this.status = status;
            this.message = message;
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.status = (AckWatchResponse.Status)in.readEnum(AckWatchResponse.Status.class);
            this.message = in.readOptionalString();
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse result = new NodeResponse(in);
            return result;
        }

        public String getMessage() {
            return this.message;
        }

        public AckWatchResponse.Status getStatus() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.message);
        }

        public String toString() {
            return "NodeResponse [status=" + String.valueOf((Object)this.status) + ", message=" + this.message + "]";
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private String watchId;
        private String actionId;
        private boolean ack;

        public NodeRequest(AckWatchRequest request) {
            this.watchId = request.getWatchId();
            this.actionId = request.getActionId();
            this.ack = request.isAck();
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.watchId = in.readString();
            this.ack = in.readBoolean();
            this.actionId = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.watchId);
            out.writeBoolean(this.ack);
            out.writeOptionalString(this.actionId);
        }
    }
}

