/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.delete;

import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateAction;
import com.floragunn.signals.NoSuchTenantException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.SignalsUnavailableException;
import com.floragunn.signals.actions.watch.delete.DeleteWatchRequest;
import com.floragunn.signals.actions.watch.delete.DeleteWatchResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;

public class TransportDeleteWatchAction
extends HandledTransportAction<DeleteWatchRequest, DeleteWatchResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeleteWatchAction.class);
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportDeleteWatchAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:tenant:signals:watch/delete", transportService, actionFilters, DeleteWatchRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, final DeleteWatchRequest request, final ActionListener<DeleteWatchResponse> listener) {
        try {
            final ThreadContext threadContext = this.threadPool.getThreadContext();
            final User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                listener.onResponse((Object)new DeleteWatchResponse(request.getWatchId(), -1L, DocWriteResponse.Result.NOOP, RestStatus.UNAUTHORIZED, "Request did not contain user"));
                return;
            }
            final SignalsTenant signalsTenant = this.signals.getTenant(user);
            final Object originalRemoteAddress = threadContext.getTransient("_sg_remote_address");
            final Object originalOrigin = threadContext.getTransient("_sg_origin");
            final Map originalResponseHeaders = threadContext.getResponseHeaders();
            try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", originalRemoteAddress);
                threadContext.putTransient("_sg_origin", originalOrigin);
                originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
                final String idInIndex = signalsTenant.getWatchIdForConfigIndex(request.getWatchId());
                ((DeleteRequestBuilder)this.client.prepareDelete().setIndex(signalsTenant.getConfigIndexName())).setId(idInIndex).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute((ActionListener)new ActionListener<DeleteResponse>(){

                    public void onResponse(DeleteResponse response) {
                        if (response.getResult() == DocWriteResponse.Result.DELETED) {
                            SchedulerConfigUpdateAction.send((Client)TransportDeleteWatchAction.this.client, (String)signalsTenant.getScopedName());
                        }
                        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                            threadContext.putHeader("_sg_conf_request", "true");
                            threadContext.putTransient("_sg_user", (Object)user);
                            threadContext.putTransient("_sg_remote_address", originalRemoteAddress);
                            threadContext.putTransient("_sg_origin", originalOrigin);
                            originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
                            ((DeleteRequestBuilder)TransportDeleteWatchAction.this.client.prepareDelete().setIndex(signalsTenant.getSettings().getStaticSettings().getIndexNames().getWatchesState())).setId(idInIndex).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute((ActionListener)new ActionListener<DeleteResponse>(){

                                public void onResponse(DeleteResponse response) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Result of deleting state " + idInIndex + "\n" + Strings.toString((ToXContent)response));
                                    }
                                }

                                public void onFailure(Exception e) {
                                    log.error("Error while deleting state " + idInIndex, (Throwable)e);
                                }
                            });
                        }
                        listener.onResponse((Object)new DeleteWatchResponse(request.getWatchId(), response.getVersion(), response.getResult(), response.status(), null));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (NoSuchTenantException e) {
            listener.onResponse((Object)new DeleteWatchResponse(request.getWatchId(), -1L, DocWriteResponse.Result.NOT_FOUND, RestStatus.NOT_FOUND, e.getMessage()));
        }
        catch (SignalsUnavailableException e) {
            listener.onFailure((Exception)((Object)e.toElasticsearchException()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

